/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.ioc;

import com.ajaxjs.Version;
import com.ajaxjs.util.Encode;
import com.ajaxjs.util.logger.LogHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class EveryClass {
    private static final LogHelper LOGGER = LogHelper.getLog(EveryClass.class);
    private Consumer<String> addResult;
    private static final FileFilter fileFilter = file -> file.isDirectory() || file.getName().endsWith(".class");

    public void scan(String packageName, Consumer<String> addResult) {
        packageName = packageName.trim();
        this.addResult = addResult;
        String packageDir = packageName.replace('.', '/');
        Enumeration<URL> resources = EveryClass.getResources(packageDir);
        LOGGER.info("\u6b63\u5728\u626b\u63cf\u5305 [{0}]", packageDir);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            switch (url.getProtocol()) {
                case "file": {
                    String filePath = Encode.urlDecode(url.getPath());
                    this.findInFile(filePath, packageName);
                    break;
                }
                case "jar": 
                case "zip": {
                    this.findInJar(url, packageDir, packageName);
                }
            }
        }
    }

    private static Enumeration<URL> getResources(String packageDir) {
        Enumeration<URL> url = null;
        try {
            url = Thread.currentThread().getContextClassLoader().getResources(packageDir);
            Objects.requireNonNull(url, packageDir + "\u6ca1\u6709\u8fd9\u4e2a Java \u76ee\u5f55\u3002");
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
        return url;
    }

    private void findInFile(String filePath, String packageName) {
        File dir = new File(filePath);
        if (!dir.exists() || !dir.isDirectory()) {
            LOGGER.warning("\u5305{0}\u4e0b\u6ca1\u6709\u4efb\u4f55\u6587\u4ef6{1}", filePath, packageName);
            return;
        }
        for (File file : dir.listFiles(fileFilter)) {
            if (file.isDirectory()) {
                this.findInFile(file.getAbsolutePath(), packageName + "." + file.getName());
                continue;
            }
            this.addResult.accept(EveryClass.getClassName(file, packageName));
        }
    }

    private void findInJar(URL url, String packageDir, String packageName) {
        String fileUrl = url.getFile().replace("!/" + packageDir, "").replace("file:/", "");
        fileUrl = Version.isWindows ? fileUrl : "/" + fileUrl;
        JarFile jar = null;
        try {
            jar = new JarFile(new File(fileUrl));
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            int idx;
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (!name.startsWith(packageDir) || (idx = name.lastIndexOf(47)) == -1) continue;
            packageName = name.substring(0, idx).replace('/', '.');
            if (!name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(packageName.length() + 1, name.length() - 6);
            this.addResult.accept(packageName + '.' + className);
        }
    }

    public static String getResourcesFromClasspath(String resource, boolean isDecode) {
        URL url = EveryClass.class.getClassLoader().getResource(resource);
        return EveryClass.url2path(url, isDecode);
    }

    public static String getResourcesFromClass(Class<?> clz, String resource) {
        return EveryClass.getResourcesFromClass(clz, resource, true);
    }

    public static String getResourcesFromClass(Class<?> clz, String resource, boolean isDecode) {
        return EveryClass.url2path(clz.getResource(resource), isDecode);
    }

    public static String getResourcesFromClasspath(String resource) {
        return EveryClass.getResourcesFromClasspath(resource, true);
    }

    private static String url2path(URL url, boolean isDecode) {
        String path;
        if (url == null) {
            return null;
        }
        path = isDecode ? Encode.urlDecode(new File(url.getPath()).toString()) : ((path = url.getPath()).startsWith("/") ? path.substring(1) : path);
        return path;
    }

    public static String getClassName(File file, String packageName) {
        String clzName = file.getName().substring(0, file.getName().length() - 6);
        return packageName + '.' + clzName;
    }
}

