/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.logger;

import com.ajaxjs.Version;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.logger.FileHandler;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogHelper {
    private static final int NORMAL = 0;
    private static final int BRIGHT = 1;
    private static final int FOREGROUND_RED = 31;
    private static final int FOREGROUND_GREEN = 32;
    private static final int FOREGROUND_YELLOW = 33;
    private static final int FOREGROUND_CYAN = 36;
    private static final String PREFIX = "\u001b[";
    private static final String SUFFIX = "m ";
    private static final char SEPARATOR = ';';
    private static final String WARN_COLOUR = "\u001b[0;33m ";
    private static final String INFO_COLOUR = "\u001b[0;32m ";
    private static final String FATAL_COLOUR = "\u001b[1;31m ";
    private static final String COLOUR_END = "\u001b[0m";
    private static final String DEBUG_COLOUR = "\u001b[0;36m ";
    private String className;
    private Logger logger;
    private static final Filter filter = new Filter(){

        @Override
        public boolean isLoggable(LogRecord record) {
            return record.getMessage() != null && !record.getMessage().contains("no log");
        }
    };

    public LogHelper(Class<?> clazz) {
        this.className = clazz.getName().trim();
        this.logger = Logger.getLogger(this.className);
        this.logger.setFilter(filter);
        if (!Version.isDebug) {
            String logFolder = null;
            if (CommonUtil.isEmptyString(logFolder)) {
                logFolder = LogHelper.class.getClassLoader().getResource("").getPath();
                logFolder = new File(logFolder).toString();
                logFolder = logFolder.replace("classes", "LogHelper");
            }
            this.logger.addHandler(new FileHandler(logFolder, null, ".log"));
        }
    }

    public static void p(Object ... msg) {
        Logger.getGlobal().info(Arrays.toString(msg));
    }

    public static LogHelper getLog(Class<?> clazz) {
        return new LogHelper(clazz);
    }

    public void logMsg(Level level, String msg) {
        this.logger.logp(level, this.className, this.getMethodName(), msg);
    }

    public void logMsg(Level level, String msgTpl, Object ... params) {
        this.logger.logp(level, this.className, this.getMethodName(), msgTpl, params);
    }

    public void debug(String msg) {
        if (Version.isDebug) {
            this.info(msg);
        }
    }

    public void debug(String msgTpl, Object ... params) {
        if (Version.isDebug) {
            this.info(msgTpl, params);
        }
    }

    public void info(String msg) {
        this.logMsg(Level.INFO, DEBUG_COLOUR + msg + COLOUR_END);
    }

    public void info(String msgTpl, Object ... params) {
        this.logMsg(Level.INFO, DEBUG_COLOUR + msgTpl + COLOUR_END, params);
    }

    public void infoGreen(String msg) {
        this.info(INFO_COLOUR + msg + COLOUR_END);
    }

    public void infoYellow(String msg) {
        this.info(WARN_COLOUR + msg + COLOUR_END);
    }

    public void infoCYAN(String msg) {
        this.info(DEBUG_COLOUR + msg + COLOUR_END);
    }

    public void warning(String msg) {
        this.logMsg(Level.WARNING, FATAL_COLOUR + msg + COLOUR_END);
    }

    public void warning(String msgTpl, Object ... params) {
        this.logMsg(Level.WARNING, FATAL_COLOUR + msgTpl + COLOUR_END, params);
    }

    public void warning(Throwable ex, String msg) {
        this.logger.logp(Level.WARNING, this.className, this.getMethodName(), FATAL_COLOUR + msg + COLOUR_END, ex);
    }

    public void warning(Throwable e, String msg, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            msg = msg.replace("{" + i + "}", params[i] == null ? "[NULL]" : params[i].toString());
        }
        this.warning(e, msg);
    }

    public void warning(Throwable e) {
        this.warning(e, e.getMessage());
    }

    private String getMethodName() {
        StackTraceElement frame = null;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            String clzName = ste.getClassName();
            if (ste.isNativeMethod() || clzName.equals(Thread.class.getName()) || clzName.equals(this.getClass().getName()) || !clzName.equals(this.className)) continue;
            frame = ste;
            break;
        }
        if (frame != null) {
            return String.format(".%s(%s:%s)", frame.getMethodName(), frame.getFileName(), frame.getLineNumber());
        }
        return null;
    }
}

