/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.map;

import com.ajaxjs.framework.BaseModel;
import com.ajaxjs.jsonparser.syntax.FMS;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.MappingValue;
import com.ajaxjs.util.map.MapTool;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;

public class JsonHelper {
    public static Object parse(String str) {
        return new FMS(str).parse();
    }

    public static Map<String, Object> parseMap(String str) {
        return (Map)JsonHelper.parse(str);
    }

    public static <T> T parseMapAsBean(String json, Class<T> clz) {
        Map<String, Object> map = JsonHelper.parseMap(json);
        return MapTool.map2Bean(map, clz, true);
    }

    public static List<Map<String, Object>> parseList(String str) {
        return (List)JsonHelper.parse(str);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean || obj instanceof Number) {
            return obj.toString();
        }
        if (obj instanceof String) {
            return '\"' + obj.toString().replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r") + '\"';
        }
        if (obj instanceof String[]) {
            return JsonHelper.jsonArr((String[])obj, v -> "\"" + v + "\"");
        }
        if (obj.getClass() == Integer[].class) {
            return JsonHelper.jsonArr((Integer[])obj, v -> v + "");
        }
        if (obj.getClass() == int[].class) {
            Integer[] arr = (Integer[])Arrays.stream((int[])obj).boxed().toArray(Integer[]::new);
            return JsonHelper.jsonArr(arr, v -> v + "");
        }
        if (obj instanceof Long[]) {
            return JsonHelper.jsonArr((Long[])obj, v -> v.toString());
        }
        if (obj instanceof long[]) {
            Long[] arr = (Long[])Arrays.stream((long[])obj).boxed().toArray(Long[]::new);
            return JsonHelper.jsonArr(arr, v -> v.toString());
        }
        if (obj instanceof Date) {
            return '\"' + CommonUtil.simpleDateFormatFactory("yyyy-MM-dd HH:mm:ss").format((Date)obj) + '\"';
        }
        if (obj instanceof Map) {
            return JsonHelper.stringifyMap((Map)obj);
        }
        if (obj instanceof Map[]) {
            return JsonHelper.jsonArr((Map[])obj, JsonHelper::stringifyMap);
        }
        if (obj instanceof BaseModel) {
            return JsonHelper.beanToJson((BaseModel)obj);
        }
        if (obj instanceof BaseModel[]) {
            return JsonHelper.jsonArr((BaseModel[])obj, JsonHelper::beanToJson);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            if (list.size() <= 0) return "[]";
            if (list.get(0) instanceof Integer) {
                return JsonHelper.toJson(list.toArray(new Integer[list.size()]));
            }
            if (list.get(0) instanceof String) {
                return JsonHelper.toJson(list.toArray(new String[list.size()]));
            }
            if (list.get(0) instanceof Map) {
                return JsonHelper.toJson(list.toArray(new Map[list.size()]));
            }
            if (!(list.get(0) instanceof BaseModel)) return null;
            return JsonHelper.toJson(list.toArray(new BaseModel[list.size()]));
        }
        if (obj instanceof Object[]) {
            return JsonHelper.jsonArr((Object[])obj, JsonHelper::toJson);
        }
        if (!(obj instanceof Object)) return null;
        ArrayList<String> arr = new ArrayList<String>();
        for (Field field : obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String key = field.getName();
            if (key.indexOf("this$") != -1) continue;
            Object _obj = null;
            try {
                _obj = field.get(obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            arr.add('\"' + key + "\":" + JsonHelper.toJson(_obj));
        }
        return '{' + String.join((CharSequence)",", arr) + '}';
    }

    public static <T> String jsonArr(T[] o, Function<T, String> fn) {
        if (o.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < o.length; ++i) {
            sb.append(fn.apply(o[i]));
            if (i == o.length - 1) continue;
            sb.append(", ");
        }
        return '[' + sb.toString() + ']';
    }

    static <T> String eachList(List<T> list, Function<T, String> fn) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(fn.apply(list.get(i)));
            if (i == list.size() - 1) continue;
            sb.append(", ");
        }
        return '[' + sb.toString() + ']';
    }

    private static String stringifyMap(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        if (map.size() == 0) {
            return "{}";
        }
        ArrayList<String> arr = new ArrayList<String>();
        for (Object key : map.keySet()) {
            arr.add('\"' + key.toString() + "\":" + JsonHelper.toJson(map.get(key)));
        }
        return '{' + String.join((CharSequence)",", arr) + '}';
    }

    private static String beanToJson(Object bean) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        PropertyDescriptor[] props = null;
        try {
            props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                try {
                    String name = "\"" + props[i].getName() + "\"";
                    String value = JsonHelper.toJson(props[i].getReadMethod().invoke(bean, new Object[0]));
                    json.append(name);
                    json.append(":");
                    json.append(value);
                    json.append(",");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            json.setCharAt(json.length() - 1, '}');
        } else {
            json.append("}");
        }
        return json.toString();
    }

    public static String format(String json) {
        int level = 0;
        StringBuilder str = new StringBuilder();
        block5: for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (level > 0 && '\n' == str.charAt(str.length() - 1)) {
                str.append(CommonUtil.repeatStr("\t", "", level));
            }
            switch (c) {
                case '[': 
                case '{': {
                    str.append(c + "\n");
                    ++level;
                    continue block5;
                }
                case ',': {
                    if (json.charAt(i + 1) != '\"') continue block5;
                    str.append(c + "\n");
                    continue block5;
                }
                case ']': 
                case '}': {
                    str.append("\n");
                    str.append(CommonUtil.repeatStr("\t", "", --level));
                    str.append(c);
                    continue block5;
                }
                default: {
                    str.append(c);
                }
            }
        }
        return str.toString();
    }

    public static String removeComemnt(String str) {
        return str.replaceAll("\\/\\/[^\\n]*|\\/\\*([^\\*^\\/]*|[\\*^\\/*]*|[^\\**\\/]*)*\\*+\\/", "");
    }

    public static String jsonString_covernt(String str) {
        return str.replace("\r\n", "\\n");
    }

    public static String javaValue2jsonValue(String str) {
        return str.replaceAll("\"", "\\\\\"").replaceAll("\t", "\\\\\t");
    }

    private static boolean hasQuoataion(char c) {
        return c != '\"' && c != '\'';
    }

    public static Object json2Map(String jsonStr) {
        if (CommonUtil.isEmptyString(jsonStr)) {
            return null;
        }
        Stack maps = new Stack();
        Stack lists = new Stack();
        Stack<Boolean> isList = new Stack<Boolean>();
        Stack<String> keys = new Stack<String>();
        boolean hasQuoataion = false;
        String keytmp = null;
        String valuetmp = null;
        StringBuilder sb = new StringBuilder();
        char[] cs = jsonStr.toCharArray();
        block9: for (int i = 0; i < cs.length; ++i) {
            char c = cs[i];
            if (c == ' ') continue;
            if (hasQuoataion) {
                if (JsonHelper.hasQuoataion(cs[i])) {
                    sb.append(cs[i]);
                    continue;
                }
                hasQuoataion = false;
                continue;
            }
            switch (cs[i]) {
                case '{': {
                    maps.push(new HashMap());
                    isList.push(false);
                    continue block9;
                }
                case '\"': 
                case '\'': {
                    hasQuoataion = true;
                    continue block9;
                }
                case ':': {
                    keys.push(sb.toString());
                    sb = new StringBuilder();
                    continue block9;
                }
                case '[': {
                    lists.push(new ArrayList());
                    isList.push(true);
                    continue block9;
                }
                case ',': {
                    if (sb.length() > 0) {
                        valuetmp = sb.toString();
                    }
                    sb = new StringBuilder();
                    boolean listis = (Boolean)isList.peek();
                    if (!listis) {
                        keytmp = (String)keys.pop();
                        if (valuetmp instanceof String) {
                            ((Map)maps.peek()).put(keytmp, MappingValue.toJavaValue(valuetmp.toString()));
                            continue block9;
                        }
                        ((Map)maps.peek()).put(keytmp, valuetmp);
                        continue block9;
                    }
                    ((List)lists.peek()).add(valuetmp);
                    continue block9;
                }
                case ']': {
                    isList.pop();
                    if (sb.length() > 0) {
                        valuetmp = sb.toString();
                    }
                    sb = new StringBuilder();
                    ((List)lists.peek()).add(valuetmp);
                    valuetmp = lists.pop();
                    continue block9;
                }
                case '}': {
                    isList.pop();
                    keytmp = (String)keys.pop();
                    if (sb.length() > 0) {
                        valuetmp = sb.toString();
                    }
                    sb = new StringBuilder();
                    ((Map)maps.peek()).put(keytmp, valuetmp);
                    valuetmp = maps.pop();
                    continue block9;
                }
                default: {
                    sb.append(cs[i]);
                    continue block9;
                }
            }
        }
        return valuetmp;
    }
}

