/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.map;

import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.MappingValue;
import com.ajaxjs.util.ReflectUtil;
import com.ajaxjs.util.XmlHelper;
import com.ajaxjs.util.logger.LogHelper;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MapTool {
    private static final LogHelper LOGGER = LogHelper.getLog(MapTool.class);

    public static <T> String join(Map<String, T> map, String div, Function<T, String> fn) {
        CharSequence[] pairs = new String[map.size()];
        int i = 0;
        for (String key : map.keySet()) {
            pairs[i++] = key + "=" + fn.apply(map.get(key));
        }
        return String.join((CharSequence)div, pairs);
    }

    public static <T> String join(Map<String, T> map, Function<T, String> fn) {
        return MapTool.join(map, "&", fn);
    }

    public static <T> String join(Map<String, T> map, String div) {
        return MapTool.join(map, div, v -> v == null ? null : v.toString());
    }

    public static <T> String join(Map<String, T> map) {
        return MapTool.join(map, "&");
    }

    public static Map<String, Object> toMap(String[] pairs, Function<String, Object> fn) {
        if (CommonUtil.isNull(pairs)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String pair : pairs) {
            if (!pair.contains("=")) {
                throw new IllegalArgumentException("\u6ca1\u6709 = \u4e0d\u80fd\u8f6c\u5316\u4e3a map");
            }
            String[] column = pair.split("=");
            if (column.length >= 2) {
                map.put(column[0], fn == null ? column[1] : fn.apply(column[1]));
                continue;
            }
            map.put(column[0], "");
        }
        return map;
    }

    public static Map<String, Object> toMap(String[] columns, String[] values, Function<String, Object> fn) {
        if (CommonUtil.isNull(columns)) {
            return null;
        }
        if (columns.length != values.length) {
            throw new UnsupportedOperationException("\u4e24\u4e2a\u6570\u7ec4 size \u4e0d\u4e00\u6837");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        for (String column : columns) {
            map.put(column, fn.apply(values[i++]));
        }
        return map;
    }

    public static <T> void getValue(Map<String, T> map, String key, Consumer<T> s) {
        T value;
        if (map != null && (value = map.get(key)) != null) {
            s.accept(value);
        }
    }

    public static <T, K> Map<String, T> as(Map<String, K> map, Function<K, T> fn) {
        HashMap _map = new HashMap();
        map.forEach((k, v) -> _map.put(k, v == null ? null : (Object)fn.apply(v)));
        return _map;
    }

    public static Map<String, Object> as(Map<String, String[]> map) {
        return MapTool.as(map, arr -> MappingValue.toJavaValue(arr[0]));
    }

    public static void eachField(Object bean, EachFieldArg fn) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                Method getter = property.getReadMethod();
                Object value = getter.invoke(bean, new Object[0]);
                fn.item(key, value, property);
            }
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOGGER.warning(e);
        }
    }

    public static <T> T map2Bean(Map<String, ?> map, Class<T> clz, boolean isTransform) {
        Object bean = ReflectUtil.newInstance(clz, new Object[0]);
        MapTool.eachField(bean, (key, v, property) -> {
            try {
                Object value;
                if (map.containsKey(key) && (value = map.get(key)) != null) {
                    Class<?> t = property.getPropertyType();
                    if (isTransform && t != value.getClass()) {
                        value = MappingValue.objectCast(value, t);
                    }
                    property.getWriteMethod().invoke(bean, value);
                }
                for (String mKey : map.keySet()) {
                    if (!mKey.contains(key + '_')) continue;
                    Method getter = property.getReadMethod();
                    Method setter = property.getWriteMethod();
                    Object subBean = getter.invoke(bean, new Object[0]);
                    String subBeanKey = mKey.replaceAll(key + '_', "");
                    if (subBean != null) {
                        if (map.get(mKey) == null) continue;
                        ReflectUtil.setProperty(subBean, subBeanKey, map.get(mKey));
                        continue;
                    }
                    HashMap subMap = new HashMap();
                    subMap.put(subBeanKey, map.get(mKey));
                    subBean = MapTool.map2Bean(subMap, setter.getParameterTypes()[0], isTransform);
                    setter.invoke(bean, subBean);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                if (e instanceof IllegalArgumentException) {
                    LOGGER.warning("[{0}]\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8f93\u5165\u503c\u662f[{1}]", key, v);
                }
                LOGGER.warning(e);
            }
        });
        return bean;
    }

    public static <T> T map2Bean(Map<String, ?> map, Class<T> clz) {
        return MapTool.map2Bean(map, clz, false);
    }

    public static <T> Map<String, Object> bean2Map(T bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MapTool.eachField(bean, (k, v, property) -> {
            if (!k.equals("class")) {
                map.put(k, v);
            }
        });
        return map;
    }

    public static String beanToXml(Object bean) {
        return MapTool.mapToXml(MapTool.bean2Map(bean));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String mapToXml(Map<String, ?> data) {
        Document doc = XmlHelper.initBuilder().newDocument();
        Element root = doc.createElement("xml");
        doc.appendChild(root);
        data.forEach((k, v) -> {
            String value = data.get(k).toString();
            if (value == null) {
                value = "";
            }
            Element filed = doc.createElement((String)k);
            filed.appendChild(doc.createTextNode(value.trim()));
            root.appendChild(filed);
        });
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            try (StringWriter writer = new StringWriter();){
                String output;
                transformer.transform(new DOMSource(doc), new StreamResult(writer));
                String string = output = writer.getBuffer().toString();
                return string;
            }
        }
        catch (IOException | TransformerException | TransformerFactoryConfigurationError e) {
            LOGGER.warning(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> xmlToMap(String strXML) {
        if (strXML == null) {
            return null;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(strXML.getBytes("UTF-8"));){
            Document doc = XmlHelper.initBuilder().parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                data.put(element.getNodeName(), element.getTextContent());
            }
            HashMap<String, String> hashMap = data;
            return hashMap;
        }
        catch (IOException | SAXException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    @FunctionalInterface
    public static interface EachFieldArg {
        public void item(String var1, Object var2, PropertyDescriptor var3);
    }
}

