/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class UserAgent {
    private String ua;

    public UserAgent(HttpServletRequest req) {
        String ua = req.getHeader("User-Agent");
        if (ua != null) {
            this.ua = ua.toLowerCase();
        }
    }

    public boolean isIE() {
        return this.ua.contains("msie");
    }

    public boolean isOldIE() {
        return this.isIE() && (this.ua.contains("msie 5.5") || this.ua.contains("msie 6.0") || this.ua.contains("msie 7.0") || this.ua.contains("msie 8.0"));
    }

    public boolean isFireFox() {
        return this.ua.contains("firefox");
    }

    public boolean isChrome() {
        return this.ua.contains("chrome");
    }

    public boolean isAndroid() {
        return this.ua.contains("android");
    }

    public boolean isAndroid_7() {
        boolean is7 = Pattern.compile("Android\\s7", 2).matcher(this.ua).find();
        return this.isAndroid() && is7;
    }

    public boolean isIPhone() {
        return this.ua.contains("iphone");
    }

    public boolean isIPad() {
        return this.ua.contains("ipad");
    }

    public boolean isIOS() {
        return this.isIPad() || this.isIPhone();
    }

    public boolean isPhone() {
        return this.isAndroid() || this.isIOS();
    }

    public boolean isWeixin() {
        return this.ua.contains("micromessenger");
    }
}

