/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.mock;

import java.io.IOException;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;

public class MockFilter {
    public static String doRequest(HttpServletRequest request, HttpServletResponse response) {
        DummyController controller = new DummyController();
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        DummyFilter filter = new DummyFilter();
        try {
            controller.init(MockFilter.initServletConfig(DummyController.class));
            filter.init(MockFilter.initFilterConfig(controller.getServletContext()));
            filter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
            controller.doGet(request, response);
            return response.getWriter().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ServletConfig initServletConfig(Class<? extends HttpServlet> cls) {
        ServletConfig servletConfig = (ServletConfig)Mockito.mock(ServletConfig.class);
        Vector<String> v = new Vector<String>();
        if (cls != null) {
            WebServlet WebServlet_an = cls.getAnnotation(WebServlet.class);
            for (WebInitParam p : WebServlet_an.initParams()) {
                v.addElement(p.name());
                Mockito.when((Object)servletConfig.getInitParameter(p.name())).thenReturn((Object)p.value());
            }
        }
        Mockito.when((Object)servletConfig.getInitParameterNames()).thenReturn(v.elements());
        return servletConfig;
    }

    public static FilterConfig initFilterConfig(ServletContext context) {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Vector<String> v = new Vector<String>();
        v.addElement("urlPatterns");
        Mockito.when((Object)filterConfig.getInitParameterNames()).thenReturn(v.elements());
        Mockito.when((Object)filterConfig.getInitParameter("urlPatterns")).thenReturn((Object)"/service/*");
        Mockito.when((Object)filterConfig.getServletContext()).thenReturn((Object)context);
        return filterConfig;
    }

    public static class DummyFilter
    implements Filter {
        public void destroy() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            chain.doFilter(request, response);
        }

        public void init(FilterConfig fConfig) throws ServletException {
        }
    }

    public static class DummyController
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.getWriter().append("Served at: ").append(request.getContextPath());
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.doGet(request, response);
        }
    }
}

