/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.mock;

import com.ajaxjs.util.map.JsonHelper;
import com.ajaxjs.util.map.MapTool;
import com.ajaxjs.web.mock.BaseControllerTest;
import com.ajaxjs.web.mock.MockResponse;
import com.ajaxjs.web.mock.MockServletInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockRequest
extends HttpServletRequestWrapper {
    public BaseControllerTest testInstance;
    public HttpServletRequest old;

    public MockRequest(HttpServletRequest request) {
        super(request);
    }

    public MockRequest(BaseControllerTest testInstance, String contextPath, String path) {
        this((HttpServletRequest)Mockito.mock(HttpServletRequest.class), testInstance, contextPath, path);
    }

    public MockRequest(HttpServletRequest request, BaseControllerTest testInstance, String contextPath, String path) {
        super(request);
        this.old = request;
        Mockito.when((Object)this.getPathInfo()).thenReturn((Object)(contextPath + path));
        Mockito.when((Object)this.getRequestURI()).thenReturn((Object)(contextPath + path));
        Mockito.when((Object)this.getContextPath()).thenReturn((Object)contextPath);
        testInstance.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        testInstance.writer = MockResponse.writerFactory(testInstance.response);
        this.testInstance = testInstance;
    }

    public MockRequest setSession(Map<String, Object> sessionMap) {
        MockRequest.mockSession((HttpServletRequest)this, sessionMap);
        return this;
    }

    public MockRequest setMethod(String string) {
        Mockito.when((Object)this.getMethod()).thenReturn((Object)string);
        return this;
    }

    public MockRequest setHeader(String header, String value) {
        Mockito.when((Object)this.getHeader(header)).thenReturn((Object)value);
        return this;
    }

    public MockRequest setParameterMap(Map<String, String[]> parameterMap) {
        Mockito.when((Object)this.getParameterMap()).thenReturn(parameterMap);
        return this;
    }

    public MockRequest setParameter(Map<String, String> parameter) {
        parameter.forEach((k, v) -> Mockito.when((Object)this.getParameter((String)k)).thenReturn(v));
        return this;
    }

    public MockRequest setParameter(String key, String value) {
        Mockito.when((Object)this.getParameter(key)).thenReturn((Object)value);
        return this;
    }

    public String getRequestDispatcheResult() {
        return MockResponse.getRequestDispatcheResult(this.old);
    }

    public String getStringResult() {
        return this.testInstance.writer.toString();
    }

    public Map<String, Object> getStringResultJson() {
        return JsonHelper.parseMap(this.getStringResult());
    }

    public MockRequest setRequestAttribute(String ... keys) {
        MockRequest.mockRequestAttribute(this.old, keys);
        return this;
    }

    public static void mockRequestAttribute(HttpServletRequest request, String ... keys) {
        final HashMap hash = new HashMap();
        ((HttpServletRequest)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                String key = (String)invocation.getArgumentAt(0, String.class);
                Object value = invocation.getArgumentAt(1, Object.class);
                hash.put(key, value);
                return null;
            }
        }).when((Object)request)).setAttribute(Matchers.anyString(), Matchers.anyObject());
        Answer<Object> aswser = new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                Object obj = hash.get(args[0].toString());
                return obj;
            }
        };
        for (String key : keys) {
            ((HttpServletRequest)Mockito.doAnswer((Answer)aswser).when((Object)request)).getAttribute(key);
        }
    }

    public static void mockSession(HttpServletRequest request, final Map<String, Object> map) {
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        Mockito.when((Object)request.getSession()).thenReturn((Object)session);
        Mockito.when((Object)session.getAttribute(Matchers.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock in) throws Throwable {
                String key = (String)in.getArguments()[0];
                return map.get(key);
            }
        });
        ((HttpSession)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock in) throws Throwable {
                String key = (String)in.getArguments()[0];
                Object value = in.getArguments()[1];
                map.put(key, value);
                return null;
            }
        }).when((Object)session)).setAttribute(Matchers.anyString(), Matchers.anyObject());
    }

    public static HttpServletRequest mockRequest(String contextPath, String path) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)(contextPath + path));
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)(contextPath + path));
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)contextPath);
        return request;
    }

    public static HttpServletRequest mockFormRequest(HttpServletRequest request, Map<String, String> formBody, boolean isByGetParams) throws IOException {
        if (isByGetParams) {
            formBody.forEach((k, v) -> Mockito.when((Object)request.getParameter(k)).thenReturn(v));
        } else {
            String form = MapTool.join(formBody, "&");
            Mockito.when((Object)request.getInputStream()).thenReturn((Object)new MockServletInputStream(form.getBytes()));
        }
        return request;
    }
}

