/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.mvc;

import com.ajaxjs.util.ReflectUtil;
import com.ajaxjs.util.ioc.Component;
import com.ajaxjs.util.ioc.ComponentMgr;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.web.mvc.IController;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;

public class Action {
    private static final LogHelper LOGGER = LogHelper.getLog(Action.class);
    public String path;
    public Map<String, Action> children;
    private boolean isAll;
    public IController controller;
    public IController getMethodController;
    public IController postMethodController;
    public IController putMethodController;
    public IController deleteMethodController;
    public Method getMethod;
    public Method postMethod;
    public Method putMethod;
    public Method deleteMethod;

    public void createControllerInstance(Class<? extends IController> clz) {
        if (clz.getAnnotation(Component.class) != null) {
            this.controller = ComponentMgr.get(clz);
            if (this.controller == null) {
                LOGGER.warning("\u5728 IOC \u8d44\u6e90\u5e93\u4e2d\u627e\u4e0d\u5230\u8be5\u7c7b {0} \u7684\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5\u8be5\u7c7b\u662f\u5426\u5df2\u7ecf\u52a0\u5165\u4e86 IOC \u626b\u63cf\uff1f  The IOC library not found that Controller, plz check if it added to the IOC scan.", clz.getName());
            }
        } else {
            this.controller = ReflectUtil.newInstance(clz, new Object[0]);
        }
    }

    public void parseMethod() {
        Class<?> clz = this.controller.getClass();
        String topPath = null;
        for (Method method : clz.getMethods()) {
            Path subPath = null;
            try {
                subPath = method.getAnnotation(Path.class);
            }
            catch (Throwable e) {
                LOGGER.warning(e);
            }
            if (subPath != null) {
                Action subAction;
                String subPathValue = subPath.value();
                if (subPathValue.startsWith("/")) {
                    if ((subPathValue = subPathValue.replaceAll("^/", "")).contains("{root}")) {
                        if (topPath == null) {
                            topPath = Action.getRootPath(clz);
                        }
                        subPathValue = subPathValue.replaceAll("\\{root\\}", topPath);
                    }
                    subAction = IController.findTreeByPath(IController.urlMappingTree, subPathValue, "", true);
                    subAction.controller = this.controller;
                    subAction.methodSend(method);
                    continue;
                }
                subPathValue = subPathValue.replaceAll("^/", "");
                if (this.children == null) {
                    this.children = new HashMap<String, Action>();
                }
                subAction = IController.findTreeByPath(this.children, subPathValue, this.path + "/", true);
                subAction.controller = this.controller;
                subAction.methodSend(method);
                continue;
            }
            this.methodSend(method);
        }
    }

    private void methodSend(Method method) {
        if (this.isSend(GET.class, method, this.getMethod)) {
            this.getMethod = method;
            this.getMethodController = this.controller;
        } else if (this.isSend(POST.class, method, this.postMethod)) {
            this.postMethod = method;
            this.postMethodController = this.controller;
        } else if (this.isSend(PUT.class, method, this.putMethod)) {
            this.putMethod = method;
            this.putMethodController = this.controller;
        } else if (this.isSend(DELETE.class, method, this.deleteMethod)) {
            this.deleteMethod = method;
            this.deleteMethodController = this.controller;
        }
    }

    private <T extends Annotation> boolean isSend(Class<T> anClz, Method method, Method existMethod) {
        if (method.getAnnotation(anClz) != null) {
            if (existMethod == null) {
                return true;
            }
            String[] arr = anClz.toString().split("\\.");
            LOGGER.warning("\u63a7\u5236\u5668\u4e0a\u7684[{0}]\u7684 [{1}]\u65b9\u6cd5\u5df2\u5728[{2}]\u767b\u8bb0\uff0c\u4e0d\u63a5\u53d7[{3}]\u7684\u91cd\u590d\u767b\u8bb0\u3002", this.path, arr[arr.length - 1], method, existMethod);
            return false;
        }
        return false;
    }

    public Method getMethod(String method) {
        switch (method.toUpperCase()) {
            case "GET": {
                return this.getMethod;
            }
            case "POST": {
                return this.postMethod;
            }
            case "PUT": {
                return this.putMethod;
            }
            case "DELETE": {
                return this.deleteMethod;
            }
        }
        return null;
    }

    public IController getController(String method) {
        switch (method.toUpperCase()) {
            case "GET": {
                return this.getMethodController;
            }
            case "POST": {
                return this.postMethodController;
            }
            case "PUT": {
                return this.putMethodController;
            }
            case "DELETE": {
                return this.deleteMethodController;
            }
        }
        return this.controller;
    }

    public static String getRootPath(Class<? extends IController> clz) {
        Path path = clz.getAnnotation(Path.class);
        if (path == null && !Modifier.isAbstract(clz.getModifiers())) {
            LOGGER.warning("\u63a7\u5236\u5668[{0}]\u4e0d\u5b58\u5728\u4efb\u4f55 Path \u4fe1\u606f\uff0c\u63a7\u5236\u5668\u7c7b\u5e94\u8be5\u81f3\u5c11\u8bbe\u7f6e\u4e00\u4e2a Path \u6ce8\u89e3\u3002", clz.toString());
            return null;
        }
        String rootPath = path.value();
        return rootPath.replaceAll("^/", "");
    }

    public boolean isAll() {
        return this.isAll;
    }

    public void setAll(boolean isAll) {
        this.isAll = isAll;
    }
}

