/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.mvc;

import com.ajaxjs.util.map.ListMap;
import com.ajaxjs.web.mvc.Action;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface IController {
    public static final Map<String, Action> urlMappingTree = new HashMap<String, Action>();
    public static final Pattern idRegexp = Pattern.compile("/\\d+");

    public static Action findTreeByPath(Map<String, Action> tree, Queue<String> path, String basePath, boolean createIfEmpty) {
        while (!path.isEmpty()) {
            String key = path.poll();
            basePath = basePath + key + "/";
            Action target = null;
            if (tree.containsKey(key)) {
                target = tree.get(key);
                if (target.isAll()) {
                    System.out.println("------------");
                    return target;
                }
            } else if (createIfEmpty) {
                target = new Action();
                target.path = basePath.replaceAll(".$", "");
                tree.put(key, target);
                if ("*".equals(path.peek())) {
                    target.setAll(true);
                    return target;
                }
            }
            if (path.isEmpty()) {
                return target;
            }
            if (createIfEmpty && target.children == null) {
                target.children = new HashMap<String, Action>();
            }
            if (target == null) break;
            Action t2 = IController.findTreeByPath(target.children, path, basePath, createIfEmpty);
            if (t2 == null) continue;
            return t2;
        }
        return null;
    }

    public static Action findTreeByPath(Map<String, Action> tree, Queue<String> queue, String basePath) {
        return IController.findTreeByPath(tree, queue, basePath, false);
    }

    public static Action findTreeByPath(Map<String, Action> tree, String path, String basePath, boolean createIfEmpty) {
        return IController.findTreeByPath(tree, ListMap.split2Queue(path), basePath, createIfEmpty);
    }

    public static Action findTreeByPath(Map<String, Action> tree, String path, String basePath) {
        return IController.findTreeByPath(tree, ListMap.split2Queue(path), basePath);
    }

    public static Action findTreeByPath(String path) {
        Matcher match = idRegexp.matcher(path);
        if (match.find()) {
            path = match.replaceAll("/{id}");
        }
        Action action = IController.findTreeByPath(urlMappingTree, path, "");
        return action;
    }

    public static Queue<String> split2Queue2(String path) {
        String[] arr = path.split("/");
        if (arr.length == 1) {
            arr = new String[]{"", arr[0]};
        }
        return new LinkedList<String>(Arrays.asList(arr));
    }
}

