/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.mvc;

import com.ajaxjs.framework.config.ConfigService;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.ReflectUtil;
import com.ajaxjs.util.ioc.ComponentMgr;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.map.JsonHelper;
import com.ajaxjs.web.mvc.Action;
import com.ajaxjs.web.mvc.IController;
import com.ajaxjs.web.mvc.ModelAndView;
import com.ajaxjs.web.mvc.MvcOutput;
import com.ajaxjs.web.mvc.MvcRequest;
import com.ajaxjs.web.mvc.RequestParam;
import com.ajaxjs.web.mvc.filter.Authority;
import com.ajaxjs.web.mvc.filter.FilterAction;
import com.ajaxjs.web.mvc.filter.FilterAfterArgs;
import com.ajaxjs.web.mvc.filter.FilterContext;
import com.ajaxjs.web.mvc.filter.MvcFilter;
import com.ajaxjs.web.secuity.SecurityRequest;
import com.ajaxjs.web.secuity.SecurityResponse;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Produces;

public class MvcDispatcherBase {
    private static final LogHelper LOGGER = LogHelper.getLog(MvcDispatcherBase.class);
    private static Boolean isEnableSecurityIO;
    public static final BiFunction<HttpServletRequest, HttpServletResponse, Boolean> DISPATCHER;

    public static void init(ServletContext ctx) {
        for (Class<?> clz : ComponentMgr.clzs) {
            if (!IController.class.isAssignableFrom(clz)) continue;
            MvcDispatcherBase.add(clz);
        }
    }

    public static void add(Class<? extends IController> clz) {
        if (Modifier.isAbstract(clz.getModifiers())) {
            return;
        }
        String topPath = Action.getRootPath(clz);
        if (CommonUtil.isEmptyString(topPath)) {
            return;
        }
        Action action = IController.findTreeByPath(IController.urlMappingTree, topPath, "", true);
        if (action != null) {
            action.createControllerInstance(clz);
            action.parseMethod();
        }
    }

    private static void execute(MvcRequest request, MvcOutput response, IController controller, Method method) {
        boolean isbeforeSkip;
        boolean isDoFilter;
        Object[] filterActions;
        ModelAndView model;
        Object result;
        Throwable err;
        block18: {
            MvcRequest.setHttpServletRequest((HttpServletRequest)request);
            MvcRequest.setHttpServletResponse((HttpServletResponse)response);
            err = null;
            result = null;
            model = null;
            filterActions = MvcDispatcherBase.getFilterActions(method);
            isDoFilter = !CommonUtil.isNull(filterActions);
            isbeforeSkip = false;
            Object[] args = null;
            boolean hasArgs = method.getParameterTypes().length > 0;
            try {
                if (hasArgs) {
                    args = RequestParam.getArgs(controller, request, (HttpServletResponse)response, method);
                    model = MvcDispatcherBase.findModel(args);
                }
                if (isDoFilter) {
                    if (model == null) {
                        model = new ModelAndView();
                    }
                    FilterContext ctx = new FilterContext();
                    ctx.model = model;
                    ctx.request = request;
                    ctx.response = response;
                    ctx.method = method;
                    ctx.args = args;
                    for (Object filterAction : filterActions) {
                        boolean bl = isbeforeSkip = !filterAction.before(ctx);
                        if (isbeforeSkip) break;
                    }
                }
                if (!isbeforeSkip) {
                    result = hasArgs ? ReflectUtil.executeMethod_Throwable(controller, method, args) : ReflectUtil.executeMethod_Throwable(controller, method, new Object[0]);
                }
            }
            catch (Throwable e) {
                err = e;
                if (!(e instanceof IllegalArgumentException) || !e.getMessage().contains("object is not an instance of declaring class")) break block18;
                LOGGER.warning("\u5f02\u5e38\u53ef\u80fd\u7684\u539f\u56e0\uff1a@Bean \u6ce8\u89e3\u7684\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5 IOC \u4e2d\u7684\u662f\u5426\u91cd\u540d");
            }
        }
        if (model != null) {
            request.saveToReuqest(model);
        }
        boolean isDoOldReturn = true;
        if (isDoFilter) {
            FilterAfterArgs argsHolder = new FilterAfterArgs();
            argsHolder.model = model;
            argsHolder.result = result;
            argsHolder.method = method;
            argsHolder.err = err;
            argsHolder.request = request;
            argsHolder.response = response;
            argsHolder.isbeforeSkip = isbeforeSkip;
            try {
                for (Object filterAction : filterActions) {
                    isDoOldReturn = filterAction.after(argsHolder);
                    if (!argsHolder.isAfterSkip) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                err = e;
            }
        }
        if (err != null) {
            MvcDispatcherBase.handleErr(err, method, request, response, model);
        } else if (!isbeforeSkip) {
            if (isDoOldReturn) {
                response.resultHandler(result, request, model, method);
            }
        } else {
            LOGGER.warning("\u4e00\u822c\u60c5\u51b5\u4e0b\u4e0d\u5e94\u6267\u884c\u5230\u8fd9\u4e00\u6b65\u3002Should not be executed in this step.");
        }
        MvcRequest.clean();
    }

    private static void handleErr(Throwable err, Method method, MvcRequest req, MvcOutput response, ModelAndView model) {
        Throwable _err = ReflectUtil.getUnderLayerErr(err);
        if (model != null && model.containsKey("NOT_LOG_EXCEPTION") && ((Boolean)model.get("NOT_LOG_EXCEPTION")).booleanValue()) {
            _err.printStackTrace();
        } else {
            LOGGER.warning(_err);
        }
        String errMsg = ReflectUtil.getUnderLayerErrMsg(err);
        Produces a = method.getAnnotation(Produces.class);
        if (a != null && "application/json".equals(a.value()[0])) {
            String msg = JsonHelper.javaValue2jsonValue(JsonHelper.jsonString_covernt(errMsg));
            msg = String.format("json::{\"isOk\": false, \"msg\" : \"%s\"}", msg);
            response.resultHandler(msg, req, model, method);
        } else if (err instanceof IllegalAccessError && ConfigService.getValueAsString("page.onNoLogin") != null) {
            model.put("title", "\u975e\u6cd5\u8bf7\u6c42");
            model.put("msg", errMsg);
            model.put("redirect", req.getContextPath() + "/user/login/");
            req.saveToReuqest(model);
            response.resultHandler("/WEB-INF/jsp/pages/msg.jsp", req, model, method);
        } else {
            req.setAttribute("javax.servlet.error.status_code", 500);
            req.setAttribute("javax.servlet.error.exception_type", err.getClass());
            req.setAttribute("javax.servlet.error.exception", err);
            response.resultHandler("/WEB-INF/jsp/error.jsp", req, model, method);
        }
    }

    private static FilterAction[] getFilterActions(Method method) {
        ArrayList<FilterAction> list = new ArrayList<FilterAction>();
        if (method.getAnnotation(MvcFilter.class) != null) {
            Class<? extends FilterAction>[] clzs;
            for (Class<? extends FilterAction> clz : clzs = method.getAnnotation(MvcFilter.class).filters()) {
                list.add(ReflectUtil.newInstance(clz, new Object[0]));
            }
        }
        if (method.getAnnotation(Authority.class) != null) {
            Authority a = method.getAnnotation(Authority.class);
            Class<? extends FilterAction> clz = a.filter();
            list.add(ReflectUtil.newInstance(clz, a.value()));
        }
        return list.toArray(new FilterAction[list.size()]);
    }

    private static ModelAndView findModel(Object[] args) {
        Optional<Object> mv = Arrays.stream(args).filter(obj -> obj instanceof ModelAndView).findAny();
        return mv.isPresent() ? (ModelAndView)mv.get() : null;
    }

    static {
        DISPATCHER = (req, resp) -> {
            if (isEnableSecurityIO == null) {
                isEnableSecurityIO = ConfigService.getValueAsBool("security.isEnableSecurityIO");
            }
            MvcRequest request = new MvcRequest((HttpServletRequest)(isEnableSecurityIO != false ? new SecurityRequest((HttpServletRequest)req) : req));
            MvcOutput response = new MvcOutput((HttpServletResponse)(isEnableSecurityIO != false ? new SecurityResponse((HttpServletResponse)resp) : resp));
            String uri = request.getFolder();
            String httpMethod = request.getMethod();
            Action action = null;
            try {
                action = IController.findTreeByPath(uri);
            }
            catch (Throwable e) {
                LOGGER.warning(e);
            }
            if (action != null) {
                Method method = action.getMethod(httpMethod);
                IController controller = action.getController(httpMethod);
                if (method != null && controller != null) {
                    MvcDispatcherBase.execute(request, response, controller, method);
                    return false;
                }
            }
            return true;
        };
    }
}

