/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.mvc;

import com.ajaxjs.Version;
import com.ajaxjs.framework.BaseModel;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.map.JsonHelper;
import com.ajaxjs.web.mvc.ModelAndView;
import com.ajaxjs.web.mvc.MvcRequest;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.PageContext;

public class MvcOutput
extends HttpServletResponseWrapper {
    private static final LogHelper LOGGER = LogHelper.getLog(MvcOutput.class);
    private String output;
    private Map<String, ?> outputMap;
    private List<?> outputList;
    private Object outputObj;
    private String content_Type = "text/html";
    private String redirect;
    private String template;
    private BaseModel bean;
    private boolean json;
    private String jsonpToken;
    private boolean simpleHTML;
    private boolean xmlContent;
    public static final String HTML = "html::";
    public static final String xml = "xml::";
    public static final String JSON_PREFIX = "json::";
    public static final String REDIRECT_PREFIX = "redirect::";
    public static final String ERR_MSG = "err_msg::";
    public static final String ERR_MSG_TPL = "<title>\u64cd\u4f5c\u9519\u8bef</title><meta charset=\"utf-8\" /><div style=\"height: 100%%; display: flex; justify-content: center; align-items: center;\"><table>\t\t<tr><td align=\"center\">\t\t\t<svg width=\"150px\" viewBox=\"0 0 1000 1000\">\t\t\t\t<g><path fill=\"#ea8010\" d=\"M500,10c-46.7,0-84.5,38-84.5,84.9v573.7c0,46.9,37.8,84.9,84.5,84.9c46.7,0,84.5-38,84.5-84.9V94.9C584.5,48,546.7,10,500,10z M500,821c-46.7,0-84.5,37.8-84.5,84.5c0,46.7,37.8,84.5,84.5,84.5c46.7,0,84.5-37.8,84.5-84.5C584.4,858.9,546.6,821,500,821z\" /></g>\t\t\t</svg></td></tr>\t\t<tr><td align=\"center\"><br />%s<br /><a href=\"javascript:history.go(-1);\">\u8fd4\u56de</a></td></tr></table></div>";
    private boolean isSet;
    public static final String returnJs_refresh = "window.location = document.referrer;";

    public MvcOutput(HttpServletResponse request) {
        super(request);
    }

    public void go() {
        if (this.getRedirect() != null) {
            try {
                this.sendRedirect(this.getRedirect());
            }
            catch (IOException e) {
                LOGGER.warning(e);
            }
            return;
        }
        if (this.getOutputMap() != null) {
            this.setJson(true).setOutput(JsonHelper.toJson(this.getOutputMap()));
        } else if (this.getOutputList() != null) {
            if (this.getOutputList() == null || this.getOutputList().size() == 0) {
                this.setJson(true).setOutput("[]");
            } else {
                this.setJson(true).setOutput(JsonHelper.toJson(this.getOutputList()));
            }
        } else if (this.getBean() != null) {
            this.setJson(true).setOutput(JsonHelper.toJson(this.getBean()));
        } else if (this.getOutputObj() != null) {
            // empty if block
        }
        if (this.isJson()) {
            this.setContent_Type("application/json");
        } else if (this.getJsonpToken() != null) {
            this.setContent_Type("application/javascript");
            this.setOutput(String.format("%s(%s);", this.getJsonpToken(), this.getOutput()));
        } else if (this.xmlContent) {
            this.setContent_Type("application/xml");
        } else if (this.isSimpleHTML()) {
            this.setOutput(String.format("<html><meta charset=\"utf-8\" /><body>%s</body></html>", this.getOutput()));
        }
        this.output(this.getOutput());
    }

    public void go(HttpServletRequest request) {
        if (this.getTemplate() != null) {
            request.setAttribute("jsp_path", (Object)this.getTemplate());
            try {
                RequestDispatcher rd = request.getRequestDispatcher(this.getTemplate());
                if (rd != null) {
                    rd.forward((ServletRequest)request, (ServletResponse)this);
                }
            }
            catch (IOException | ServletException e) {
                LOGGER.warning(e);
            }
        }
    }

    public void resultHandler(Object result, MvcRequest request, ModelAndView model, Method method) {
        if (this.isSet) {
            return;
        }
        if (result == null) {
            Class<?> reClz = method.getReturnType();
            if (reClz == Map.class) {
                this.setJson(true).setOutput("{}").go();
            } else if (reClz == List.class) {
                this.setJson(true).setOutput("[]").go();
            } else {
                LOGGER.info("\u63a7\u5236\u5668\u65b9\u6cd5 {0} \u8fd4\u56de null", method);
            }
        } else if (result instanceof String) {
            String str = (String)result;
            if (str.startsWith(HTML)) {
                this.setSimpleHTML(true).setOutput(str.replace(HTML, "")).go();
            } else if (str.startsWith(ERR_MSG)) {
                String h = str.replace(ERR_MSG, "");
                h = String.format(ERR_MSG_TPL, h);
                this.setSimpleHTML(true).setOutput(h).go();
            } else if (str.startsWith(xml)) {
                this.xmlContent = true;
                this.setOutput(str.replace(xml, "")).go();
            } else if (str.startsWith(REDIRECT_PREFIX)) {
                this.setRedirect(str.replace(REDIRECT_PREFIX, "")).go();
            } else if (str.startsWith(JSON_PREFIX)) {
                String jsonpToken = request.getParameter("callback");
                if (CommonUtil.isEmptyString(jsonpToken)) {
                    this.setJson(true).setOutput(str.replace(JSON_PREFIX, "")).go();
                } else {
                    this.setJsonpToken(jsonpToken).setOutput(str.replace(JSON_PREFIX, "")).go();
                }
            } else if (str.startsWith("js::")) {
                this.setContent_Type("application/javascript").setOutput(str.replace("js::", "")).go();
            } else {
                if (!str.contains(".jsp") && !str.endsWith(".jsp")) {
                    str = str + ".jsp";
                }
                if (Version.isDebug) {
                    String m = method.toString().replaceAll("public java.lang.", "").replaceAll("\\([\\w\\.\\s,]+\\)", "()");
                    m = m.replaceAll("String ", "").replaceAll("\\s+throws\\s+.*$", "");
                    String[] arr = m.split("\\.");
                    m = arr[arr.length - 2] + "." + arr[arr.length - 1];
                    LOGGER.info("\u6267\u884c[{0}]\u63a7\u5236\u5668\uff0c\u8f6c\u5230[{1}]\u89c6\u56fe", m, result);
                }
                this.setTemplate(str).go((HttpServletRequest)request);
            }
        } else if (result instanceof Map) {
            this.setOutputMap((Map)result).go();
        } else if (result instanceof List) {
            this.setOutputList((List)result).go();
        } else if (result instanceof BaseModel) {
            this.setBean((BaseModel)result).go();
        }
    }

    public void go(RenderedImage im) {
        if (this.getContent_Type() != null) {
            this.setContentType(this.getContent_Type());
        }
        try {
            ImageIO.write(im, "JPEG", (OutputStream)this.getOutputStream());
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
    }

    public static void fix(PageContext ctx) {
        HttpServletResponse response = (HttpServletResponse)ctx.getResponse();
        try {
            ServletOutputStream out = response.getOutputStream();
            out.flush();
            out.close();
            response.flushBuffer();
            ctx.getOut().clear();
            ctx.pushBody();
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
    }

    public void output(String output) {
        this.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        this.setContentType(this.getContent_Type());
        try {
            PrintWriter writer = this.getWriter();
            if (writer != null) {
                writer.print(output);
            }
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
    }

    public MvcOutput noCache() {
        this.setHeader("Pragma", "No-cache");
        this.setHeader("Cache-Control", "no-cache");
        this.setDateHeader("Expires", 0L);
        return this;
    }

    public void allowCORS() {
        this.setHeader("Access-Control-Allow-Origin", "*");
        this.setHeader("Access-Control-Allow-Methods", "*");
        this.setHeader("Access-Control-Max-Age", "3600");
        this.setHeader("Access-Control-Allow-Headers", "*");
        this.setHeader("Access-Control-Allow-Credentials", "true");
    }

    public String getOutput() {
        return this.output;
    }

    public MvcOutput setOutput(String output) {
        this.output = output;
        return this;
    }

    public String getContent_Type() {
        return this.content_Type;
    }

    public MvcOutput setContent_Type(String content_Type) {
        this.content_Type = content_Type;
        return this;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public MvcOutput setRedirect(String redirect) {
        this.redirect = redirect;
        return this;
    }

    public String getTemplate() {
        return this.template;
    }

    public MvcOutput setTemplate(String template) {
        this.template = template;
        return this;
    }

    public boolean isJson() {
        return this.json;
    }

    public MvcOutput setJson(boolean json) {
        this.json = json;
        return this;
    }

    public boolean isSimpleHTML() {
        return this.simpleHTML;
    }

    public MvcOutput setSimpleHTML(boolean simpleHTML) {
        this.simpleHTML = simpleHTML;
        return this;
    }

    public String getJsonpToken() {
        return this.jsonpToken;
    }

    public MvcOutput setJsonpToken(String jsonpToken) {
        this.jsonpToken = jsonpToken;
        return this;
    }

    public Map<String, ?> getOutputMap() {
        return this.outputMap;
    }

    public MvcOutput setOutputMap(Map<String, ?> output_Map) {
        this.outputMap = output_Map;
        return this;
    }

    public Object getOutputObj() {
        return this.outputObj;
    }

    public MvcOutput setOutputObj(Object output_Obj) {
        this.outputObj = output_Obj;
        return this;
    }

    public BaseModel getBean() {
        return this.bean;
    }

    public MvcOutput setBean(BaseModel bean) {
        this.bean = bean;
        return this;
    }

    public List<?> getOutputList() {
        return this.outputList;
    }

    public MvcOutput setOutputList(List<?> output_List) {
        this.outputList = output_List;
        return this;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public void setSet(boolean isSet) {
        this.isSet = isSet;
    }
}

