/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.mvc;

import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.Encode;
import com.ajaxjs.util.MappingValue;
import com.ajaxjs.util.io.StreamHelper;
import com.ajaxjs.util.map.MapTool;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class MvcRequest
extends HttpServletRequestWrapper {
    private Map<String, Object> putRequestData;
    public static final String CALLBACK_PARAM = "callback";
    private static ThreadLocal<HttpServletRequest> threadLocalRequest = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> threadLocalResponse = new ThreadLocal();

    public MvcRequest(HttpServletRequest req) {
        super(req);
        req.setAttribute("requestTimeRecorder", (Object)System.currentTimeMillis());
        try {
            this.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getRequestURI() {
        Object obj = this.getAttribute("javax.servlet.forward.request_uri");
        if (obj != null && !CommonUtil.isEmptyString((String)obj)) {
            return (String)obj;
        }
        return super.getRequestURI();
    }

    public String getRoute() {
        String route = this.getRequestURI().replaceAll("^" + this.getContextPath(), "");
        return route.replaceFirst("/\\w+\\.\\w+$", "");
    }

    public String getFolder() {
        return this.getRoute().replaceFirst("^/", "");
    }

    public Map<String, Object> getPutRequestData() {
        if (this.putRequestData == null) {
            try (ServletInputStream in = this.getInputStream();){
                String params = StreamHelper.byteStream2string((InputStream)in);
                this.putRequestData = MapTool.toMap(params.split("&"), v -> MappingValue.toJavaValue(Encode.urlDecode(v)));
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.putRequestData;
    }

    public String getValueFromPath(String value, String param) {
        String url = this.getRoute();
        String regExp = "(" + value.replace("{" + param + "}", ")(\\d+)");
        String result = CommonUtil.regMatch(regExp, url, -1);
        return Objects.requireNonNull(result, "\u5728[ " + url + "]\u4e0d\u80fd\u83b7\u53d6[ " + param + "]\u53c2\u6570");
    }

    public Map<String, Object> getMap() {
        if (this.getMethod() != null && this.getMethod().toUpperCase().equals("PUT")) {
            return this.getPutRequestData();
        }
        return MapTool.as(this.getParameterMap(), arr -> MappingValue.toJavaValue(arr[0]));
    }

    public <T> T getBean(Class<T> clz) {
        Map<String, Object> map = this.getMap();
        return MapTool.map2Bean(map, clz, true);
    }

    public void saveToReuqest(Map<String, Object> map) {
        map.forEach((k, v) -> this.setAttribute((String)k, v));
    }

    public static void setHttpServletRequest(HttpServletRequest req) {
        threadLocalRequest.set(req);
    }

    public static HttpServletRequest getHttpServletRequest() {
        return threadLocalRequest.get();
    }

    public static MvcRequest getMvcRequest() {
        HttpServletRequest req = MvcRequest.getHttpServletRequest();
        if (!(req instanceof MvcRequest)) {
            throw new RuntimeException("\u975e\u6cd5 MvcRequest \u7c7b\u578b");
        }
        return (MvcRequest)req;
    }

    public static void setHttpServletResponse(HttpServletResponse resp) {
        threadLocalResponse.set(resp);
    }

    public static HttpServletResponse getHttpServletResponse() {
        HttpServletResponse resp = threadLocalResponse.get();
        if (resp == null) {
            throw new RuntimeException("\u54cd\u5e94\u5bf9\u8c61\u672a\u521d\u59cb\u5316");
        }
        return resp;
    }

    public static void clean() {
        threadLocalRequest.set(null);
        threadLocalResponse.set(null);
    }

    public static String mappath(ServletContext cxt, String relativePath) {
        String absolute = cxt.getRealPath(relativePath);
        if (absolute != null) {
            absolute = absolute.replace('\\', '/');
        }
        return absolute;
    }

    public String mappath(String relativePath) {
        return MvcRequest.mappath(this.getServletContext(), relativePath);
    }

    public String getBasePath() {
        String prefix = this.getScheme() + "://" + this.getServerName();
        int port = this.getServerPort();
        if (port != 80) {
            prefix = prefix + ":" + port;
        }
        return prefix + this.getContextPath();
    }

    public String getIp() {
        String ip = this.getHeader("x-forwarded-for");
        if (!"unknown".equalsIgnoreCase(ip) && ip != null && ip.length() != 0) {
            int index = ip.indexOf(",");
            if (index != -1) {
                ip = ip.substring(0, index);
            }
            return ip.startsWith("::ffff:") ? ip.replaceAll("::ffff:", "") : ip;
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = this.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = this.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = this.getHeader("X-Real-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = this.getRemoteAddr();
        }
        return ip.startsWith("::ffff:") ? ip.replaceAll("::ffff:", "") : ip;
    }

    public boolean hasParameter(String key) {
        String v = this.getParameter(key);
        if (CommonUtil.isEmptyString(v)) {
            return false;
        }
        return MappingValue.toBoolean(v);
    }

    public String getParameter(String key, String defaultValue) {
        String v = this.getParameter(key);
        return CommonUtil.isEmptyString(v) ? defaultValue : v;
    }

    public String getIdOnly(String key) {
        String p = this.getParameter(key);
        if (!p.matches("\\d+")) {
            throw new IllegalArgumentException("\u53c2\u6570 [" + key + "[\u5fc5\u987b\u4e3a\u6570\u5b57");
        }
        return p;
    }
}

