/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.mvc;

import com.ajaxjs.framework.BaseModel;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.MappingValue;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.map.MapTool;
import com.ajaxjs.web.mvc.Action;
import com.ajaxjs.web.mvc.IController;
import com.ajaxjs.web.mvc.ModelAndView;
import com.ajaxjs.web.mvc.MvcRequest;
import com.ajaxjs.web.mvc.SubBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public class RequestParam {
    private static final LogHelper LOGGER = LogHelper.getLog(RequestParam.class);

    public static Object[] getArgs(IController controller, MvcRequest req, HttpServletResponse resp, Method method) {
        Annotation[][] annot = method.getParameterAnnotations();
        Class<?>[] parmTypes = method.getParameterTypes();
        ArrayList<Object> args = new ArrayList<Object>();
        for (int i = 0; i < parmTypes.length; ++i) {
            Annotation[] annotations;
            Class<?> clazz = parmTypes[i];
            if (clazz.equals(HttpServletRequest.class) || clazz.equals(MvcRequest.class)) {
                args.add((Object)req);
                continue;
            }
            if (clazz.equals(HttpServletResponse.class)) {
                args.add(resp);
                continue;
            }
            if (clazz.equals(HttpSession.class)) {
                args.add(req.getSession());
                continue;
            }
            if (clazz.equals(Map.class)) {
                Map<String, Object> map = req.getMethod() != null && req.getMethod().equals("PUT") ? req.getPutRequestData() : MapTool.as(req.getParameterMap(), arr -> MappingValue.toJavaValue(arr[0]));
                args.add(map);
                if (map.size() != 0) continue;
                LOGGER.info("\u6ca1\u6709\u4efb\u4f55\u8bf7\u6c42\u6570\u636e\uff0c\u4f46\u63a7\u5236\u5668\u65b9\u6cd5\u671f\u671b\u81f3\u5c11\u4e00\u4e2a\u53c2\u6570\u6765\u6784\u6210 map\u3002");
                continue;
            }
            if (clazz.equals(ModelAndView.class)) {
                args.add(new ModelAndView());
                continue;
            }
            if (BaseModel.class.isAssignableFrom(clazz)) {
                annotations = annot[i];
                if (annotations != null && annotations.length >= 1 && annotations[0] instanceof SubBean) {
                    Map<String, Object> map = req.getMap();
                    HashMap _map = new HashMap();
                    SubBean s = (SubBean)annotations[0];
                    String perfix = s.value() + ".";
                    map.forEach((key, v) -> {
                        if (key.startsWith(perfix)) {
                            _map.put(key.replace(perfix, ""), v);
                        }
                    });
                    Object bean = MapTool.map2Bean(_map, clazz, true);
                    args.add(bean);
                    continue;
                }
                args.add(req.getBean(clazz));
                continue;
            }
            annotations = annot[i];
            RequestParam.getArgValue(clazz, annotations, req, args, method, controller);
        }
        return args.toArray();
    }

    private static void getArgValue(Class<?> clz, Annotation[] annots, MvcRequest req, ArrayList<Object> args, Method method, IController controller) {
        if (annots.length > 0) {
            boolean required = false;
            String defaultValue = null;
            for (Annotation annot : annots) {
                if (annot instanceof NotNull) {
                    required = true;
                }
                if (annot instanceof DefaultValue) {
                    defaultValue = ((DefaultValue)annot).value();
                }
                if (annot instanceof QueryParam || annot instanceof FormParam || annot instanceof HeaderParam) {
                    RequestParam.getArgValue(clz, args, RequestParam.getArgValue(annot, (HttpServletRequest)req, required), defaultValue);
                    break;
                }
                if (annot instanceof PathParam) {
                    Path path = method.getAnnotation(Path.class);
                    if (path != null) {
                        String paramName = ((PathParam)annot).value();
                        String value = req.getValueFromPath(RequestParam.parseRoot(path, controller == null ? null : controller.getClass()), paramName);
                        RequestParam.getArgValue2(clz, args, value);
                    } else {
                        LOGGER.warning(new NullPointerException("\u63a7\u5236\u5668\u65b9\u6cd5\u5c45\u7136\u6ca1\u6709 PathParam \u6ce8\u89e3\uff1f\uff1f"));
                    }
                    break;
                }
                if (!(annot instanceof SubBean)) continue;
            }
        } else {
            args.add("Nothing to add args");
        }
    }

    private static String parseRoot(Path path, Class<? extends IController> clz) {
        String pathValue = path.value();
        if (clz != null && pathValue.contains("{root}")) {
            String topPath = Action.getRootPath(clz);
            pathValue = pathValue.replaceAll("\\{root\\}", topPath);
        }
        return pathValue;
    }

    private static String getArgValue(Annotation a, HttpServletRequest request, boolean required) {
        String value;
        String key = null;
        if (a instanceof QueryParam) {
            key = ((QueryParam)a).value();
        } else if (a instanceof FormParam) {
            key = ((FormParam)a).value();
        } else if (a instanceof HeaderParam) {
            key = ((HeaderParam)a).value();
        }
        String string = value = a instanceof HeaderParam ? request.getHeader(key) : request.getParameter(key);
        if (required && CommonUtil.isEmptyString(value)) {
            throw new NullPointerException("\u5ba2\u6237\u7aef\u7f3a\u5c11\u63d0\u4ea4\u7684\u53c2\u6570[ " + key + "]");
        }
        return value != null ? value.trim() : value;
    }

    private static void getArgValue(Class<?> clz, ArrayList<Object> args, String value, String defaultValue) {
        if (clz == String.class) {
            args.add(value == null ? defaultValue : value);
        } else if (clz == Integer.TYPE || clz == Integer.class) {
            boolean isNull = value == null || "".equals(value) || "null".equals(value);
            int v = 0;
            if (isNull && defaultValue != null) {
                v = Integer.parseInt(defaultValue);
            } else if (!isNull) {
                v = Integer.parseInt(value);
            }
            args.add(v);
        } else if (clz == Long.TYPE || clz == Long.class) {
            args.add(value == null || "".equals(value) ? 0L : Long.parseLong(value));
        } else if (clz == Boolean.TYPE || clz == Boolean.class) {
            args.add(MappingValue.toBoolean(value));
        } else {
            args.add(new Object());
            LOGGER.warning("\u4e0d\u652f\u6301\u7c7b\u578b");
        }
    }

    private static void getArgValue2(Class<?> clz, ArrayList<Object> args, String value) {
        if (clz == String.class) {
            args.add(value);
        } else if (clz == Integer.TYPE || clz == Integer.class) {
            args.add(Integer.parseInt(value));
        } else if (clz == Long.TYPE || clz == Long.class) {
            args.add(Long.parseLong(value));
        } else {
            LOGGER.warning("something wrong!");
            args.add(value);
        }
    }
}

