/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.secuity;

import com.ajaxjs.framework.config.ConfigService;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.web.mvc.MvcRequest;
import com.ajaxjs.web.mvc.filter.FilterAction;
import com.ajaxjs.web.mvc.filter.FilterAfterArgs;
import com.ajaxjs.web.mvc.filter.FilterContext;
import java.util.List;
import java.util.regex.Pattern;

public class SecurityFilter
implements FilterAction {
    public List<String> whiteList;
    public List<String> blackList;

    public boolean isInWhiteList(String str) {
        return SecurityFilter.isInList(str, this.whiteList);
    }

    public boolean isInBlackList(String str) {
        boolean isIn = SecurityFilter.isInList(str, this.blackList);
        if (!isIn) {
            throw new SecurityException(String.format("\u5730\u5740[%s]\u5df2\u5217\u5165\u9ed1\u540d\u5355\uff01", str));
        }
        return isIn;
    }

    private static boolean isInList(String str, List<String> list) {
        if (CommonUtil.isNull(list)) {
            return false;
        }
        for (String pattern : list) {
            if (!Pattern.matches(pattern, str)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean before(FilterContext ctx) {
        SecurityFilter.refererCheck(ctx.request);
        if (!"GET".equalsIgnoreCase(ctx.request.getMethod())) {
            return true;
        }
        String uri = ctx.request.getRequestURI();
        if (this.isInWhiteList(uri)) {
            return true;
        }
        return !this.isInBlackList(uri);
    }

    private static void refererCheck(MvcRequest request) {
        if (ConfigService.getValueAsBool("security.isRefererCheck")) {
            String referer = request.getHeader("referer");
            if (CommonUtil.isEmptyString(referer)) {
                throw new SecurityException("\u8bf7\u6c42\u6ca1\u6709 referer \u5b57\u6bb5\u4e0d\u901a\u8fc7");
            }
            if (!referer.startsWith(request.getServerName())) {
                throw new SecurityException("Referer:" + referer + " \u6765\u8def\u68c0\u6d4b\u4e0d\u901a\u8fc7");
            }
        }
    }

    @Override
    public boolean after(FilterAfterArgs args) {
        return true;
    }
}

