/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.secuity;

import com.ajaxjs.framework.config.ConfigService;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.web.secuity.SecurityFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class SecurityRequest
extends HttpServletRequestWrapper {
    public static SecurityFilter delegate = new SecurityFilter();
    private static String XSS_SCRIPT = "<script[^>]*?>.*?</script>";
    private static Pattern XSS_Pattern = Pattern.compile(XSS_SCRIPT);
    private static String TYPE_ESCAPSE = "escapse";
    public static String TYPE_DELETE = "delete";

    public SecurityRequest(HttpServletRequest request) {
        super(request);
    }

    public Cookie[] getCookies() {
        Object[] cookies = super.getCookies();
        if (CommonUtil.isNull(cookies)) {
            return null;
        }
        ArrayList<Object> cookieList = new ArrayList<Object>();
        for (Object cookie : cookies) {
            if (!delegate.isInWhiteList(cookie.getName())) continue;
            cookieList.add(cookie);
        }
        return cookieList.toArray(new Cookie[cookieList.size()]);
    }

    public String getCookieByName(String name) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = this.getCookies()) {
            if (!name.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public String getParameter(String key) {
        String v = super.getParameter(key);
        if (ConfigService.getValueAsBool("security.isXXS_Filter")) {
            key = SecurityRequest.clean(key, TYPE_DELETE);
            return SecurityRequest.clean(v);
        }
        return v;
    }

    public Map<String, String[]> getParameterMap() {
        Map _map = super.getParameterMap();
        if (_map == null) {
            return null;
        }
        if (ConfigService.getValueAsBool("security.isXXS_Filter")) {
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            _map.forEach((k, v) -> map.put(SecurityRequest.clean(k, TYPE_DELETE), SecurityRequest.clean(v)));
            return map;
        }
        return _map;
    }

    public Enumeration<String> getParameterNames() {
        Enumeration enums = super.getParameterNames();
        if (ConfigService.getValueAsBool("security.isXXS_Filter")) {
            Vector<String> vec = new Vector<String>();
            while (enums.hasMoreElements()) {
                String value = (String)enums.nextElement();
                vec.add(SecurityRequest.clean(value));
            }
            return vec.elements();
        }
        return enums;
    }

    public String[] getParameterValues(String key) {
        String[] arr = super.getParameterValues(key);
        if (ConfigService.getValueAsBool("security.isXXS_Filter")) {
            return SecurityRequest.clean(arr);
        }
        return arr;
    }

    public static String clean(String input) {
        return SecurityRequest.clean(input, TYPE_ESCAPSE);
    }

    public static String clean(String input, String type) {
        if (CommonUtil.isEmptyString(input)) {
            return input;
        }
        if (type.equals(TYPE_ESCAPSE)) {
            Matcher matcher = XSS_Pattern.matcher(input);
            if (matcher.find()) {
                return matcher.group().replace("<", "&lt;").replace(">", "&gt;");
            }
        } else if (type.equals(TYPE_DELETE)) {
            return input.replaceAll(XSS_SCRIPT, "");
        }
        return input;
    }

    private static String[] clean(String[] value) {
        if (CommonUtil.isNull(value)) {
            return null;
        }
        for (int i = 0; i < value.length; ++i) {
            value[i] = SecurityRequest.clean(value[i]);
        }
        return value;
    }
}

