/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.web.secuity;

import com.ajaxjs.framework.config.ConfigService;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.web.secuity.SecurityFilter;
import com.ajaxjs.web.secuity.SecurityRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class SecurityResponse
extends HttpServletResponseWrapper {
    public static SecurityFilter delegate = new SecurityFilter();
    private static final int MAX_COOKIE_SIZE = 4096;

    public SecurityResponse(HttpServletResponse response) {
        super(response);
    }

    public void addCookie(Cookie cookie) {
        String name = cookie.getName();
        String value = cookie.getValue();
        boolean isCRLF_Filter = ConfigService.getValueAsBool("security.isCRLF_Filter");
        if (isCRLF_Filter && SecurityResponse.containCLRF(name)) {
            throw new SecurityException("Cookie \u540d\u79f0\u4e0d\u80fd\u5305\u542b CLRF \u5b57\u7b26\uff0c\u8be5 cookie \u662f \uff1a" + name);
        }
        Cookie newCookie = new Cookie(name, isCRLF_Filter ? SecurityResponse.filterCLRF(value) : value);
        newCookie.setComment(cookie.getComment());
        if (cookie.getDomain() != null) {
            newCookie.setDomain(cookie.getDomain());
        }
        newCookie.setHttpOnly(cookie.isHttpOnly());
        newCookie.setMaxAge(cookie.getMaxAge());
        newCookie.setPath(cookie.getPath());
        newCookie.setSecure(cookie.getSecure());
        newCookie.setVersion(cookie.getVersion());
        if (ConfigService.getValueAsBool("security.isCookiesSizeCheck") && cookie.getValue().length() > 4096) {
            throw new SecurityException("\u8d85\u51fa Cookie \u5141\u8bb8\u5bb9\u91cf\uff1a4096");
        }
        if (!delegate.isInWhiteList(cookie.getName())) {
            throw new SecurityException("cookie: " + cookie.getName() + " \u4e0d\u5728\u767d\u540d\u5355\u4e2d\uff0c\u6dfb\u52a0\u65e0\u6548\uff01");
        }
        super.addCookie(newCookie);
    }

    public void setDateHeader(String name, long date) {
        if (ConfigService.getValueAsBool("security.isCRLF_Filter")) {
            super.setDateHeader(SecurityResponse.filterCLRF(name), date);
        } else {
            super.setDateHeader(name, date);
        }
    }

    public void setIntHeader(String name, int value) {
        if (ConfigService.getValueAsBool("security.isCRLF_Filter")) {
            super.setIntHeader(SecurityResponse.filterCLRF(name), value);
        } else {
            super.setIntHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (ConfigService.getValueAsBool("security.isXXS_Filter")) {
            value = SecurityRequest.clean(value);
        }
        if (ConfigService.getValueAsBool("security.isCRLF_Filter")) {
            super.addHeader(SecurityResponse.filterCLRF(name), SecurityResponse.filterCLRF(value));
        } else {
            super.addHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        if (ConfigService.getValueAsBool("security.isXXS_Filter")) {
            value = SecurityRequest.clean(value);
        }
        if (ConfigService.getValueAsBool("security.isCRLF_Filter")) {
            super.setHeader(SecurityResponse.filterCLRF(name), SecurityResponse.filterCLRF(value));
        } else {
            super.setHeader(name, value);
        }
    }

    private static String filterCLRF(String value) {
        if (CommonUtil.isEmptyString(value)) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '\r' || value.charAt(i) == '\n') continue;
            sb.append(value.charAt(i));
        }
        return sb.toString();
    }

    private static boolean containCLRF(String name) {
        if (CommonUtil.isEmptyString(name)) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '\r' && name.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    public void setStatus(int sc, String value) {
        if (ConfigService.getValueAsBool("security.isXXS_Filter")) {
            super.setStatus(sc, SecurityRequest.clean(value));
        } else {
            super.setStatus(sc, value);
        }
    }
}

