/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j.generators;

import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;

public class CopyrightGenerator {
    private CopyrightGenerator() {
    }

    public static String generate(String projectInceptionYear, String projectOrganizationName) {
        String inceptionYear = CopyrightGenerator.generateInceptionYear(projectInceptionYear);
        int buildYear = LocalDate.now().getYear();
        String organizationName = CopyrightGenerator.generateOrganizationName(projectOrganizationName);
        return String.format("Copyright \u00a9 %s%d%s. All rights reserved.", inceptionYear, buildYear, organizationName);
    }

    private static String generateInceptionYear(String projectInceptionYear) {
        if (StringUtils.isNotBlank((CharSequence)projectInceptionYear)) {
            return projectInceptionYear + "-";
        }
        return "";
    }

    private static String generateOrganizationName(String projectOrganizationName) {
        if (StringUtils.isNotBlank((CharSequence)projectOrganizationName)) {
            return " " + projectOrganizationName;
        }
        return "";
    }
}

