/*
 * Decompiled with CFR 0.152.
 */
package com.akeyless.kfm.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Temporary access credentials to get an access to the secret key protected fragments from KFM instances together with the KFMs host names and the encrypted secret value.")
public class SecretAccessCredsReplyObj {
    @SerializedName(value="KFMsHostsDNSMap")
    private Map<String, String> kfMsHostsDNSMap = null;
    @SerializedName(value="credential")
    private String credential = null;
    @SerializedName(value="expiry")
    private Long expiry = null;
    @SerializedName(value="item_id")
    private Long itemId = null;
    @SerializedName(value="item_name")
    private String itemName = null;
    @SerializedName(value="item_type")
    private String itemType = null;
    @SerializedName(value="item_version")
    private Integer itemVersion = null;
    @SerializedName(value="protected_key_type")
    private String protectedKeyType = null;
    @SerializedName(value="restricted_dd")
    private String restrictedDd = null;
    @SerializedName(value="secret_enc_val")
    private String secretEncVal = null;

    public SecretAccessCredsReplyObj kfMsHostsDNSMap(Map<String, String> kfMsHostsDNSMap) {
        this.kfMsHostsDNSMap = kfMsHostsDNSMap;
        return this;
    }

    public SecretAccessCredsReplyObj putKfMsHostsDNSMapItem(String key, String kfMsHostsDNSMapItem) {
        if (this.kfMsHostsDNSMap == null) {
            this.kfMsHostsDNSMap = new HashMap<String, String>();
        }
        this.kfMsHostsDNSMap.put(key, kfMsHostsDNSMapItem);
        return this;
    }

    @ApiModelProperty(value="Mapping between the serial number of the key protected fragments and the KFMs hosts DNS in which they are stored")
    public Map<String, String> getKfMsHostsDNSMap() {
        return this.kfMsHostsDNSMap;
    }

    public void setKfMsHostsDNSMap(Map<String, String> kfMsHostsDNSMap) {
        this.kfMsHostsDNSMap = kfMsHostsDNSMap;
    }

    public SecretAccessCredsReplyObj credential(String credential) {
        this.credential = credential;
        return this;
    }

    @ApiModelProperty(value="Temporary credentials string (JWT format)")
    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public SecretAccessCredsReplyObj expiry(Long expiry) {
        this.expiry = expiry;
        return this;
    }

    @ApiModelProperty(value="Credentials expiration date")
    public Long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Long expiry) {
        this.expiry = expiry;
    }

    public SecretAccessCredsReplyObj itemId(Long itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public SecretAccessCredsReplyObj itemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    @ApiModelProperty(value="The name, id, version and type of the secret item")
    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public SecretAccessCredsReplyObj itemType(String itemType) {
        this.itemType = itemType;
        return this;
    }

    @ApiModelProperty(value="")
    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public SecretAccessCredsReplyObj itemVersion(Integer itemVersion) {
        this.itemVersion = itemVersion;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getItemVersion() {
        return this.itemVersion;
    }

    public void setItemVersion(Integer itemVersion) {
        this.itemVersion = itemVersion;
    }

    public SecretAccessCredsReplyObj protectedKeyType(String protectedKeyType) {
        this.protectedKeyType = protectedKeyType;
        return this;
    }

    @ApiModelProperty(value="The protected key type")
    public String getProtectedKeyType() {
        return this.protectedKeyType;
    }

    public void setProtectedKeyType(String protectedKeyType) {
        this.protectedKeyType = protectedKeyType;
    }

    public SecretAccessCredsReplyObj restrictedDd(String restrictedDd) {
        this.restrictedDd = restrictedDd;
        return this;
    }

    @ApiModelProperty(value="Restricted derivation data for the protected key derive operation")
    public String getRestrictedDd() {
        return this.restrictedDd;
    }

    public void setRestrictedDd(String restrictedDd) {
        this.restrictedDd = restrictedDd;
    }

    public SecretAccessCredsReplyObj secretEncVal(String secretEncVal) {
        this.secretEncVal = secretEncVal;
        return this;
    }

    @ApiModelProperty(value="The encrypted secret value.")
    public String getSecretEncVal() {
        return this.secretEncVal;
    }

    public void setSecretEncVal(String secretEncVal) {
        this.secretEncVal = secretEncVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretAccessCredsReplyObj secretAccessCredsReplyObj = (SecretAccessCredsReplyObj)o;
        return Objects.equals(this.kfMsHostsDNSMap, secretAccessCredsReplyObj.kfMsHostsDNSMap) && Objects.equals(this.credential, secretAccessCredsReplyObj.credential) && Objects.equals(this.expiry, secretAccessCredsReplyObj.expiry) && Objects.equals(this.itemId, secretAccessCredsReplyObj.itemId) && Objects.equals(this.itemName, secretAccessCredsReplyObj.itemName) && Objects.equals(this.itemType, secretAccessCredsReplyObj.itemType) && Objects.equals(this.itemVersion, secretAccessCredsReplyObj.itemVersion) && Objects.equals(this.protectedKeyType, secretAccessCredsReplyObj.protectedKeyType) && Objects.equals(this.restrictedDd, secretAccessCredsReplyObj.restrictedDd) && Objects.equals(this.secretEncVal, secretAccessCredsReplyObj.secretEncVal);
    }

    public int hashCode() {
        return Objects.hash(this.kfMsHostsDNSMap, this.credential, this.expiry, this.itemId, this.itemName, this.itemType, this.itemVersion, this.protectedKeyType, this.restrictedDd, this.secretEncVal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecretAccessCredsReplyObj {\n");
        sb.append("    kfMsHostsDNSMap: ").append(this.toIndentedString(this.kfMsHostsDNSMap)).append("\n");
        sb.append("    credential: ").append(this.toIndentedString(this.credential)).append("\n");
        sb.append("    expiry: ").append(this.toIndentedString(this.expiry)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    itemName: ").append(this.toIndentedString(this.itemName)).append("\n");
        sb.append("    itemType: ").append(this.toIndentedString(this.itemType)).append("\n");
        sb.append("    itemVersion: ").append(this.toIndentedString(this.itemVersion)).append("\n");
        sb.append("    protectedKeyType: ").append(this.toIndentedString(this.protectedKeyType)).append("\n");
        sb.append("    restrictedDd: ").append(this.toIndentedString(this.restrictedDd)).append("\n");
        sb.append("    secretEncVal: ").append(this.toIndentedString(this.secretEncVal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

