/*
 * Decompiled with CFR 0.152.
 */
package com.akeyless.kfm.swagger.api;

import com.akeyless.kfm.swagger.ApiCallback;
import com.akeyless.kfm.swagger.ApiClient;
import com.akeyless.kfm.swagger.ApiException;
import com.akeyless.kfm.swagger.ApiResponse;
import com.akeyless.kfm.swagger.Configuration;
import com.akeyless.kfm.swagger.Pair;
import com.akeyless.kfm.swagger.ProgressRequestBody;
import com.akeyless.kfm.swagger.ProgressResponseBody;
import com.akeyless.kfm.swagger.model.DerivedFragmentReplyObj;
import com.akeyless.kfm.swagger.model.GetFragmentDetailsReplyObj;
import com.akeyless.kfm.swagger.model.KFMStatusReplyObj;
import com.akeyless.kfm.swagger.model.RSAFragmentDecryptReplyObj;
import com.akeyless.kfm.swagger.model.TimeReplyObj;
import com.akeyless.kfm.swagger.model.UploadRSAFragmentReplyObj;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultApi {
    private ApiClient apiClient;

    public DefaultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deriveFragmentCall(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String derivationData, String akeylessRequestId, String akeylessClientId, Boolean doubleDerivation, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/derive-fragment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (derivationData != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("derivation_data", derivationData));
        }
        if (doubleDerivation != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("double_derivation", doubleDerivation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null) {
            localVarHeaderParams.put("AkeylessRequestId", this.apiClient.parameterToString(akeylessRequestId));
        }
        if (akeylessClientId != null) {
            localVarHeaderParams.put("AkeylessClientId", this.apiClient.parameterToString(akeylessClientId));
        }
        if (akeylessKFMUserCreds != null) {
            localVarHeaderParams.put("AkeylessKFM-UserCreds", this.apiClient.parameterToString(akeylessKFMUserCreds));
        }
        if (akeylessKFMOperationCreds != null) {
            localVarHeaderParams.put("AkeylessKFM-OperationCreds", this.apiClient.parameterToString(akeylessKFMOperationCreds));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deriveFragmentValidateBeforeCall(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String derivationData, String akeylessRequestId, String akeylessClientId, Boolean doubleDerivation, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (akeylessKFMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessKFMUserCreds' when calling deriveFragment(Async)");
        }
        if (akeylessKFMOperationCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessKFMOperationCreds' when calling deriveFragment(Async)");
        }
        if (derivationData == null) {
            throw new ApiException("Missing the required parameter 'derivationData' when calling deriveFragment(Async)");
        }
        Call call = this.deriveFragmentCall(akeylessKFMUserCreds, akeylessKFMOperationCreds, derivationData, akeylessRequestId, akeylessClientId, doubleDerivation, progressListener, progressRequestListener);
        return call;
    }

    public DerivedFragmentReplyObj deriveFragment(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String derivationData, String akeylessRequestId, String akeylessClientId, Boolean doubleDerivation) throws ApiException {
        ApiResponse<DerivedFragmentReplyObj> resp = this.deriveFragmentWithHttpInfo(akeylessKFMUserCreds, akeylessKFMOperationCreds, derivationData, akeylessRequestId, akeylessClientId, doubleDerivation);
        return resp.getData();
    }

    public ApiResponse<DerivedFragmentReplyObj> deriveFragmentWithHttpInfo(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String derivationData, String akeylessRequestId, String akeylessClientId, Boolean doubleDerivation) throws ApiException {
        Call call = this.deriveFragmentValidateBeforeCall(akeylessKFMUserCreds, akeylessKFMOperationCreds, derivationData, akeylessRequestId, akeylessClientId, doubleDerivation, null, null);
        Type localVarReturnType = new TypeToken<DerivedFragmentReplyObj>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deriveFragmentAsync(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String derivationData, String akeylessRequestId, String akeylessClientId, Boolean doubleDerivation, final ApiCallback<DerivedFragmentReplyObj> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deriveFragmentValidateBeforeCall(akeylessKFMUserCreds, akeylessKFMOperationCreds, derivationData, akeylessRequestId, akeylessClientId, doubleDerivation, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DerivedFragmentReplyObj>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generateAESKeyFragmentCall(String akeylessKFMUserCreds, Long fragmentSize, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/generate-aes-key-fragment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (fragmentSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fragment_size", fragmentSize));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null) {
            localVarHeaderParams.put("AkeylessRequestId", this.apiClient.parameterToString(akeylessRequestId));
        }
        if (akeylessClientId != null) {
            localVarHeaderParams.put("AkeylessClientId", this.apiClient.parameterToString(akeylessClientId));
        }
        if (akeylessKFMUserCreds != null) {
            localVarHeaderParams.put("AkeylessKFM-UserCreds", this.apiClient.parameterToString(akeylessKFMUserCreds));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateAESKeyFragmentValidateBeforeCall(String akeylessKFMUserCreds, Long fragmentSize, String akeylessRequestId, String akeylessClientId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (akeylessKFMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessKFMUserCreds' when calling generateAESKeyFragment(Async)");
        }
        if (fragmentSize == null) {
            throw new ApiException("Missing the required parameter 'fragmentSize' when calling generateAESKeyFragment(Async)");
        }
        Call call = this.generateAESKeyFragmentCall(akeylessKFMUserCreds, fragmentSize, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;
    }

    public void generateAESKeyFragment(String akeylessKFMUserCreds, Long fragmentSize, String akeylessRequestId, String akeylessClientId) throws ApiException {
        this.generateAESKeyFragmentWithHttpInfo(akeylessKFMUserCreds, fragmentSize, akeylessRequestId, akeylessClientId);
    }

    public ApiResponse<Void> generateAESKeyFragmentWithHttpInfo(String akeylessKFMUserCreds, Long fragmentSize, String akeylessRequestId, String akeylessClientId) throws ApiException {
        Call call = this.generateAESKeyFragmentValidateBeforeCall(akeylessKFMUserCreds, fragmentSize, akeylessRequestId, akeylessClientId, null, null);
        return this.apiClient.execute(call);
    }

    public Call generateAESKeyFragmentAsync(String akeylessKFMUserCreds, Long fragmentSize, String akeylessRequestId, String akeylessClientId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateAESKeyFragmentValidateBeforeCall(akeylessKFMUserCreds, fragmentSize, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getFragmentDetailsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/get-fragment-details";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFragmentDetailsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getFragmentDetailsCall(progressListener, progressRequestListener);
        return call;
    }

    public GetFragmentDetailsReplyObj getFragmentDetails() throws ApiException {
        ApiResponse<GetFragmentDetailsReplyObj> resp = this.getFragmentDetailsWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<GetFragmentDetailsReplyObj> getFragmentDetailsWithHttpInfo() throws ApiException {
        Call call = this.getFragmentDetailsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<GetFragmentDetailsReplyObj>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFragmentDetailsAsync(final ApiCallback<GetFragmentDetailsReplyObj> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFragmentDetailsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetFragmentDetailsReplyObj>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getStatusCall(String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null) {
            localVarHeaderParams.put("AkeylessRequestId", this.apiClient.parameterToString(akeylessRequestId));
        }
        if (akeylessClientId != null) {
            localVarHeaderParams.put("AkeylessClientId", this.apiClient.parameterToString(akeylessClientId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getStatusValidateBeforeCall(String akeylessRequestId, String akeylessClientId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getStatusCall(akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;
    }

    public KFMStatusReplyObj getStatus(String akeylessRequestId, String akeylessClientId) throws ApiException {
        ApiResponse<KFMStatusReplyObj> resp = this.getStatusWithHttpInfo(akeylessRequestId, akeylessClientId);
        return resp.getData();
    }

    public ApiResponse<KFMStatusReplyObj> getStatusWithHttpInfo(String akeylessRequestId, String akeylessClientId) throws ApiException {
        Call call = this.getStatusValidateBeforeCall(akeylessRequestId, akeylessClientId, null, null);
        Type localVarReturnType = new TypeToken<KFMStatusReplyObj>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getStatusAsync(String akeylessRequestId, String akeylessClientId, final ApiCallback<KFMStatusReplyObj> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getStatusValidateBeforeCall(akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<KFMStatusReplyObj>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTimeCall(String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/time";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null) {
            localVarHeaderParams.put("AkeylessRequestId", this.apiClient.parameterToString(akeylessRequestId));
        }
        if (akeylessClientId != null) {
            localVarHeaderParams.put("AkeylessClientId", this.apiClient.parameterToString(akeylessClientId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTimeValidateBeforeCall(String akeylessRequestId, String akeylessClientId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTimeCall(akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;
    }

    public TimeReplyObj getTime(String akeylessRequestId, String akeylessClientId) throws ApiException {
        ApiResponse<TimeReplyObj> resp = this.getTimeWithHttpInfo(akeylessRequestId, akeylessClientId);
        return resp.getData();
    }

    public ApiResponse<TimeReplyObj> getTimeWithHttpInfo(String akeylessRequestId, String akeylessClientId) throws ApiException {
        Call call = this.getTimeValidateBeforeCall(akeylessRequestId, akeylessClientId, null, null);
        Type localVarReturnType = new TypeToken<TimeReplyObj>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTimeAsync(String akeylessRequestId, String akeylessClientId, final ApiCallback<TimeReplyObj> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTimeValidateBeforeCall(akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TimeReplyObj>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call rsaFragmentDecryptCall(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String cipher, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/rsa-fragment-decrypt";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (cipher != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cipher", cipher));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null) {
            localVarHeaderParams.put("AkeylessRequestId", this.apiClient.parameterToString(akeylessRequestId));
        }
        if (akeylessClientId != null) {
            localVarHeaderParams.put("AkeylessClientId", this.apiClient.parameterToString(akeylessClientId));
        }
        if (akeylessKFMUserCreds != null) {
            localVarHeaderParams.put("AkeylessKFM-UserCreds", this.apiClient.parameterToString(akeylessKFMUserCreds));
        }
        if (akeylessKFMOperationCreds != null) {
            localVarHeaderParams.put("AkeylessKFM-OperationCreds", this.apiClient.parameterToString(akeylessKFMOperationCreds));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call rsaFragmentDecryptValidateBeforeCall(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String cipher, String akeylessRequestId, String akeylessClientId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (akeylessKFMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessKFMUserCreds' when calling rsaFragmentDecrypt(Async)");
        }
        if (akeylessKFMOperationCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessKFMOperationCreds' when calling rsaFragmentDecrypt(Async)");
        }
        if (cipher == null) {
            throw new ApiException("Missing the required parameter 'cipher' when calling rsaFragmentDecrypt(Async)");
        }
        Call call = this.rsaFragmentDecryptCall(akeylessKFMUserCreds, akeylessKFMOperationCreds, cipher, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;
    }

    public RSAFragmentDecryptReplyObj rsaFragmentDecrypt(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String cipher, String akeylessRequestId, String akeylessClientId) throws ApiException {
        ApiResponse<RSAFragmentDecryptReplyObj> resp = this.rsaFragmentDecryptWithHttpInfo(akeylessKFMUserCreds, akeylessKFMOperationCreds, cipher, akeylessRequestId, akeylessClientId);
        return resp.getData();
    }

    public ApiResponse<RSAFragmentDecryptReplyObj> rsaFragmentDecryptWithHttpInfo(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String cipher, String akeylessRequestId, String akeylessClientId) throws ApiException {
        Call call = this.rsaFragmentDecryptValidateBeforeCall(akeylessKFMUserCreds, akeylessKFMOperationCreds, cipher, akeylessRequestId, akeylessClientId, null, null);
        Type localVarReturnType = new TypeToken<RSAFragmentDecryptReplyObj>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call rsaFragmentDecryptAsync(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String cipher, String akeylessRequestId, String akeylessClientId, final ApiCallback<RSAFragmentDecryptReplyObj> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.rsaFragmentDecryptValidateBeforeCall(akeylessKFMUserCreds, akeylessKFMOperationCreds, cipher, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RSAFragmentDecryptReplyObj>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call uploadRSAFragmentCall(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String fragmentValue, String testMessage, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/upload-rsa-fragment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (fragmentValue != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("fragment_value", fragmentValue));
        }
        if (testMessage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("test_message", testMessage));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null) {
            localVarHeaderParams.put("AkeylessRequestId", this.apiClient.parameterToString(akeylessRequestId));
        }
        if (akeylessClientId != null) {
            localVarHeaderParams.put("AkeylessClientId", this.apiClient.parameterToString(akeylessClientId));
        }
        if (akeylessKFMUserCreds != null) {
            localVarHeaderParams.put("AkeylessKFM-UserCreds", this.apiClient.parameterToString(akeylessKFMUserCreds));
        }
        if (akeylessKFMOperationCreds != null) {
            localVarHeaderParams.put("AkeylessKFM-OperationCreds", this.apiClient.parameterToString(akeylessKFMOperationCreds));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadRSAFragmentValidateBeforeCall(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String fragmentValue, String testMessage, String akeylessRequestId, String akeylessClientId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (akeylessKFMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessKFMUserCreds' when calling uploadRSAFragment(Async)");
        }
        if (akeylessKFMOperationCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessKFMOperationCreds' when calling uploadRSAFragment(Async)");
        }
        if (fragmentValue == null) {
            throw new ApiException("Missing the required parameter 'fragmentValue' when calling uploadRSAFragment(Async)");
        }
        if (testMessage == null) {
            throw new ApiException("Missing the required parameter 'testMessage' when calling uploadRSAFragment(Async)");
        }
        Call call = this.uploadRSAFragmentCall(akeylessKFMUserCreds, akeylessKFMOperationCreds, fragmentValue, testMessage, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;
    }

    public UploadRSAFragmentReplyObj uploadRSAFragment(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String fragmentValue, String testMessage, String akeylessRequestId, String akeylessClientId) throws ApiException {
        ApiResponse<UploadRSAFragmentReplyObj> resp = this.uploadRSAFragmentWithHttpInfo(akeylessKFMUserCreds, akeylessKFMOperationCreds, fragmentValue, testMessage, akeylessRequestId, akeylessClientId);
        return resp.getData();
    }

    public ApiResponse<UploadRSAFragmentReplyObj> uploadRSAFragmentWithHttpInfo(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String fragmentValue, String testMessage, String akeylessRequestId, String akeylessClientId) throws ApiException {
        Call call = this.uploadRSAFragmentValidateBeforeCall(akeylessKFMUserCreds, akeylessKFMOperationCreds, fragmentValue, testMessage, akeylessRequestId, akeylessClientId, null, null);
        Type localVarReturnType = new TypeToken<UploadRSAFragmentReplyObj>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call uploadRSAFragmentAsync(String akeylessKFMUserCreds, String akeylessKFMOperationCreds, String fragmentValue, String testMessage, String akeylessRequestId, String akeylessClientId, final ApiCallback<UploadRSAFragmentReplyObj> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uploadRSAFragmentValidateBeforeCall(akeylessKFMUserCreds, akeylessKFMOperationCreds, fragmentValue, testMessage, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UploadRSAFragmentReplyObj>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

