/*
 * Decompiled with CFR 0.152.
 */
package com.akeyless.kfm.swagger.model;

import com.akeyless.kfm.swagger.model.OAuth2CustomClaim;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OAuth2AccessRole {
    @SerializedName(value="audience")
    private String audience = null;
    @SerializedName(value="bound_claims")
    private List<OAuth2CustomClaim> boundClaims = null;
    @SerializedName(value="bound_clients_id")
    private List<String> boundClientsId = null;
    @SerializedName(value="issuer")
    private String issuer = null;
    @SerializedName(value="jwks_uri")
    private String jwksUri = null;

    public OAuth2AccessRole audience(String audience) {
        this.audience = audience;
        return this;
    }

    @ApiModelProperty(value="The audience in the JWT.")
    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public OAuth2AccessRole boundClaims(List<OAuth2CustomClaim> boundClaims) {
        this.boundClaims = boundClaims;
        return this;
    }

    public OAuth2AccessRole addBoundClaimsItem(OAuth2CustomClaim boundClaimsItem) {
        if (this.boundClaims == null) {
            this.boundClaims = new ArrayList<OAuth2CustomClaim>();
        }
        this.boundClaims.add(boundClaimsItem);
        return this;
    }

    @ApiModelProperty(value="The claims that login is restricted to.")
    public List<OAuth2CustomClaim> getBoundClaims() {
        return this.boundClaims;
    }

    public void setBoundClaims(List<OAuth2CustomClaim> boundClaims) {
        this.boundClaims = boundClaims;
    }

    public OAuth2AccessRole boundClientsId(List<String> boundClientsId) {
        this.boundClientsId = boundClientsId;
        return this;
    }

    public OAuth2AccessRole addBoundClientsIdItem(String boundClientsIdItem) {
        if (this.boundClientsId == null) {
            this.boundClientsId = new ArrayList<String>();
        }
        this.boundClientsId.add(boundClientsIdItem);
        return this;
    }

    @ApiModelProperty(value="The clients ids that login is restricted to.")
    public List<String> getBoundClientsId() {
        return this.boundClientsId;
    }

    public void setBoundClientsId(List<String> boundClientsId) {
        this.boundClientsId = boundClientsId;
    }

    public OAuth2AccessRole issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @ApiModelProperty(value="Issuer URL")
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public OAuth2AccessRole jwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    @ApiModelProperty(value="The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.")
    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2AccessRole oauth2AccessRole = (OAuth2AccessRole)o;
        return Objects.equals(this.audience, oauth2AccessRole.audience) && Objects.equals(this.boundClaims, oauth2AccessRole.boundClaims) && Objects.equals(this.boundClientsId, oauth2AccessRole.boundClientsId) && Objects.equals(this.issuer, oauth2AccessRole.issuer) && Objects.equals(this.jwksUri, oauth2AccessRole.jwksUri);
    }

    public int hashCode() {
        return Objects.hash(this.audience, this.boundClaims, this.boundClientsId, this.issuer, this.jwksUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2AccessRole {\n");
        sb.append("    audience: ").append(this.toIndentedString(this.audience)).append("\n");
        sb.append("    boundClaims: ").append(this.toIndentedString(this.boundClaims)).append("\n");
        sb.append("    boundClientsId: ").append(this.toIndentedString(this.boundClientsId)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    jwksUri: ").append(this.toIndentedString(this.jwksUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

