/*
 * Decompiled with CFR 0.152.
 */
package com.akeyless.kfm.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Temporary access credentials to perform decrypt operation on a fragments from KFM instances together with the KFMs host names.")
public class RSADecryptCredsReplyObj {
    @SerializedName(value="KFMsHostsDNSMap")
    private Map<String, String> kfMsHostsDNSMap = null;
    @SerializedName(value="certificates")
    private String certificates = null;
    @SerializedName(value="credential")
    private String credential = null;
    @SerializedName(value="customer_fragment_id")
    private String customerFragmentId = null;
    @SerializedName(value="expiry")
    private Long expiry = null;
    @SerializedName(value="item_id")
    private Long itemId = null;
    @SerializedName(value="item_name")
    private String itemName = null;
    @SerializedName(value="item_size")
    private Long itemSize = null;
    @SerializedName(value="item_type")
    private String itemType = null;
    @SerializedName(value="item_version")
    private Integer itemVersion = null;
    @SerializedName(value="public_value")
    private String publicValue = null;

    public RSADecryptCredsReplyObj kfMsHostsDNSMap(Map<String, String> kfMsHostsDNSMap) {
        this.kfMsHostsDNSMap = kfMsHostsDNSMap;
        return this;
    }

    public RSADecryptCredsReplyObj putKfMsHostsDNSMapItem(String key, String kfMsHostsDNSMapItem) {
        if (this.kfMsHostsDNSMap == null) {
            this.kfMsHostsDNSMap = new HashMap<String, String>();
        }
        this.kfMsHostsDNSMap.put(key, kfMsHostsDNSMapItem);
        return this;
    }

    @ApiModelProperty(value="Mapping between the serial number of the item fragments and the KFMs hosts DNS in which they are stored.")
    public Map<String, String> getKfMsHostsDNSMap() {
        return this.kfMsHostsDNSMap;
    }

    public void setKfMsHostsDNSMap(Map<String, String> kfMsHostsDNSMap) {
        this.kfMsHostsDNSMap = kfMsHostsDNSMap;
    }

    public RSADecryptCredsReplyObj certificates(String certificates) {
        this.certificates = certificates;
        return this;
    }

    @ApiModelProperty(value="")
    public String getCertificates() {
        return this.certificates;
    }

    public void setCertificates(String certificates) {
        this.certificates = certificates;
    }

    public RSADecryptCredsReplyObj credential(String credential) {
        this.credential = credential;
        return this;
    }

    @ApiModelProperty(value="Temporary credentials string (JWT format)")
    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public RSADecryptCredsReplyObj customerFragmentId(String customerFragmentId) {
        this.customerFragmentId = customerFragmentId;
        return this;
    }

    @ApiModelProperty(value="The customer fragment ID associated with this item (if any).")
    public String getCustomerFragmentId() {
        return this.customerFragmentId;
    }

    public void setCustomerFragmentId(String customerFragmentId) {
        this.customerFragmentId = customerFragmentId;
    }

    public RSADecryptCredsReplyObj expiry(Long expiry) {
        this.expiry = expiry;
        return this;
    }

    @ApiModelProperty(value="Credentials expiration date")
    public Long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Long expiry) {
        this.expiry = expiry;
    }

    public RSADecryptCredsReplyObj itemId(Long itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public RSADecryptCredsReplyObj itemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    @ApiModelProperty(value="The name, id, version, type, size and public key value of the item that the fragments belong to")
    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public RSADecryptCredsReplyObj itemSize(Long itemSize) {
        this.itemSize = itemSize;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(Long itemSize) {
        this.itemSize = itemSize;
    }

    public RSADecryptCredsReplyObj itemType(String itemType) {
        this.itemType = itemType;
        return this;
    }

    @ApiModelProperty(value="")
    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public RSADecryptCredsReplyObj itemVersion(Integer itemVersion) {
        this.itemVersion = itemVersion;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getItemVersion() {
        return this.itemVersion;
    }

    public void setItemVersion(Integer itemVersion) {
        this.itemVersion = itemVersion;
    }

    public RSADecryptCredsReplyObj publicValue(String publicValue) {
        this.publicValue = publicValue;
        return this;
    }

    @ApiModelProperty(value="")
    public String getPublicValue() {
        return this.publicValue;
    }

    public void setPublicValue(String publicValue) {
        this.publicValue = publicValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RSADecryptCredsReplyObj rsADecryptCredsReplyObj = (RSADecryptCredsReplyObj)o;
        return Objects.equals(this.kfMsHostsDNSMap, rsADecryptCredsReplyObj.kfMsHostsDNSMap) && Objects.equals(this.certificates, rsADecryptCredsReplyObj.certificates) && Objects.equals(this.credential, rsADecryptCredsReplyObj.credential) && Objects.equals(this.customerFragmentId, rsADecryptCredsReplyObj.customerFragmentId) && Objects.equals(this.expiry, rsADecryptCredsReplyObj.expiry) && Objects.equals(this.itemId, rsADecryptCredsReplyObj.itemId) && Objects.equals(this.itemName, rsADecryptCredsReplyObj.itemName) && Objects.equals(this.itemSize, rsADecryptCredsReplyObj.itemSize) && Objects.equals(this.itemType, rsADecryptCredsReplyObj.itemType) && Objects.equals(this.itemVersion, rsADecryptCredsReplyObj.itemVersion) && Objects.equals(this.publicValue, rsADecryptCredsReplyObj.publicValue);
    }

    public int hashCode() {
        return Objects.hash(this.kfMsHostsDNSMap, this.certificates, this.credential, this.customerFragmentId, this.expiry, this.itemId, this.itemName, this.itemSize, this.itemType, this.itemVersion, this.publicValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RSADecryptCredsReplyObj {\n");
        sb.append("    kfMsHostsDNSMap: ").append(this.toIndentedString(this.kfMsHostsDNSMap)).append("\n");
        sb.append("    certificates: ").append(this.toIndentedString(this.certificates)).append("\n");
        sb.append("    credential: ").append(this.toIndentedString(this.credential)).append("\n");
        sb.append("    customerFragmentId: ").append(this.toIndentedString(this.customerFragmentId)).append("\n");
        sb.append("    expiry: ").append(this.toIndentedString(this.expiry)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    itemName: ").append(this.toIndentedString(this.itemName)).append("\n");
        sb.append("    itemSize: ").append(this.toIndentedString(this.itemSize)).append("\n");
        sb.append("    itemType: ").append(this.toIndentedString(this.itemType)).append("\n");
        sb.append("    itemVersion: ").append(this.toIndentedString(this.itemVersion)).append("\n");
        sb.append("    publicValue: ").append(this.toIndentedString(this.publicValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

