/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.api;

import com.akeyless.uam.swagger.ApiCallback;
import com.akeyless.uam.swagger.ApiClient;
import com.akeyless.uam.swagger.ApiException;
import com.akeyless.uam.swagger.ApiResponse;
import com.akeyless.uam.swagger.Configuration;
import com.akeyless.uam.swagger.Pair;
import com.akeyless.uam.swagger.ProgressRequestBody;
import com.akeyless.uam.swagger.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.akeyless.uam.swagger.model.CreateAccountReplyObj;
import com.akeyless.uam.swagger.model.CreateUserReplyObj;
import com.akeyless.uam.swagger.model.DerivationCredsReplyObj;
import com.akeyless.uam.swagger.model.DynamicSecretMQAccessReplyObj;
import com.akeyless.uam.swagger.model.DynamicSecretProducerCredsReplyObj;
import com.akeyless.uam.swagger.model.ErrorReplyObj;
import com.akeyless.uam.swagger.model.GetAccountDetailsReplyObj;
import com.akeyless.uam.swagger.model.GetAccountRolesReplyObj;
import com.akeyless.uam.swagger.model.GetAccountUsersReplyObj;
import com.akeyless.uam.swagger.model.GetItemReplyObj;
import com.akeyless.uam.swagger.model.GetRoleReplyObj;
import com.akeyless.uam.swagger.model.GetUserItemsReplyObj;
import com.akeyless.uam.swagger.model.GetUserReplyObj;
import com.akeyless.uam.swagger.model.PrepareDynamicSecretValueReplyObj;
import com.akeyless.uam.swagger.model.PullDynamicSecretValueReplyObj;
import com.akeyless.uam.swagger.model.RSADecryptCredsReplyObj;
import com.akeyless.uam.swagger.model.SecretAccessCredsReplyObj;
import com.akeyless.uam.swagger.model.UAMStatusReplyObj;
import com.akeyless.uam.swagger.model.UploadRSAKeyCredsReplyObj;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultApi {
    private ApiClient apiClient;

    public DefaultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for createAccount
     * @param akeylessCreateAccountCreds Temporary credentials for accessing the endpoint (required)
     * @param name The customer name (required)
     * @param customerAddress The customer address (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createAccountCall(String akeylessCreateAccountCreds, String name, String customerAddress, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/account";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
        if (customerAddress != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("customer_address", customerAddress));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessCreateAccountCreds != null)
        localVarHeaderParams.put("Akeyless-CreateAccountCreds", apiClient.parameterToString(akeylessCreateAccountCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createAccountValidateBeforeCall(String akeylessCreateAccountCreds, String name, String customerAddress, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessCreateAccountCreds' is set
        if (akeylessCreateAccountCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessCreateAccountCreds' when calling createAccount(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createAccount(Async)");
        }
        
        // verify the required parameter 'customerAddress' is set
        if (customerAddress == null) {
            throw new ApiException("Missing the required parameter 'customerAddress' when calling createAccount(Async)");
        }
        

        com.squareup.okhttp.Call call = createAccountCall(akeylessCreateAccountCreds, name, customerAddress, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create new account.
     * 
     * @param akeylessCreateAccountCreds Temporary credentials for accessing the endpoint (required)
     * @param name The customer name (required)
     * @param customerAddress The customer address (required)
     * @return CreateAccountReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CreateAccountReplyObj createAccount(String akeylessCreateAccountCreds, String name, String customerAddress) throws ApiException {
        ApiResponse<CreateAccountReplyObj> resp = createAccountWithHttpInfo(akeylessCreateAccountCreds, name, customerAddress);
        return resp.getData();
    }

    /**
     * Create new account.
     * 
     * @param akeylessCreateAccountCreds Temporary credentials for accessing the endpoint (required)
     * @param name The customer name (required)
     * @param customerAddress The customer address (required)
     * @return ApiResponse&lt;CreateAccountReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CreateAccountReplyObj> createAccountWithHttpInfo(String akeylessCreateAccountCreds, String name, String customerAddress) throws ApiException {
        com.squareup.okhttp.Call call = createAccountValidateBeforeCall(akeylessCreateAccountCreds, name, customerAddress, null, null);
        Type localVarReturnType = new TypeToken<CreateAccountReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create new account. (asynchronously)
     * 
     * @param akeylessCreateAccountCreds Temporary credentials for accessing the endpoint (required)
     * @param name The customer name (required)
     * @param customerAddress The customer address (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createAccountAsync(String akeylessCreateAccountCreds, String name, String customerAddress, final ApiCallback<CreateAccountReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createAccountValidateBeforeCall(akeylessCreateAccountCreds, name, customerAddress, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateAccountReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for createItem
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name to be created (required)
     * @param itemType The type of the item to be created Types available are: [AES128GCM, AES256GCM, AES128SIV, AES256SIV] (required)
     * @param userMetadata User metadata about the item. (required)
     * @param splitLevel The splitting level represent the number of fragments that the item will be split into. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param size The length of the item to be created. (optional)
     * @param customerFragmentId The customer fragment ID associated with this item (if any). (optional)
     * @param uploadRsaKeyCreds The credentials to upload an RSA key. this parameter relevant only in case of item of RSA Key. in this case all the item&#39;s creation parameters should be correlated with the parameters in the UploadRSAKeyCreds. (optional)
     * @param uploadSecretCreds The credentials to upload a secret. this parameter relevant only in case of create a new secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret. (optional)
     * @param secretEncVal The encrypted secret value. this parameter relevant only in case of create a new secret. This parameter should contain the encrypted secret that is encrypted using the protection key. (optional)
     * @param protectionKeyName The name of the key that will be used to encrypt a dynamic secret. If not provided, the account default secret key will be used. This parameter relevant only in case of create a new dynamic secret. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createItemCall(String akeylessUAMUserCreds, String itemName, String itemType, String userMetadata, Long splitLevel, String akeylessRequestId, String akeylessClientId, Long size, String customerFragmentId, String uploadRsaKeyCreds, String uploadSecretCreds, String secretEncVal, String protectionKeyName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/item";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_name", itemName));
        if (itemType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_type", itemType));
        if (userMetadata != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("user_metadata", userMetadata));
        if (splitLevel != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("split_level", splitLevel));
        if (size != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("size", size));
        if (customerFragmentId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("customer_fragment_id", customerFragmentId));
        if (uploadRsaKeyCreds != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("upload_rsa_key_creds", uploadRsaKeyCreds));
        if (uploadSecretCreds != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("upload_secret_creds", uploadSecretCreds));
        if (secretEncVal != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("secret_enc_val", secretEncVal));
        if (protectionKeyName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("protection_key_name", protectionKeyName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createItemValidateBeforeCall(String akeylessUAMUserCreds, String itemName, String itemType, String userMetadata, Long splitLevel, String akeylessRequestId, String akeylessClientId, Long size, String customerFragmentId, String uploadRsaKeyCreds, String uploadSecretCreds, String secretEncVal, String protectionKeyName, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling createItem(Async)");
        }
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling createItem(Async)");
        }
        
        // verify the required parameter 'itemType' is set
        if (itemType == null) {
            throw new ApiException("Missing the required parameter 'itemType' when calling createItem(Async)");
        }
        
        // verify the required parameter 'userMetadata' is set
        if (userMetadata == null) {
            throw new ApiException("Missing the required parameter 'userMetadata' when calling createItem(Async)");
        }
        
        // verify the required parameter 'splitLevel' is set
        if (splitLevel == null) {
            throw new ApiException("Missing the required parameter 'splitLevel' when calling createItem(Async)");
        }
        

        com.squareup.okhttp.Call call = createItemCall(akeylessUAMUserCreds, itemName, itemType, userMetadata, splitLevel, akeylessRequestId, akeylessClientId, size, customerFragmentId, uploadRsaKeyCreds, uploadSecretCreds, secretEncVal, protectionKeyName, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a new item to the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name to be created (required)
     * @param itemType The type of the item to be created Types available are: [AES128GCM, AES256GCM, AES128SIV, AES256SIV] (required)
     * @param userMetadata User metadata about the item. (required)
     * @param splitLevel The splitting level represent the number of fragments that the item will be split into. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param size The length of the item to be created. (optional)
     * @param customerFragmentId The customer fragment ID associated with this item (if any). (optional)
     * @param uploadRsaKeyCreds The credentials to upload an RSA key. this parameter relevant only in case of item of RSA Key. in this case all the item&#39;s creation parameters should be correlated with the parameters in the UploadRSAKeyCreds. (optional)
     * @param uploadSecretCreds The credentials to upload a secret. this parameter relevant only in case of create a new secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret. (optional)
     * @param secretEncVal The encrypted secret value. this parameter relevant only in case of create a new secret. This parameter should contain the encrypted secret that is encrypted using the protection key. (optional)
     * @param protectionKeyName The name of the key that will be used to encrypt a dynamic secret. If not provided, the account default secret key will be used. This parameter relevant only in case of create a new dynamic secret. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void createItem(String akeylessUAMUserCreds, String itemName, String itemType, String userMetadata, Long splitLevel, String akeylessRequestId, String akeylessClientId, Long size, String customerFragmentId, String uploadRsaKeyCreds, String uploadSecretCreds, String secretEncVal, String protectionKeyName) throws ApiException {
        createItemWithHttpInfo(akeylessUAMUserCreds, itemName, itemType, userMetadata, splitLevel, akeylessRequestId, akeylessClientId, size, customerFragmentId, uploadRsaKeyCreds, uploadSecretCreds, secretEncVal, protectionKeyName);
    }

    /**
     * Add a new item to the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name to be created (required)
     * @param itemType The type of the item to be created Types available are: [AES128GCM, AES256GCM, AES128SIV, AES256SIV] (required)
     * @param userMetadata User metadata about the item. (required)
     * @param splitLevel The splitting level represent the number of fragments that the item will be split into. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param size The length of the item to be created. (optional)
     * @param customerFragmentId The customer fragment ID associated with this item (if any). (optional)
     * @param uploadRsaKeyCreds The credentials to upload an RSA key. this parameter relevant only in case of item of RSA Key. in this case all the item&#39;s creation parameters should be correlated with the parameters in the UploadRSAKeyCreds. (optional)
     * @param uploadSecretCreds The credentials to upload a secret. this parameter relevant only in case of create a new secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret. (optional)
     * @param secretEncVal The encrypted secret value. this parameter relevant only in case of create a new secret. This parameter should contain the encrypted secret that is encrypted using the protection key. (optional)
     * @param protectionKeyName The name of the key that will be used to encrypt a dynamic secret. If not provided, the account default secret key will be used. This parameter relevant only in case of create a new dynamic secret. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> createItemWithHttpInfo(String akeylessUAMUserCreds, String itemName, String itemType, String userMetadata, Long splitLevel, String akeylessRequestId, String akeylessClientId, Long size, String customerFragmentId, String uploadRsaKeyCreds, String uploadSecretCreds, String secretEncVal, String protectionKeyName) throws ApiException {
        com.squareup.okhttp.Call call = createItemValidateBeforeCall(akeylessUAMUserCreds, itemName, itemType, userMetadata, splitLevel, akeylessRequestId, akeylessClientId, size, customerFragmentId, uploadRsaKeyCreds, uploadSecretCreds, secretEncVal, protectionKeyName, null, null);
        return apiClient.execute(call);
    }

    /**
     * Add a new item to the account. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name to be created (required)
     * @param itemType The type of the item to be created Types available are: [AES128GCM, AES256GCM, AES128SIV, AES256SIV] (required)
     * @param userMetadata User metadata about the item. (required)
     * @param splitLevel The splitting level represent the number of fragments that the item will be split into. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param size The length of the item to be created. (optional)
     * @param customerFragmentId The customer fragment ID associated with this item (if any). (optional)
     * @param uploadRsaKeyCreds The credentials to upload an RSA key. this parameter relevant only in case of item of RSA Key. in this case all the item&#39;s creation parameters should be correlated with the parameters in the UploadRSAKeyCreds. (optional)
     * @param uploadSecretCreds The credentials to upload a secret. this parameter relevant only in case of create a new secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret. (optional)
     * @param secretEncVal The encrypted secret value. this parameter relevant only in case of create a new secret. This parameter should contain the encrypted secret that is encrypted using the protection key. (optional)
     * @param protectionKeyName The name of the key that will be used to encrypt a dynamic secret. If not provided, the account default secret key will be used. This parameter relevant only in case of create a new dynamic secret. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createItemAsync(String akeylessUAMUserCreds, String itemName, String itemType, String userMetadata, Long splitLevel, String akeylessRequestId, String akeylessClientId, Long size, String customerFragmentId, String uploadRsaKeyCreds, String uploadSecretCreds, String secretEncVal, String protectionKeyName, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createItemValidateBeforeCall(akeylessUAMUserCreds, itemName, itemType, userMetadata, splitLevel, akeylessRequestId, akeylessClientId, size, customerFragmentId, uploadRsaKeyCreds, uploadSecretCreds, secretEncVal, protectionKeyName, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for createRole
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newRoleName The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param roleAction The role action. (optional)
     * @param comment Comments (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createRoleCall(String akeylessUAMUserCreds, String newRoleName, String akeylessRequestId, String akeylessClientId, String roleAction, String comment, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/role";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (newRoleName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("new_role_name", newRoleName));
        if (roleAction != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("role_action", roleAction));
        if (comment != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("comment", comment));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createRoleValidateBeforeCall(String akeylessUAMUserCreds, String newRoleName, String akeylessRequestId, String akeylessClientId, String roleAction, String comment, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling createRole(Async)");
        }
        
        // verify the required parameter 'newRoleName' is set
        if (newRoleName == null) {
            throw new ApiException("Missing the required parameter 'newRoleName' when calling createRole(Async)");
        }
        

        com.squareup.okhttp.Call call = createRoleCall(akeylessUAMUserCreds, newRoleName, akeylessRequestId, akeylessClientId, roleAction, comment, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a new role to the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newRoleName The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param roleAction The role action. (optional)
     * @param comment Comments (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void createRole(String akeylessUAMUserCreds, String newRoleName, String akeylessRequestId, String akeylessClientId, String roleAction, String comment) throws ApiException {
        createRoleWithHttpInfo(akeylessUAMUserCreds, newRoleName, akeylessRequestId, akeylessClientId, roleAction, comment);
    }

    /**
     * Add a new role to the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newRoleName The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param roleAction The role action. (optional)
     * @param comment Comments (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> createRoleWithHttpInfo(String akeylessUAMUserCreds, String newRoleName, String akeylessRequestId, String akeylessClientId, String roleAction, String comment) throws ApiException {
        com.squareup.okhttp.Call call = createRoleValidateBeforeCall(akeylessUAMUserCreds, newRoleName, akeylessRequestId, akeylessClientId, roleAction, comment, null, null);
        return apiClient.execute(call);
    }

    /**
     * Add a new role to the account. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newRoleName The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param roleAction The role action. (optional)
     * @param comment Comments (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createRoleAsync(String akeylessUAMUserCreds, String newRoleName, String akeylessRequestId, String akeylessClientId, String roleAction, String comment, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createRoleValidateBeforeCall(akeylessUAMUserCreds, newRoleName, akeylessRequestId, akeylessClientId, roleAction, comment, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for createRoleItemAssoc
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createRoleItemAssocCall(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/role-item-assoc";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (roleName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("role_name", roleName));
        if (associatedName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("associated_name", associatedName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createRoleItemAssocValidateBeforeCall(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling createRoleItemAssoc(Async)");
        }
        
        // verify the required parameter 'roleName' is set
        if (roleName == null) {
            throw new ApiException("Missing the required parameter 'roleName' when calling createRoleItemAssoc(Async)");
        }
        
        // verify the required parameter 'associatedName' is set
        if (associatedName == null) {
            throw new ApiException("Missing the required parameter 'associatedName' when calling createRoleItemAssoc(Async)");
        }
        

        com.squareup.okhttp.Call call = createRoleItemAssocCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add an association between a role and an item.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void createRoleItemAssoc(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        createRoleItemAssocWithHttpInfo(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId);
    }

    /**
     * Add an association between a role and an item.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> createRoleItemAssocWithHttpInfo(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = createRoleItemAssocValidateBeforeCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Add an association between a role and an item. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createRoleItemAssocAsync(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createRoleItemAssocValidateBeforeCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for createRoleUserAssoc
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createRoleUserAssocCall(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/role-user-assoc";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (roleName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("role_name", roleName));
        if (associatedName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("associated_name", associatedName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createRoleUserAssocValidateBeforeCall(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling createRoleUserAssoc(Async)");
        }
        
        // verify the required parameter 'roleName' is set
        if (roleName == null) {
            throw new ApiException("Missing the required parameter 'roleName' when calling createRoleUserAssoc(Async)");
        }
        
        // verify the required parameter 'associatedName' is set
        if (associatedName == null) {
            throw new ApiException("Missing the required parameter 'associatedName' when calling createRoleUserAssoc(Async)");
        }
        

        com.squareup.okhttp.Call call = createRoleUserAssocCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add an association between a role and a user.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void createRoleUserAssoc(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        createRoleUserAssocWithHttpInfo(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId);
    }

    /**
     * Add an association between a role and a user.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> createRoleUserAssocWithHttpInfo(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = createRoleUserAssocValidateBeforeCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Add an association between a role and a user. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createRoleUserAssocAsync(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createRoleUserAssocValidateBeforeCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for createUser
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessSetUserAccessCreds Temporary credentials for accessing the endpoint (required)
     * @param newUserName The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createUserCall(String akeylessUAMUserCreds, String akeylessSetUserAccessCreds, String newUserName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/user";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (newUserName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("new_user_name", newUserName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));
        if (akeylessSetUserAccessCreds != null)
        localVarHeaderParams.put("Akeyless-SetUserAccessCreds", apiClient.parameterToString(akeylessSetUserAccessCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createUserValidateBeforeCall(String akeylessUAMUserCreds, String akeylessSetUserAccessCreds, String newUserName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling createUser(Async)");
        }
        
        // verify the required parameter 'akeylessSetUserAccessCreds' is set
        if (akeylessSetUserAccessCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessSetUserAccessCreds' when calling createUser(Async)");
        }
        
        // verify the required parameter 'newUserName' is set
        if (newUserName == null) {
            throw new ApiException("Missing the required parameter 'newUserName' when calling createUser(Async)");
        }
        

        com.squareup.okhttp.Call call = createUserCall(akeylessUAMUserCreds, akeylessSetUserAccessCreds, newUserName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add a new user to the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessSetUserAccessCreds Temporary credentials for accessing the endpoint (required)
     * @param newUserName The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return CreateUserReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CreateUserReplyObj createUser(String akeylessUAMUserCreds, String akeylessSetUserAccessCreds, String newUserName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        ApiResponse<CreateUserReplyObj> resp = createUserWithHttpInfo(akeylessUAMUserCreds, akeylessSetUserAccessCreds, newUserName, akeylessRequestId, akeylessClientId);
        return resp.getData();
    }

    /**
     * Add a new user to the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessSetUserAccessCreds Temporary credentials for accessing the endpoint (required)
     * @param newUserName The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;CreateUserReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CreateUserReplyObj> createUserWithHttpInfo(String akeylessUAMUserCreds, String akeylessSetUserAccessCreds, String newUserName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = createUserValidateBeforeCall(akeylessUAMUserCreds, akeylessSetUserAccessCreds, newUserName, akeylessRequestId, akeylessClientId, null, null);
        Type localVarReturnType = new TypeToken<CreateUserReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add a new user to the account. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessSetUserAccessCreds Temporary credentials for accessing the endpoint (required)
     * @param newUserName The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createUserAsync(String akeylessUAMUserCreds, String akeylessSetUserAccessCreds, String newUserName, String akeylessRequestId, String akeylessClientId, final ApiCallback<CreateUserReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createUserValidateBeforeCall(akeylessUAMUserCreds, akeylessSetUserAccessCreds, newUserName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateUserReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteItem
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteItemCall(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/item/{item_name}"
            .replaceAll("\\{" + "item_name" + "\\}", apiClient.escapeString(itemName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteItemValidateBeforeCall(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling deleteItem(Async)");
        }
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling deleteItem(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteItemCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Deleting an existing item from the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteItem(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        deleteItemWithHttpInfo(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId);
    }

    /**
     * Deleting an existing item from the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteItemWithHttpInfo(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = deleteItemValidateBeforeCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Deleting an existing item from the account. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteItemAsync(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteItemValidateBeforeCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteRole
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteRoleCall(String akeylessUAMUserCreds, String roleName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/role/{role_name}"
            .replaceAll("\\{" + "role_name" + "\\}", apiClient.escapeString(roleName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteRoleValidateBeforeCall(String akeylessUAMUserCreds, String roleName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling deleteRole(Async)");
        }
        
        // verify the required parameter 'roleName' is set
        if (roleName == null) {
            throw new ApiException("Missing the required parameter 'roleName' when calling deleteRole(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteRoleCall(akeylessUAMUserCreds, roleName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Deleting an existing role from the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteRole(String akeylessUAMUserCreds, String roleName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        deleteRoleWithHttpInfo(akeylessUAMUserCreds, roleName, akeylessRequestId, akeylessClientId);
    }

    /**
     * Deleting an existing role from the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteRoleWithHttpInfo(String akeylessUAMUserCreds, String roleName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = deleteRoleValidateBeforeCall(akeylessUAMUserCreds, roleName, akeylessRequestId, akeylessClientId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Deleting an existing role from the account. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteRoleAsync(String akeylessUAMUserCreds, String roleName, String akeylessRequestId, String akeylessClientId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteRoleValidateBeforeCall(akeylessUAMUserCreds, roleName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteRoleItemAssoc
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteRoleItemAssocCall(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/role-item-assoc";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (roleName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("role_name", roleName));
        if (associatedName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("associated_name", associatedName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteRoleItemAssocValidateBeforeCall(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling deleteRoleItemAssoc(Async)");
        }
        
        // verify the required parameter 'roleName' is set
        if (roleName == null) {
            throw new ApiException("Missing the required parameter 'roleName' when calling deleteRoleItemAssoc(Async)");
        }
        
        // verify the required parameter 'associatedName' is set
        if (associatedName == null) {
            throw new ApiException("Missing the required parameter 'associatedName' when calling deleteRoleItemAssoc(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteRoleItemAssocCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Deleting an association between a role and an item.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteRoleItemAssoc(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        deleteRoleItemAssocWithHttpInfo(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId);
    }

    /**
     * Deleting an association between a role and an item.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteRoleItemAssocWithHttpInfo(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = deleteRoleItemAssocValidateBeforeCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Deleting an association between a role and an item. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteRoleItemAssocAsync(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteRoleItemAssocValidateBeforeCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteRoleUserAssoc
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteRoleUserAssocCall(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/role-user-assoc";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (roleName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("role_name", roleName));
        if (associatedName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("associated_name", associatedName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteRoleUserAssocValidateBeforeCall(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling deleteRoleUserAssoc(Async)");
        }
        
        // verify the required parameter 'roleName' is set
        if (roleName == null) {
            throw new ApiException("Missing the required parameter 'roleName' when calling deleteRoleUserAssoc(Async)");
        }
        
        // verify the required parameter 'associatedName' is set
        if (associatedName == null) {
            throw new ApiException("Missing the required parameter 'associatedName' when calling deleteRoleUserAssoc(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteRoleUserAssocCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Deleting an association between a role and an user.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteRoleUserAssoc(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        deleteRoleUserAssocWithHttpInfo(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId);
    }

    /**
     * Deleting an association between a role and an user.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteRoleUserAssocWithHttpInfo(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = deleteRoleUserAssocValidateBeforeCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Deleting an association between a role and an user. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName The role name to be associated (required)
     * @param associatedName The item or user name to be associated. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteRoleUserAssocAsync(String akeylessUAMUserCreds, String roleName, String associatedName, String akeylessRequestId, String akeylessClientId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteRoleUserAssocValidateBeforeCall(akeylessUAMUserCreds, roleName, associatedName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteUser
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteUserCall(String akeylessUAMUserCreds, String userName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/user/{user_name}"
            .replaceAll("\\{" + "user_name" + "\\}", apiClient.escapeString(userName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteUserValidateBeforeCall(String akeylessUAMUserCreds, String userName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling deleteUser(Async)");
        }
        
        // verify the required parameter 'userName' is set
        if (userName == null) {
            throw new ApiException("Missing the required parameter 'userName' when calling deleteUser(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteUserCall(akeylessUAMUserCreds, userName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Deleting an existing user from the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteUser(String akeylessUAMUserCreds, String userName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        deleteUserWithHttpInfo(akeylessUAMUserCreds, userName, akeylessRequestId, akeylessClientId);
    }

    /**
     * Deleting an existing user from the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteUserWithHttpInfo(String akeylessUAMUserCreds, String userName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = deleteUserValidateBeforeCall(akeylessUAMUserCreds, userName, akeylessRequestId, akeylessClientId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Deleting an existing user from the account. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteUserAsync(String akeylessUAMUserCreds, String userName, String akeylessRequestId, String akeylessClientId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteUserValidateBeforeCall(akeylessUAMUserCreds, userName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getAccountDetails
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAccountDetailsCall(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/account/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAccountDetailsValidateBeforeCall(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getAccountDetails(Async)");
        }
        

        com.squareup.okhttp.Call call = getAccountDetailsCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get account details.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return GetAccountDetailsReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetAccountDetailsReplyObj getAccountDetails(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId) throws ApiException {
        ApiResponse<GetAccountDetailsReplyObj> resp = getAccountDetailsWithHttpInfo(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId);
        return resp.getData();
    }

    /**
     * Get account details.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;GetAccountDetailsReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetAccountDetailsReplyObj> getAccountDetailsWithHttpInfo(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = getAccountDetailsValidateBeforeCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, null, null);
        Type localVarReturnType = new TypeToken<GetAccountDetailsReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get account details. (asynchronously)
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAccountDetailsAsync(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, final ApiCallback<GetAccountDetailsReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAccountDetailsValidateBeforeCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetAccountDetailsReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAccountRoles
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAccountRolesCall(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/roles";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAccountRolesValidateBeforeCall(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getAccountRoles(Async)");
        }
        

        com.squareup.okhttp.Call call = getAccountRolesCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get All the existing roles in the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return GetAccountRolesReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetAccountRolesReplyObj getAccountRoles(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId) throws ApiException {
        ApiResponse<GetAccountRolesReplyObj> resp = getAccountRolesWithHttpInfo(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId);
        return resp.getData();
    }

    /**
     * Get All the existing roles in the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;GetAccountRolesReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetAccountRolesReplyObj> getAccountRolesWithHttpInfo(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = getAccountRolesValidateBeforeCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, null, null);
        Type localVarReturnType = new TypeToken<GetAccountRolesReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get All the existing roles in the account. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAccountRolesAsync(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, final ApiCallback<GetAccountRolesReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAccountRolesValidateBeforeCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetAccountRolesReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAccountUsers
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAccountUsersCall(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/users";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAccountUsersValidateBeforeCall(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getAccountUsers(Async)");
        }
        

        com.squareup.okhttp.Call call = getAccountUsersCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get All the existing users in the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return GetAccountUsersReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetAccountUsersReplyObj getAccountUsers(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId) throws ApiException {
        ApiResponse<GetAccountUsersReplyObj> resp = getAccountUsersWithHttpInfo(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId);
        return resp.getData();
    }

    /**
     * Get All the existing users in the account.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;GetAccountUsersReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetAccountUsersReplyObj> getAccountUsersWithHttpInfo(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = getAccountUsersValidateBeforeCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, null, null);
        Type localVarReturnType = new TypeToken<GetAccountUsersReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get All the existing users in the account. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAccountUsersAsync(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, final ApiCallback<GetAccountUsersReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAccountUsersValidateBeforeCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetAccountUsersReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDynamicSecretMQAccess
     * @param itemName The dynamic secret item name (required)
     * @param waitTimeSeconds The duration (in seconds) for which the receive message request to the MQ waits for a message to arrive in the queue before returning. If a message is available, the call returns sooner than WaitTimeSeconds. If no messages are available and the wait time expires, the call returns successfully with an empty list of messages. (optional, default to 20)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDynamicSecretMQAccessCall(String itemName, Long waitTimeSeconds, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/dynamic-secret-mq-access";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_name", itemName));
        if (waitTimeSeconds != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("wait_time_seconds", waitTimeSeconds));
        if (credsExpiry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("creds_expiry", credsExpiry));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDynamicSecretMQAccessValidateBeforeCall(String itemName, Long waitTimeSeconds, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling getDynamicSecretMQAccess(Async)");
        }
        

        com.squareup.okhttp.Call call = getDynamicSecretMQAccessCall(itemName, waitTimeSeconds, credsExpiry, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a signed request to receive messages from a Message Queue of a Dynamic Secret.
     * 
     * @param itemName The dynamic secret item name (required)
     * @param waitTimeSeconds The duration (in seconds) for which the receive message request to the MQ waits for a message to arrive in the queue before returning. If a message is available, the call returns sooner than WaitTimeSeconds. If no messages are available and the wait time expires, the call returns successfully with an empty list of messages. (optional, default to 20)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return DynamicSecretMQAccessReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DynamicSecretMQAccessReplyObj getDynamicSecretMQAccess(String itemName, Long waitTimeSeconds, Long credsExpiry) throws ApiException {
        ApiResponse<DynamicSecretMQAccessReplyObj> resp = getDynamicSecretMQAccessWithHttpInfo(itemName, waitTimeSeconds, credsExpiry);
        return resp.getData();
    }

    /**
     * Get a signed request to receive messages from a Message Queue of a Dynamic Secret.
     * 
     * @param itemName The dynamic secret item name (required)
     * @param waitTimeSeconds The duration (in seconds) for which the receive message request to the MQ waits for a message to arrive in the queue before returning. If a message is available, the call returns sooner than WaitTimeSeconds. If no messages are available and the wait time expires, the call returns successfully with an empty list of messages. (optional, default to 20)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return ApiResponse&lt;DynamicSecretMQAccessReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DynamicSecretMQAccessReplyObj> getDynamicSecretMQAccessWithHttpInfo(String itemName, Long waitTimeSeconds, Long credsExpiry) throws ApiException {
        com.squareup.okhttp.Call call = getDynamicSecretMQAccessValidateBeforeCall(itemName, waitTimeSeconds, credsExpiry, null, null);
        Type localVarReturnType = new TypeToken<DynamicSecretMQAccessReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a signed request to receive messages from a Message Queue of a Dynamic Secret. (asynchronously)
     * 
     * @param itemName The dynamic secret item name (required)
     * @param waitTimeSeconds The duration (in seconds) for which the receive message request to the MQ waits for a message to arrive in the queue before returning. If a message is available, the call returns sooner than WaitTimeSeconds. If no messages are available and the wait time expires, the call returns successfully with an empty list of messages. (optional, default to 20)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDynamicSecretMQAccessAsync(String itemName, Long waitTimeSeconds, Long credsExpiry, final ApiCallback<DynamicSecretMQAccessReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDynamicSecretMQAccessValidateBeforeCall(itemName, waitTimeSeconds, credsExpiry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DynamicSecretMQAccessReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getDynamicSecretProducerCreds
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be encrypt (required)
     * @param consumerProtectionKeyDerivationCreds The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request and the dynamic secret producer that encrypt and push the value received them from the dynamic secret message queue. (required)
     * @param messageReceiptHandle The receipt handle received from the dynamic secret MQ (required)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDynamicSecretProducerCredsCall(String itemName, String dynamicSecretValueId, String consumerProtectionKeyDerivationCreds, String messageReceiptHandle, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/dynamic-secret-producer-cred";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_name", itemName));
        if (dynamicSecretValueId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dynamic_secret_value_id", dynamicSecretValueId));
        if (consumerProtectionKeyDerivationCreds != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("consumer_protection_key_derivation_creds", consumerProtectionKeyDerivationCreds));
        if (messageReceiptHandle != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("message_receipt_handle", messageReceiptHandle));
        if (credsExpiry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("creds_expiry", credsExpiry));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDynamicSecretProducerCredsValidateBeforeCall(String itemName, String dynamicSecretValueId, String consumerProtectionKeyDerivationCreds, String messageReceiptHandle, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling getDynamicSecretProducerCreds(Async)");
        }
        
        // verify the required parameter 'dynamicSecretValueId' is set
        if (dynamicSecretValueId == null) {
            throw new ApiException("Missing the required parameter 'dynamicSecretValueId' when calling getDynamicSecretProducerCreds(Async)");
        }
        
        // verify the required parameter 'consumerProtectionKeyDerivationCreds' is set
        if (consumerProtectionKeyDerivationCreds == null) {
            throw new ApiException("Missing the required parameter 'consumerProtectionKeyDerivationCreds' when calling getDynamicSecretProducerCreds(Async)");
        }
        
        // verify the required parameter 'messageReceiptHandle' is set
        if (messageReceiptHandle == null) {
            throw new ApiException("Missing the required parameter 'messageReceiptHandle' when calling getDynamicSecretProducerCreds(Async)");
        }
        

        com.squareup.okhttp.Call call = getDynamicSecretProducerCredsCall(itemName, dynamicSecretValueId, consumerProtectionKeyDerivationCreds, messageReceiptHandle, credsExpiry, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a dynamic secret producer derivation credentials.
     * This endpoint is used by the dynamic secret producer that listens to encrypt the new dynamic secret value.
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be encrypt (required)
     * @param consumerProtectionKeyDerivationCreds The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request and the dynamic secret producer that encrypt and push the value received them from the dynamic secret message queue. (required)
     * @param messageReceiptHandle The receipt handle received from the dynamic secret MQ (required)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return DynamicSecretProducerCredsReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DynamicSecretProducerCredsReplyObj getDynamicSecretProducerCreds(String itemName, String dynamicSecretValueId, String consumerProtectionKeyDerivationCreds, String messageReceiptHandle, Long credsExpiry) throws ApiException {
        ApiResponse<DynamicSecretProducerCredsReplyObj> resp = getDynamicSecretProducerCredsWithHttpInfo(itemName, dynamicSecretValueId, consumerProtectionKeyDerivationCreds, messageReceiptHandle, credsExpiry);
        return resp.getData();
    }

    /**
     * Get a dynamic secret producer derivation credentials.
     * This endpoint is used by the dynamic secret producer that listens to encrypt the new dynamic secret value.
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be encrypt (required)
     * @param consumerProtectionKeyDerivationCreds The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request and the dynamic secret producer that encrypt and push the value received them from the dynamic secret message queue. (required)
     * @param messageReceiptHandle The receipt handle received from the dynamic secret MQ (required)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return ApiResponse&lt;DynamicSecretProducerCredsReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DynamicSecretProducerCredsReplyObj> getDynamicSecretProducerCredsWithHttpInfo(String itemName, String dynamicSecretValueId, String consumerProtectionKeyDerivationCreds, String messageReceiptHandle, Long credsExpiry) throws ApiException {
        com.squareup.okhttp.Call call = getDynamicSecretProducerCredsValidateBeforeCall(itemName, dynamicSecretValueId, consumerProtectionKeyDerivationCreds, messageReceiptHandle, credsExpiry, null, null);
        Type localVarReturnType = new TypeToken<DynamicSecretProducerCredsReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a dynamic secret producer derivation credentials. (asynchronously)
     * This endpoint is used by the dynamic secret producer that listens to encrypt the new dynamic secret value.
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be encrypt (required)
     * @param consumerProtectionKeyDerivationCreds The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request and the dynamic secret producer that encrypt and push the value received them from the dynamic secret message queue. (required)
     * @param messageReceiptHandle The receipt handle received from the dynamic secret MQ (required)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDynamicSecretProducerCredsAsync(String itemName, String dynamicSecretValueId, String consumerProtectionKeyDerivationCreds, String messageReceiptHandle, Long credsExpiry, final ApiCallback<DynamicSecretProducerCredsReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getDynamicSecretProducerCredsValidateBeforeCall(itemName, dynamicSecretValueId, consumerProtectionKeyDerivationCreds, messageReceiptHandle, credsExpiry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DynamicSecretProducerCredsReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getItem
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version (for item attributes that are unique to each version). If it is empty, the item attributes of the latest version will be returned (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getItemCall(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/item/{item_name}"
            .replaceAll("\\{" + "item_name" + "\\}", apiClient.escapeString(itemName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemVersion != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_version", itemVersion));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getItemValidateBeforeCall(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getItem(Async)");
        }
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling getItem(Async)");
        }
        

        com.squareup.okhttp.Call call = getItemCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get item details.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version (for item attributes that are unique to each version). If it is empty, the item attributes of the latest version will be returned (optional)
     * @return GetItemReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetItemReplyObj getItem(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion) throws ApiException {
        ApiResponse<GetItemReplyObj> resp = getItemWithHttpInfo(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion);
        return resp.getData();
    }

    /**
     * Get item details.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version (for item attributes that are unique to each version). If it is empty, the item attributes of the latest version will be returned (optional)
     * @return ApiResponse&lt;GetItemReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetItemReplyObj> getItemWithHttpInfo(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion) throws ApiException {
        com.squareup.okhttp.Call call = getItemValidateBeforeCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, null, null);
        Type localVarReturnType = new TypeToken<GetItemReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get item details. (asynchronously)
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version (for item attributes that are unique to each version). If it is empty, the item attributes of the latest version will be returned (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getItemAsync(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, final ApiCallback<GetItemReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getItemValidateBeforeCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetItemReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getItemDerivationCreds
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name for derivation (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version. If it is empty, the derivation credentials will be returned for the latest item version (optional)
     * @param restrictedDerivationData In case not empty, the derivation credentials will be restricted only to this derivation data (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getItemDerivationCredsCall(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, String restrictedDerivationData, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/derivation-creds";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_name", itemName));
        if (itemVersion != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_version", itemVersion));
        if (restrictedDerivationData != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("restricted_derivation_data", restrictedDerivationData));
        if (credsExpiry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("creds_expiry", credsExpiry));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getItemDerivationCredsValidateBeforeCall(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, String restrictedDerivationData, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getItemDerivationCreds(Async)");
        }
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling getItemDerivationCreds(Async)");
        }
        

        com.squareup.okhttp.Call call = getItemDerivationCredsCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, restrictedDerivationData, credsExpiry, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get temporary access credentials to KFM instances for item&#39;s fragments derivation.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name for derivation (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version. If it is empty, the derivation credentials will be returned for the latest item version (optional)
     * @param restrictedDerivationData In case not empty, the derivation credentials will be restricted only to this derivation data (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return DerivationCredsReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DerivationCredsReplyObj getItemDerivationCreds(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, String restrictedDerivationData, Long credsExpiry) throws ApiException {
        ApiResponse<DerivationCredsReplyObj> resp = getItemDerivationCredsWithHttpInfo(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, restrictedDerivationData, credsExpiry);
        return resp.getData();
    }

    /**
     * Get temporary access credentials to KFM instances for item&#39;s fragments derivation.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name for derivation (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version. If it is empty, the derivation credentials will be returned for the latest item version (optional)
     * @param restrictedDerivationData In case not empty, the derivation credentials will be restricted only to this derivation data (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return ApiResponse&lt;DerivationCredsReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DerivationCredsReplyObj> getItemDerivationCredsWithHttpInfo(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, String restrictedDerivationData, Long credsExpiry) throws ApiException {
        com.squareup.okhttp.Call call = getItemDerivationCredsValidateBeforeCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, restrictedDerivationData, credsExpiry, null, null);
        Type localVarReturnType = new TypeToken<DerivationCredsReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get temporary access credentials to KFM instances for item&#39;s fragments derivation. (asynchronously)
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name for derivation (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version. If it is empty, the derivation credentials will be returned for the latest item version (optional)
     * @param restrictedDerivationData In case not empty, the derivation credentials will be restricted only to this derivation data (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getItemDerivationCredsAsync(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, String restrictedDerivationData, Long credsExpiry, final ApiCallback<DerivationCredsReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getItemDerivationCredsValidateBeforeCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, restrictedDerivationData, credsExpiry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DerivationCredsReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getRSAKeyDecryptCreds
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name for decrypt operation (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version. If it is empty, the RSA decrypt credentials will be returned for the latest item version (optional)
     * @param restrictedCipher In case not empty, the RSA decrypt credentials will be restricted only to this cipher (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRSAKeyDecryptCredsCall(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, String restrictedCipher, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/rsa-decrypt-creds";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_name", itemName));
        if (itemVersion != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_version", itemVersion));
        if (restrictedCipher != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("restricted_cipher", restrictedCipher));
        if (credsExpiry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("creds_expiry", credsExpiry));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRSAKeyDecryptCredsValidateBeforeCall(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, String restrictedCipher, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getRSAKeyDecryptCreds(Async)");
        }
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling getRSAKeyDecryptCreds(Async)");
        }
        

        com.squareup.okhttp.Call call = getRSAKeyDecryptCredsCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, restrictedCipher, credsExpiry, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get temporary access credentials to KFM instances for RSA key fragments decryption.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name for decrypt operation (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version. If it is empty, the RSA decrypt credentials will be returned for the latest item version (optional)
     * @param restrictedCipher In case not empty, the RSA decrypt credentials will be restricted only to this cipher (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return RSADecryptCredsReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RSADecryptCredsReplyObj getRSAKeyDecryptCreds(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, String restrictedCipher, Long credsExpiry) throws ApiException {
        ApiResponse<RSADecryptCredsReplyObj> resp = getRSAKeyDecryptCredsWithHttpInfo(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, restrictedCipher, credsExpiry);
        return resp.getData();
    }

    /**
     * Get temporary access credentials to KFM instances for RSA key fragments decryption.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name for decrypt operation (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version. If it is empty, the RSA decrypt credentials will be returned for the latest item version (optional)
     * @param restrictedCipher In case not empty, the RSA decrypt credentials will be restricted only to this cipher (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return ApiResponse&lt;RSADecryptCredsReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RSADecryptCredsReplyObj> getRSAKeyDecryptCredsWithHttpInfo(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, String restrictedCipher, Long credsExpiry) throws ApiException {
        com.squareup.okhttp.Call call = getRSAKeyDecryptCredsValidateBeforeCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, restrictedCipher, credsExpiry, null, null);
        Type localVarReturnType = new TypeToken<RSADecryptCredsReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get temporary access credentials to KFM instances for RSA key fragments decryption. (asynchronously)
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The item name for decrypt operation (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The item version. If it is empty, the RSA decrypt credentials will be returned for the latest item version (optional)
     * @param restrictedCipher In case not empty, the RSA decrypt credentials will be restricted only to this cipher (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getRSAKeyDecryptCredsAsync(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, String restrictedCipher, Long credsExpiry, final ApiCallback<RSADecryptCredsReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRSAKeyDecryptCredsValidateBeforeCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, restrictedCipher, credsExpiry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RSADecryptCredsReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getRole
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRoleCall(String akeylessUAMUserCreds, String roleName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/role/{role_name}"
            .replaceAll("\\{" + "role_name" + "\\}", apiClient.escapeString(roleName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRoleValidateBeforeCall(String akeylessUAMUserCreds, String roleName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getRole(Async)");
        }
        
        // verify the required parameter 'roleName' is set
        if (roleName == null) {
            throw new ApiException("Missing the required parameter 'roleName' when calling getRole(Async)");
        }
        

        com.squareup.okhttp.Call call = getRoleCall(akeylessUAMUserCreds, roleName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get role details.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return GetRoleReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetRoleReplyObj getRole(String akeylessUAMUserCreds, String roleName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        ApiResponse<GetRoleReplyObj> resp = getRoleWithHttpInfo(akeylessUAMUserCreds, roleName, akeylessRequestId, akeylessClientId);
        return resp.getData();
    }

    /**
     * Get role details.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;GetRoleReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetRoleReplyObj> getRoleWithHttpInfo(String akeylessUAMUserCreds, String roleName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = getRoleValidateBeforeCall(akeylessUAMUserCreds, roleName, akeylessRequestId, akeylessClientId, null, null);
        Type localVarReturnType = new TypeToken<GetRoleReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get role details. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getRoleAsync(String akeylessUAMUserCreds, String roleName, String akeylessRequestId, String akeylessClientId, final ApiCallback<GetRoleReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRoleValidateBeforeCall(akeylessUAMUserCreds, roleName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetRoleReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getSecretAccessCreds
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The secret item name (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The secret item version. If it is empty, the credentials will be returned for the latest secret item version (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSecretAccessCredsCall(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/secret-access-creds";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_name", itemName));
        if (itemVersion != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_version", itemVersion));
        if (credsExpiry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("creds_expiry", credsExpiry));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSecretAccessCredsValidateBeforeCall(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getSecretAccessCreds(Async)");
        }
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling getSecretAccessCreds(Async)");
        }
        

        com.squareup.okhttp.Call call = getSecretAccessCredsCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, credsExpiry, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Get temporary access credentials to KFM instances for secret protection key derivation and the encrypted secret value.
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The secret item name (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The secret item version. If it is empty, the credentials will be returned for the latest secret item version (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return SecretAccessCredsReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SecretAccessCredsReplyObj getSecretAccessCreds(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, Long credsExpiry) throws ApiException {
        ApiResponse<SecretAccessCredsReplyObj> resp = getSecretAccessCredsWithHttpInfo(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, credsExpiry);
        return resp.getData();
    }

    /**
     * 
     * Get temporary access credentials to KFM instances for secret protection key derivation and the encrypted secret value.
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The secret item name (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The secret item version. If it is empty, the credentials will be returned for the latest secret item version (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return ApiResponse&lt;SecretAccessCredsReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SecretAccessCredsReplyObj> getSecretAccessCredsWithHttpInfo(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, Long credsExpiry) throws ApiException {
        com.squareup.okhttp.Call call = getSecretAccessCredsValidateBeforeCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, credsExpiry, null, null);
        Type localVarReturnType = new TypeToken<SecretAccessCredsReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get temporary access credentials to KFM instances for secret protection key derivation and the encrypted secret value.
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The secret item name (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemVersion The secret item version. If it is empty, the credentials will be returned for the latest secret item version (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSecretAccessCredsAsync(String akeylessUAMUserCreds, String itemName, String akeylessRequestId, String akeylessClientId, Integer itemVersion, Long credsExpiry, final ApiCallback<SecretAccessCredsReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSecretAccessCredsValidateBeforeCall(akeylessUAMUserCreds, itemName, akeylessRequestId, akeylessClientId, itemVersion, credsExpiry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SecretAccessCredsReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getStatus
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getStatusCall(String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/status";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getStatusValidateBeforeCall(String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getStatusCall(akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * 
     * Get UAM server status
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return UAMStatusReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UAMStatusReplyObj getStatus(String akeylessRequestId, String akeylessClientId) throws ApiException {
        ApiResponse<UAMStatusReplyObj> resp = getStatusWithHttpInfo(akeylessRequestId, akeylessClientId);
        return resp.getData();
    }

    /**
     * 
     * Get UAM server status
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;UAMStatusReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UAMStatusReplyObj> getStatusWithHttpInfo(String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = getStatusValidateBeforeCall(akeylessRequestId, akeylessClientId, null, null);
        Type localVarReturnType = new TypeToken<UAMStatusReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get UAM server status
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getStatusAsync(String akeylessRequestId, String akeylessClientId, final ApiCallback<UAMStatusReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getStatusValidateBeforeCall(akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UAMStatusReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getUploadRSAKeyCreds
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The RSA key name. (required)
     * @param itemType The RSA key type Types available are: [KEY_RSA1024, KEY_RSA2048] (required)
     * @param publicValue The value of the RSA public key . (required)
     * @param splitLevel The splitting level represent the number of fragments that the key will be split into. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param certificates The certificates associated with the RSA key. (optional)
     * @param userMetadata User metadata about the key. (optional)
     * @param customerFragmentId The customer fragment ID associated with this item (if any). (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUploadRSAKeyCredsCall(String akeylessUAMUserCreds, String itemName, String itemType, String publicValue, Long splitLevel, String akeylessRequestId, String akeylessClientId, String certificates, String userMetadata, String customerFragmentId, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/upload-rsa-key-creds";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_name", itemName));
        if (itemType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_type", itemType));
        if (publicValue != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("public_value", publicValue));
        if (certificates != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("certificates", certificates));
        if (userMetadata != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("user_metadata", userMetadata));
        if (splitLevel != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("split_level", splitLevel));
        if (customerFragmentId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("customer_fragment_id", customerFragmentId));
        if (credsExpiry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("creds_expiry", credsExpiry));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUploadRSAKeyCredsValidateBeforeCall(String akeylessUAMUserCreds, String itemName, String itemType, String publicValue, Long splitLevel, String akeylessRequestId, String akeylessClientId, String certificates, String userMetadata, String customerFragmentId, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getUploadRSAKeyCreds(Async)");
        }
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling getUploadRSAKeyCreds(Async)");
        }
        
        // verify the required parameter 'itemType' is set
        if (itemType == null) {
            throw new ApiException("Missing the required parameter 'itemType' when calling getUploadRSAKeyCreds(Async)");
        }
        
        // verify the required parameter 'publicValue' is set
        if (publicValue == null) {
            throw new ApiException("Missing the required parameter 'publicValue' when calling getUploadRSAKeyCreds(Async)");
        }
        
        // verify the required parameter 'splitLevel' is set
        if (splitLevel == null) {
            throw new ApiException("Missing the required parameter 'splitLevel' when calling getUploadRSAKeyCreds(Async)");
        }
        

        com.squareup.okhttp.Call call = getUploadRSAKeyCredsCall(akeylessUAMUserCreds, itemName, itemType, publicValue, splitLevel, akeylessRequestId, akeylessClientId, certificates, userMetadata, customerFragmentId, credsExpiry, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get temporary access credentials to upload RSA private key fragments into KFMs instances.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The RSA key name. (required)
     * @param itemType The RSA key type Types available are: [KEY_RSA1024, KEY_RSA2048] (required)
     * @param publicValue The value of the RSA public key . (required)
     * @param splitLevel The splitting level represent the number of fragments that the key will be split into. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param certificates The certificates associated with the RSA key. (optional)
     * @param userMetadata User metadata about the key. (optional)
     * @param customerFragmentId The customer fragment ID associated with this item (if any). (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return UploadRSAKeyCredsReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UploadRSAKeyCredsReplyObj getUploadRSAKeyCreds(String akeylessUAMUserCreds, String itemName, String itemType, String publicValue, Long splitLevel, String akeylessRequestId, String akeylessClientId, String certificates, String userMetadata, String customerFragmentId, Long credsExpiry) throws ApiException {
        ApiResponse<UploadRSAKeyCredsReplyObj> resp = getUploadRSAKeyCredsWithHttpInfo(akeylessUAMUserCreds, itemName, itemType, publicValue, splitLevel, akeylessRequestId, akeylessClientId, certificates, userMetadata, customerFragmentId, credsExpiry);
        return resp.getData();
    }

    /**
     * Get temporary access credentials to upload RSA private key fragments into KFMs instances.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The RSA key name. (required)
     * @param itemType The RSA key type Types available are: [KEY_RSA1024, KEY_RSA2048] (required)
     * @param publicValue The value of the RSA public key . (required)
     * @param splitLevel The splitting level represent the number of fragments that the key will be split into. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param certificates The certificates associated with the RSA key. (optional)
     * @param userMetadata User metadata about the key. (optional)
     * @param customerFragmentId The customer fragment ID associated with this item (if any). (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return ApiResponse&lt;UploadRSAKeyCredsReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UploadRSAKeyCredsReplyObj> getUploadRSAKeyCredsWithHttpInfo(String akeylessUAMUserCreds, String itemName, String itemType, String publicValue, Long splitLevel, String akeylessRequestId, String akeylessClientId, String certificates, String userMetadata, String customerFragmentId, Long credsExpiry) throws ApiException {
        com.squareup.okhttp.Call call = getUploadRSAKeyCredsValidateBeforeCall(akeylessUAMUserCreds, itemName, itemType, publicValue, splitLevel, akeylessRequestId, akeylessClientId, certificates, userMetadata, customerFragmentId, credsExpiry, null, null);
        Type localVarReturnType = new TypeToken<UploadRSAKeyCredsReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get temporary access credentials to upload RSA private key fragments into KFMs instances. (asynchronously)
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param itemName The RSA key name. (required)
     * @param itemType The RSA key type Types available are: [KEY_RSA1024, KEY_RSA2048] (required)
     * @param publicValue The value of the RSA public key . (required)
     * @param splitLevel The splitting level represent the number of fragments that the key will be split into. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param certificates The certificates associated with the RSA key. (optional)
     * @param userMetadata User metadata about the key. (optional)
     * @param customerFragmentId The customer fragment ID associated with this item (if any). (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getUploadRSAKeyCredsAsync(String akeylessUAMUserCreds, String itemName, String itemType, String publicValue, Long splitLevel, String akeylessRequestId, String akeylessClientId, String certificates, String userMetadata, String customerFragmentId, Long credsExpiry, final ApiCallback<UploadRSAKeyCredsReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getUploadRSAKeyCredsValidateBeforeCall(akeylessUAMUserCreds, itemName, itemType, publicValue, splitLevel, akeylessRequestId, akeylessClientId, certificates, userMetadata, customerFragmentId, credsExpiry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UploadRSAKeyCredsReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getUploadSecretCreds
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param secretName The secret name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param protectionKeyName The name of the key that will be used to encrypt the secret. If not provided, the account default secret key will be used. (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUploadSecretCredsCall(String akeylessUAMUserCreds, String secretName, String akeylessRequestId, String akeylessClientId, String protectionKeyName, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/upload-secret-creds";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (secretName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("secret_name", secretName));
        if (protectionKeyName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("protection_key_name", protectionKeyName));
        if (credsExpiry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("creds_expiry", credsExpiry));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUploadSecretCredsValidateBeforeCall(String akeylessUAMUserCreds, String secretName, String akeylessRequestId, String akeylessClientId, String protectionKeyName, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getUploadSecretCreds(Async)");
        }
        
        // verify the required parameter 'secretName' is set
        if (secretName == null) {
            throw new ApiException("Missing the required parameter 'secretName' when calling getUploadSecretCreds(Async)");
        }
        

        com.squareup.okhttp.Call call = getUploadSecretCredsCall(akeylessUAMUserCreds, secretName, akeylessRequestId, akeylessClientId, protectionKeyName, credsExpiry, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get temporary access credentials to KFM instances to produce the derived protection key of the secret.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param secretName The secret name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param protectionKeyName The name of the key that will be used to encrypt the secret. If not provided, the account default secret key will be used. (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return DerivationCredsReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DerivationCredsReplyObj getUploadSecretCreds(String akeylessUAMUserCreds, String secretName, String akeylessRequestId, String akeylessClientId, String protectionKeyName, Long credsExpiry) throws ApiException {
        ApiResponse<DerivationCredsReplyObj> resp = getUploadSecretCredsWithHttpInfo(akeylessUAMUserCreds, secretName, akeylessRequestId, akeylessClientId, protectionKeyName, credsExpiry);
        return resp.getData();
    }

    /**
     * Get temporary access credentials to KFM instances to produce the derived protection key of the secret.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param secretName The secret name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param protectionKeyName The name of the key that will be used to encrypt the secret. If not provided, the account default secret key will be used. (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return ApiResponse&lt;DerivationCredsReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DerivationCredsReplyObj> getUploadSecretCredsWithHttpInfo(String akeylessUAMUserCreds, String secretName, String akeylessRequestId, String akeylessClientId, String protectionKeyName, Long credsExpiry) throws ApiException {
        com.squareup.okhttp.Call call = getUploadSecretCredsValidateBeforeCall(akeylessUAMUserCreds, secretName, akeylessRequestId, akeylessClientId, protectionKeyName, credsExpiry, null, null);
        Type localVarReturnType = new TypeToken<DerivationCredsReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get temporary access credentials to KFM instances to produce the derived protection key of the secret. (asynchronously)
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param secretName The secret name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param protectionKeyName The name of the key that will be used to encrypt the secret. If not provided, the account default secret key will be used. (optional)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getUploadSecretCredsAsync(String akeylessUAMUserCreds, String secretName, String akeylessRequestId, String akeylessClientId, String protectionKeyName, Long credsExpiry, final ApiCallback<DerivationCredsReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getUploadSecretCredsValidateBeforeCall(akeylessUAMUserCreds, secretName, akeylessRequestId, akeylessClientId, protectionKeyName, credsExpiry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DerivationCredsReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getUser
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUserCall(String akeylessUAMUserCreds, String userName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/user/{user_name}"
            .replaceAll("\\{" + "user_name" + "\\}", apiClient.escapeString(userName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUserValidateBeforeCall(String akeylessUAMUserCreds, String userName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getUser(Async)");
        }
        
        // verify the required parameter 'userName' is set
        if (userName == null) {
            throw new ApiException("Missing the required parameter 'userName' when calling getUser(Async)");
        }
        

        com.squareup.okhttp.Call call = getUserCall(akeylessUAMUserCreds, userName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get user details.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return GetUserReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetUserReplyObj getUser(String akeylessUAMUserCreds, String userName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        ApiResponse<GetUserReplyObj> resp = getUserWithHttpInfo(akeylessUAMUserCreds, userName, akeylessRequestId, akeylessClientId);
        return resp.getData();
    }

    /**
     * Get user details.
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;GetUserReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetUserReplyObj> getUserWithHttpInfo(String akeylessUAMUserCreds, String userName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = getUserValidateBeforeCall(akeylessUAMUserCreds, userName, akeylessRequestId, akeylessClientId, null, null);
        Type localVarReturnType = new TypeToken<GetUserReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get user details. (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getUserAsync(String akeylessUAMUserCreds, String userName, String akeylessRequestId, String akeylessClientId, final ApiCallback<GetUserReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getUserValidateBeforeCall(akeylessUAMUserCreds, userName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetUserReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getUserItems
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemTypes The item types list of the requested items . In case it is empty, all types of items will be returned. The format of the item types list is a comma-separated list of a valid item types. Valid opinions are - \&quot;AES128GCM,AES256GCM,AES128SIV,AES256SIV,RSA1024,RSA2048,USER_SECRET\&quot; (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUserItemsCall(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, String itemTypes, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/items";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemTypes != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_types", itemTypes));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUserItemsValidateBeforeCall(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, String itemTypes, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling getUserItems(Async)");
        }
        

        com.squareup.okhttp.Call call = getUserItemsCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, itemTypes, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get All the items associated with the user.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemTypes The item types list of the requested items . In case it is empty, all types of items will be returned. The format of the item types list is a comma-separated list of a valid item types. Valid opinions are - \&quot;AES128GCM,AES256GCM,AES128SIV,AES256SIV,RSA1024,RSA2048,USER_SECRET\&quot; (optional)
     * @return GetUserItemsReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetUserItemsReplyObj getUserItems(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, String itemTypes) throws ApiException {
        ApiResponse<GetUserItemsReplyObj> resp = getUserItemsWithHttpInfo(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, itemTypes);
        return resp.getData();
    }

    /**
     * Get All the items associated with the user.
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemTypes The item types list of the requested items . In case it is empty, all types of items will be returned. The format of the item types list is a comma-separated list of a valid item types. Valid opinions are - \&quot;AES128GCM,AES256GCM,AES128SIV,AES256SIV,RSA1024,RSA2048,USER_SECRET\&quot; (optional)
     * @return ApiResponse&lt;GetUserItemsReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetUserItemsReplyObj> getUserItemsWithHttpInfo(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, String itemTypes) throws ApiException {
        com.squareup.okhttp.Call call = getUserItemsValidateBeforeCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, itemTypes, null, null);
        Type localVarReturnType = new TypeToken<GetUserItemsReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get All the items associated with the user. (asynchronously)
     * 
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param itemTypes The item types list of the requested items . In case it is empty, all types of items will be returned. The format of the item types list is a comma-separated list of a valid item types. Valid opinions are - \&quot;AES128GCM,AES256GCM,AES128SIV,AES256SIV,RSA1024,RSA2048,USER_SECRET\&quot; (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getUserItemsAsync(String akeylessUAMUserCreds, String akeylessRequestId, String akeylessClientId, String itemTypes, final ApiCallback<GetUserItemsReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getUserItemsValidateBeforeCall(akeylessUAMUserCreds, akeylessRequestId, akeylessClientId, itemTypes, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetUserItemsReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for prepareDynamicSecretValue
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValPreparationData An attached data by the client about the dynamic secret value preparation request (required)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call prepareDynamicSecretValueCall(String itemName, String dynamicSecretValPreparationData, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/prepare-dynamic-secret-value";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_name", itemName));
        if (dynamicSecretValPreparationData != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dynamic_secret_val_preparation_data", dynamicSecretValPreparationData));
        if (credsExpiry != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("creds_expiry", credsExpiry));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call prepareDynamicSecretValueValidateBeforeCall(String itemName, String dynamicSecretValPreparationData, Long credsExpiry, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling prepareDynamicSecretValue(Async)");
        }
        
        // verify the required parameter 'dynamicSecretValPreparationData' is set
        if (dynamicSecretValPreparationData == null) {
            throw new ApiException("Missing the required parameter 'dynamicSecretValPreparationData' when calling prepareDynamicSecretValue(Async)");
        }
        

        com.squareup.okhttp.Call call = prepareDynamicSecretValueCall(itemName, dynamicSecretValPreparationData, credsExpiry, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the new dynamic secret ID to be pull and derivation credentials to decrypt the new dynamic secret value.
     * After the prepareDynamicSecretValue request, the consumer must perform a pullDynamicSecretValue request in order to receive the new value (wait about half a second between the prepareDynamicSecretValue request and the first pullDynamicSecretValue request, since it takes time for the dynamic secret producer to receive the request for a new dynamic secret value and to push a new one).
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValPreparationData An attached data by the client about the dynamic secret value preparation request (required)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return PrepareDynamicSecretValueReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PrepareDynamicSecretValueReplyObj prepareDynamicSecretValue(String itemName, String dynamicSecretValPreparationData, Long credsExpiry) throws ApiException {
        ApiResponse<PrepareDynamicSecretValueReplyObj> resp = prepareDynamicSecretValueWithHttpInfo(itemName, dynamicSecretValPreparationData, credsExpiry);
        return resp.getData();
    }

    /**
     * Get the new dynamic secret ID to be pull and derivation credentials to decrypt the new dynamic secret value.
     * After the prepareDynamicSecretValue request, the consumer must perform a pullDynamicSecretValue request in order to receive the new value (wait about half a second between the prepareDynamicSecretValue request and the first pullDynamicSecretValue request, since it takes time for the dynamic secret producer to receive the request for a new dynamic secret value and to push a new one).
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValPreparationData An attached data by the client about the dynamic secret value preparation request (required)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @return ApiResponse&lt;PrepareDynamicSecretValueReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PrepareDynamicSecretValueReplyObj> prepareDynamicSecretValueWithHttpInfo(String itemName, String dynamicSecretValPreparationData, Long credsExpiry) throws ApiException {
        com.squareup.okhttp.Call call = prepareDynamicSecretValueValidateBeforeCall(itemName, dynamicSecretValPreparationData, credsExpiry, null, null);
        Type localVarReturnType = new TypeToken<PrepareDynamicSecretValueReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the new dynamic secret ID to be pull and derivation credentials to decrypt the new dynamic secret value. (asynchronously)
     * After the prepareDynamicSecretValue request, the consumer must perform a pullDynamicSecretValue request in order to receive the new value (wait about half a second between the prepareDynamicSecretValue request and the first pullDynamicSecretValue request, since it takes time for the dynamic secret producer to receive the request for a new dynamic secret value and to push a new one).
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValPreparationData An attached data by the client about the dynamic secret value preparation request (required)
     * @param credsExpiry The requested expiration time of the temporary credentials in minutes. (optional, default to 60)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call prepareDynamicSecretValueAsync(String itemName, String dynamicSecretValPreparationData, Long credsExpiry, final ApiCallback<PrepareDynamicSecretValueReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = prepareDynamicSecretValueValidateBeforeCall(itemName, dynamicSecretValPreparationData, credsExpiry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PrepareDynamicSecretValueReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for pullDynamicSecretValue
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be pull (required)
     * @param consumerProtectionKeyDerivationCreds The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call pullDynamicSecretValueCall(String itemName, String dynamicSecretValueId, String consumerProtectionKeyDerivationCreds, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/pull-dynamic-secret-value";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_name", itemName));
        if (dynamicSecretValueId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dynamic_secret_value_id", dynamicSecretValueId));
        if (consumerProtectionKeyDerivationCreds != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("consumer_protection_key_derivation_creds", consumerProtectionKeyDerivationCreds));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call pullDynamicSecretValueValidateBeforeCall(String itemName, String dynamicSecretValueId, String consumerProtectionKeyDerivationCreds, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling pullDynamicSecretValue(Async)");
        }
        
        // verify the required parameter 'dynamicSecretValueId' is set
        if (dynamicSecretValueId == null) {
            throw new ApiException("Missing the required parameter 'dynamicSecretValueId' when calling pullDynamicSecretValue(Async)");
        }
        
        // verify the required parameter 'consumerProtectionKeyDerivationCreds' is set
        if (consumerProtectionKeyDerivationCreds == null) {
            throw new ApiException("Missing the required parameter 'consumerProtectionKeyDerivationCreds' when calling pullDynamicSecretValue(Async)");
        }
        

        com.squareup.okhttp.Call call = pullDynamicSecretValueCall(itemName, dynamicSecretValueId, consumerProtectionKeyDerivationCreds, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Pull a new dynamic secret value on demand.
     * This endpoint is used by the consumer after call the prepareDynamicSecretValue request. There may be a situation where the request to pull the dynamic secret value comes before the producer has push the new value. so that the consumer must make the pull request several times until the pushDynamicSecretValue process is completed by the producer (wait about half a second between each pull request).
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be pull (required)
     * @param consumerProtectionKeyDerivationCreds The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request. (required)
     * @return PullDynamicSecretValueReplyObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PullDynamicSecretValueReplyObj pullDynamicSecretValue(String itemName, String dynamicSecretValueId, String consumerProtectionKeyDerivationCreds) throws ApiException {
        ApiResponse<PullDynamicSecretValueReplyObj> resp = pullDynamicSecretValueWithHttpInfo(itemName, dynamicSecretValueId, consumerProtectionKeyDerivationCreds);
        return resp.getData();
    }

    /**
     * Pull a new dynamic secret value on demand.
     * This endpoint is used by the consumer after call the prepareDynamicSecretValue request. There may be a situation where the request to pull the dynamic secret value comes before the producer has push the new value. so that the consumer must make the pull request several times until the pushDynamicSecretValue process is completed by the producer (wait about half a second between each pull request).
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be pull (required)
     * @param consumerProtectionKeyDerivationCreds The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request. (required)
     * @return ApiResponse&lt;PullDynamicSecretValueReplyObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PullDynamicSecretValueReplyObj> pullDynamicSecretValueWithHttpInfo(String itemName, String dynamicSecretValueId, String consumerProtectionKeyDerivationCreds) throws ApiException {
        com.squareup.okhttp.Call call = pullDynamicSecretValueValidateBeforeCall(itemName, dynamicSecretValueId, consumerProtectionKeyDerivationCreds, null, null);
        Type localVarReturnType = new TypeToken<PullDynamicSecretValueReplyObj>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Pull a new dynamic secret value on demand. (asynchronously)
     * This endpoint is used by the consumer after call the prepareDynamicSecretValue request. There may be a situation where the request to pull the dynamic secret value comes before the producer has push the new value. so that the consumer must make the pull request several times until the pushDynamicSecretValue process is completed by the producer (wait about half a second between each pull request).
     * @param itemName The dynamic secret item name (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be pull (required)
     * @param consumerProtectionKeyDerivationCreds The credentials issued when preparing for the new value. The consumer that pull the dynamic secret value received them on the prepareDynamicSecretValue request. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call pullDynamicSecretValueAsync(String itemName, String dynamicSecretValueId, String consumerProtectionKeyDerivationCreds, final ApiCallback<PullDynamicSecretValueReplyObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = pullDynamicSecretValueValidateBeforeCall(itemName, dynamicSecretValueId, consumerProtectionKeyDerivationCreds, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PullDynamicSecretValueReplyObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for pushDynamicSecretValue
     * @param itemName The dynamic secret item name (required)
     * @param messageReceiptHandle The receipt handle received from the dynamic secret MQ (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be pull (required)
     * @param dynamicSecretValue The dynamic secret value (required)
     * @param producerProtectionKeyDerivationCreds for the dynamic secret value producer credentials. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call pushDynamicSecretValueCall(String itemName, String messageReceiptHandle, String dynamicSecretValueId, String dynamicSecretValue, String producerProtectionKeyDerivationCreds, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/push-dynamic-secret-value";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (itemName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_name", itemName));
        if (messageReceiptHandle != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("message_receipt_handle", messageReceiptHandle));
        if (dynamicSecretValueId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dynamic_secret_value_id", dynamicSecretValueId));
        if (dynamicSecretValue != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dynamic_secret_value", dynamicSecretValue));
        if (producerProtectionKeyDerivationCreds != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("producer_protection_key_derivation_creds", producerProtectionKeyDerivationCreds));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call pushDynamicSecretValueValidateBeforeCall(String itemName, String messageReceiptHandle, String dynamicSecretValueId, String dynamicSecretValue, String producerProtectionKeyDerivationCreds, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling pushDynamicSecretValue(Async)");
        }
        
        // verify the required parameter 'messageReceiptHandle' is set
        if (messageReceiptHandle == null) {
            throw new ApiException("Missing the required parameter 'messageReceiptHandle' when calling pushDynamicSecretValue(Async)");
        }
        
        // verify the required parameter 'dynamicSecretValueId' is set
        if (dynamicSecretValueId == null) {
            throw new ApiException("Missing the required parameter 'dynamicSecretValueId' when calling pushDynamicSecretValue(Async)");
        }
        
        // verify the required parameter 'dynamicSecretValue' is set
        if (dynamicSecretValue == null) {
            throw new ApiException("Missing the required parameter 'dynamicSecretValue' when calling pushDynamicSecretValue(Async)");
        }
        
        // verify the required parameter 'producerProtectionKeyDerivationCreds' is set
        if (producerProtectionKeyDerivationCreds == null) {
            throw new ApiException("Missing the required parameter 'producerProtectionKeyDerivationCreds' when calling pushDynamicSecretValue(Async)");
        }
        

        com.squareup.okhttp.Call call = pushDynamicSecretValueCall(itemName, messageReceiptHandle, dynamicSecretValueId, dynamicSecretValue, producerProtectionKeyDerivationCreds, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Push a new dynamic secret value on demand.
     * This endpoint is used by the dynamic secret producer that listens to a dynamic secret message queue and create temporary value on demand and pushes it here to be stored for a few seconds until it is pulled by the client.
     * @param itemName The dynamic secret item name (required)
     * @param messageReceiptHandle The receipt handle received from the dynamic secret MQ (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be pull (required)
     * @param dynamicSecretValue The dynamic secret value (required)
     * @param producerProtectionKeyDerivationCreds for the dynamic secret value producer credentials. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void pushDynamicSecretValue(String itemName, String messageReceiptHandle, String dynamicSecretValueId, String dynamicSecretValue, String producerProtectionKeyDerivationCreds) throws ApiException {
        pushDynamicSecretValueWithHttpInfo(itemName, messageReceiptHandle, dynamicSecretValueId, dynamicSecretValue, producerProtectionKeyDerivationCreds);
    }

    /**
     * Push a new dynamic secret value on demand.
     * This endpoint is used by the dynamic secret producer that listens to a dynamic secret message queue and create temporary value on demand and pushes it here to be stored for a few seconds until it is pulled by the client.
     * @param itemName The dynamic secret item name (required)
     * @param messageReceiptHandle The receipt handle received from the dynamic secret MQ (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be pull (required)
     * @param dynamicSecretValue The dynamic secret value (required)
     * @param producerProtectionKeyDerivationCreds for the dynamic secret value producer credentials. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> pushDynamicSecretValueWithHttpInfo(String itemName, String messageReceiptHandle, String dynamicSecretValueId, String dynamicSecretValue, String producerProtectionKeyDerivationCreds) throws ApiException {
        com.squareup.okhttp.Call call = pushDynamicSecretValueValidateBeforeCall(itemName, messageReceiptHandle, dynamicSecretValueId, dynamicSecretValue, producerProtectionKeyDerivationCreds, null, null);
        return apiClient.execute(call);
    }

    /**
     * Push a new dynamic secret value on demand. (asynchronously)
     * This endpoint is used by the dynamic secret producer that listens to a dynamic secret message queue and create temporary value on demand and pushes it here to be stored for a few seconds until it is pulled by the client.
     * @param itemName The dynamic secret item name (required)
     * @param messageReceiptHandle The receipt handle received from the dynamic secret MQ (required)
     * @param dynamicSecretValueId The ID of the new dynamic secret value to be pull (required)
     * @param dynamicSecretValue The dynamic secret value (required)
     * @param producerProtectionKeyDerivationCreds for the dynamic secret value producer credentials. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call pushDynamicSecretValueAsync(String itemName, String messageReceiptHandle, String dynamicSecretValueId, String dynamicSecretValue, String producerProtectionKeyDerivationCreds, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = pushDynamicSecretValueValidateBeforeCall(itemName, messageReceiptHandle, dynamicSecretValueId, dynamicSecretValue, producerProtectionKeyDerivationCreds, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for updateItem
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newItemName The new item name that will replace the existing one (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param userMetadata User metadata about the item. (optional)
     * @param itemVersion The item version to be updated. this parameter relevant only when updating a version-dependent attribute of the item (for example a secret encrypted value in case of secret item).  If it is empty, the item attributes of the latest version will be updated. (optional)
     * @param uploadSecretCreds The credentials to upload a secret. this parameter relevant only when updating a secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret. (optional)
     * @param secretEncVal The encrypted secret value. this parameter relevant only when updating a secret. This parameter should contain the encrypted secret that is encrypted using the protection key. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateItemCall(String akeylessUAMUserCreds, String newItemName, String itemName, String akeylessRequestId, String akeylessClientId, String userMetadata, Integer itemVersion, String uploadSecretCreds, String secretEncVal, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/item/{item_name}"
            .replaceAll("\\{" + "item_name" + "\\}", apiClient.escapeString(itemName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (newItemName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("new_item_name", newItemName));
        if (userMetadata != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("user_metadata", userMetadata));
        if (itemVersion != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("item_version", itemVersion));
        if (uploadSecretCreds != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("upload_secret_creds", uploadSecretCreds));
        if (secretEncVal != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("secret_enc_val", secretEncVal));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateItemValidateBeforeCall(String akeylessUAMUserCreds, String newItemName, String itemName, String akeylessRequestId, String akeylessClientId, String userMetadata, Integer itemVersion, String uploadSecretCreds, String secretEncVal, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling updateItem(Async)");
        }
        
        // verify the required parameter 'newItemName' is set
        if (newItemName == null) {
            throw new ApiException("Missing the required parameter 'newItemName' when calling updateItem(Async)");
        }
        
        // verify the required parameter 'itemName' is set
        if (itemName == null) {
            throw new ApiException("Missing the required parameter 'itemName' when calling updateItem(Async)");
        }
        

        com.squareup.okhttp.Call call = updateItemCall(akeylessUAMUserCreds, newItemName, itemName, akeylessRequestId, akeylessClientId, userMetadata, itemVersion, uploadSecretCreds, secretEncVal, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Updating an existing item in the account
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newItemName The new item name that will replace the existing one (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param userMetadata User metadata about the item. (optional)
     * @param itemVersion The item version to be updated. this parameter relevant only when updating a version-dependent attribute of the item (for example a secret encrypted value in case of secret item).  If it is empty, the item attributes of the latest version will be updated. (optional)
     * @param uploadSecretCreds The credentials to upload a secret. this parameter relevant only when updating a secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret. (optional)
     * @param secretEncVal The encrypted secret value. this parameter relevant only when updating a secret. This parameter should contain the encrypted secret that is encrypted using the protection key. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void updateItem(String akeylessUAMUserCreds, String newItemName, String itemName, String akeylessRequestId, String akeylessClientId, String userMetadata, Integer itemVersion, String uploadSecretCreds, String secretEncVal) throws ApiException {
        updateItemWithHttpInfo(akeylessUAMUserCreds, newItemName, itemName, akeylessRequestId, akeylessClientId, userMetadata, itemVersion, uploadSecretCreds, secretEncVal);
    }

    /**
     * Updating an existing item in the account
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newItemName The new item name that will replace the existing one (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param userMetadata User metadata about the item. (optional)
     * @param itemVersion The item version to be updated. this parameter relevant only when updating a version-dependent attribute of the item (for example a secret encrypted value in case of secret item).  If it is empty, the item attributes of the latest version will be updated. (optional)
     * @param uploadSecretCreds The credentials to upload a secret. this parameter relevant only when updating a secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret. (optional)
     * @param secretEncVal The encrypted secret value. this parameter relevant only when updating a secret. This parameter should contain the encrypted secret that is encrypted using the protection key. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> updateItemWithHttpInfo(String akeylessUAMUserCreds, String newItemName, String itemName, String akeylessRequestId, String akeylessClientId, String userMetadata, Integer itemVersion, String uploadSecretCreds, String secretEncVal) throws ApiException {
        com.squareup.okhttp.Call call = updateItemValidateBeforeCall(akeylessUAMUserCreds, newItemName, itemName, akeylessRequestId, akeylessClientId, userMetadata, itemVersion, uploadSecretCreds, secretEncVal, null, null);
        return apiClient.execute(call);
    }

    /**
     * Updating an existing item in the account (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newItemName The new item name that will replace the existing one (required)
     * @param itemName Item name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param userMetadata User metadata about the item. (optional)
     * @param itemVersion The item version to be updated. this parameter relevant only when updating a version-dependent attribute of the item (for example a secret encrypted value in case of secret item).  If it is empty, the item attributes of the latest version will be updated. (optional)
     * @param uploadSecretCreds The credentials to upload a secret. this parameter relevant only when updating a secret. this parameter will be used to extract the protection key and the derivation data that used to encrypt the secret. (optional)
     * @param secretEncVal The encrypted secret value. this parameter relevant only when updating a secret. This parameter should contain the encrypted secret that is encrypted using the protection key. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateItemAsync(String akeylessUAMUserCreds, String newItemName, String itemName, String akeylessRequestId, String akeylessClientId, String userMetadata, Integer itemVersion, String uploadSecretCreds, String secretEncVal, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateItemValidateBeforeCall(akeylessUAMUserCreds, newItemName, itemName, akeylessRequestId, akeylessClientId, userMetadata, itemVersion, uploadSecretCreds, secretEncVal, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for updateRole
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newRoleName The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param roleAction The role action. (optional)
     * @param comment Comments (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateRoleCall(String akeylessUAMUserCreds, String newRoleName, String roleName, String akeylessRequestId, String akeylessClientId, String roleAction, String comment, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/role/{role_name}"
            .replaceAll("\\{" + "role_name" + "\\}", apiClient.escapeString(roleName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (newRoleName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("new_role_name", newRoleName));
        if (roleAction != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("role_action", roleAction));
        if (comment != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("comment", comment));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateRoleValidateBeforeCall(String akeylessUAMUserCreds, String newRoleName, String roleName, String akeylessRequestId, String akeylessClientId, String roleAction, String comment, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling updateRole(Async)");
        }
        
        // verify the required parameter 'newRoleName' is set
        if (newRoleName == null) {
            throw new ApiException("Missing the required parameter 'newRoleName' when calling updateRole(Async)");
        }
        
        // verify the required parameter 'roleName' is set
        if (roleName == null) {
            throw new ApiException("Missing the required parameter 'roleName' when calling updateRole(Async)");
        }
        

        com.squareup.okhttp.Call call = updateRoleCall(akeylessUAMUserCreds, newRoleName, roleName, akeylessRequestId, akeylessClientId, roleAction, comment, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Updating an existing role in the account
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newRoleName The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param roleAction The role action. (optional)
     * @param comment Comments (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void updateRole(String akeylessUAMUserCreds, String newRoleName, String roleName, String akeylessRequestId, String akeylessClientId, String roleAction, String comment) throws ApiException {
        updateRoleWithHttpInfo(akeylessUAMUserCreds, newRoleName, roleName, akeylessRequestId, akeylessClientId, roleAction, comment);
    }

    /**
     * Updating an existing role in the account
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newRoleName The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param roleAction The role action. (optional)
     * @param comment Comments (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> updateRoleWithHttpInfo(String akeylessUAMUserCreds, String newRoleName, String roleName, String akeylessRequestId, String akeylessClientId, String roleAction, String comment) throws ApiException {
        com.squareup.okhttp.Call call = updateRoleValidateBeforeCall(akeylessUAMUserCreds, newRoleName, roleName, akeylessRequestId, akeylessClientId, roleAction, comment, null, null);
        return apiClient.execute(call);
    }

    /**
     * Updating an existing role in the account (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param newRoleName The role name to be created (in case of update role, this is the new role name that will replace the existing one) (required)
     * @param roleName Role name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param roleAction The role action. (optional)
     * @param comment Comments (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateRoleAsync(String akeylessUAMUserCreds, String newRoleName, String roleName, String akeylessRequestId, String akeylessClientId, String roleAction, String comment, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateRoleValidateBeforeCall(akeylessUAMUserCreds, newRoleName, roleName, akeylessRequestId, akeylessClientId, roleAction, comment, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for updateUser
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessSetUserAccessCreds Temporary credentials for accessing the endpoint (required)
     * @param newUserName The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateUserCall(String akeylessUAMUserCreds, String akeylessSetUserAccessCreds, String newUserName, String userName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/user/{user_name}"
            .replaceAll("\\{" + "user_name" + "\\}", apiClient.escapeString(userName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (newUserName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("new_user_name", newUserName));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (akeylessRequestId != null)
        localVarHeaderParams.put("AkeylessRequestId", apiClient.parameterToString(akeylessRequestId));
        if (akeylessClientId != null)
        localVarHeaderParams.put("AkeylessClientId", apiClient.parameterToString(akeylessClientId));
        if (akeylessUAMUserCreds != null)
        localVarHeaderParams.put("AkeylessUAM-UserCreds", apiClient.parameterToString(akeylessUAMUserCreds));
        if (akeylessSetUserAccessCreds != null)
        localVarHeaderParams.put("Akeyless-SetUserAccessCreds", apiClient.parameterToString(akeylessSetUserAccessCreds));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateUserValidateBeforeCall(String akeylessUAMUserCreds, String akeylessSetUserAccessCreds, String newUserName, String userName, String akeylessRequestId, String akeylessClientId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'akeylessUAMUserCreds' is set
        if (akeylessUAMUserCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessUAMUserCreds' when calling updateUser(Async)");
        }
        
        // verify the required parameter 'akeylessSetUserAccessCreds' is set
        if (akeylessSetUserAccessCreds == null) {
            throw new ApiException("Missing the required parameter 'akeylessSetUserAccessCreds' when calling updateUser(Async)");
        }
        
        // verify the required parameter 'newUserName' is set
        if (newUserName == null) {
            throw new ApiException("Missing the required parameter 'newUserName' when calling updateUser(Async)");
        }
        
        // verify the required parameter 'userName' is set
        if (userName == null) {
            throw new ApiException("Missing the required parameter 'userName' when calling updateUser(Async)");
        }
        

        com.squareup.okhttp.Call call = updateUserCall(akeylessUAMUserCreds, akeylessSetUserAccessCreds, newUserName, userName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Updating an existing user in the account
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessSetUserAccessCreds Temporary credentials for accessing the endpoint (required)
     * @param newUserName The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void updateUser(String akeylessUAMUserCreds, String akeylessSetUserAccessCreds, String newUserName, String userName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        updateUserWithHttpInfo(akeylessUAMUserCreds, akeylessSetUserAccessCreds, newUserName, userName, akeylessRequestId, akeylessClientId);
    }

    /**
     * Updating an existing user in the account
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessSetUserAccessCreds Temporary credentials for accessing the endpoint (required)
     * @param newUserName The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> updateUserWithHttpInfo(String akeylessUAMUserCreds, String akeylessSetUserAccessCreds, String newUserName, String userName, String akeylessRequestId, String akeylessClientId) throws ApiException {
        com.squareup.okhttp.Call call = updateUserValidateBeforeCall(akeylessUAMUserCreds, akeylessSetUserAccessCreds, newUserName, userName, akeylessRequestId, akeylessClientId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Updating an existing user in the account (asynchronously)
     * This endpoint is accessible only by the account admin user
     * @param akeylessUAMUserCreds Temporary credentials for accessing the endpoint (required)
     * @param akeylessSetUserAccessCreds Temporary credentials for accessing the endpoint (required)
     * @param newUserName The user name to be created (in case of update user, this is the new username that will replace the existing one) (required)
     * @param userName User name. (required)
     * @param akeylessRequestId Request Id for logging (optional)
     * @param akeylessClientId Client Id for logging (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateUserAsync(String akeylessUAMUserCreds, String akeylessSetUserAccessCreds, String newUserName, String userName, String akeylessRequestId, String akeylessClientId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateUserValidateBeforeCall(akeylessUAMUserCreds, akeylessSetUserAccessCreds, newUserName, userName, akeylessRequestId, akeylessClientId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
