/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.akeyless.uam.swagger.model.AccessRules;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * AccessParams
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class AccessParams {
  @SerializedName("access_rules_type")
  private String accessRulesType = null;

  @SerializedName("account_id")
  private String accountId = null;

  @SerializedName("attaches")
  private String attaches = null;

  @SerializedName("comment")
  private String comment = null;

  @SerializedName("expires")
  private Long expires = null;

  @SerializedName("rules")
  private AccessRules rules = null;

  public AccessParams accessRulesType(String accessRulesType) {
    this.accessRulesType = accessRulesType;
    return this;
  }

   /**
   * Get accessRulesType
   * @return accessRulesType
  **/
  @ApiModelProperty(value = "")
  public String getAccessRulesType() {
    return accessRulesType;
  }

  public void setAccessRulesType(String accessRulesType) {
    this.accessRulesType = accessRulesType;
  }

  public AccessParams accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Account id.
   * @return accountId
  **/
  @ApiModelProperty(value = "Account id.")
  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  public AccessParams attaches(String attaches) {
    this.attaches = attaches;
    return this;
  }

   /**
   * Generic field in a JSON format that contains additional information about the access authentication. This JSON will be attached to the temporary credentials that will be issued for this access authentication.
   * @return attaches
  **/
  @ApiModelProperty(value = "Generic field in a JSON format that contains additional information about the access authentication. This JSON will be attached to the temporary credentials that will be issued for this access authentication.")
  public String getAttaches() {
    return attaches;
  }

  public void setAttaches(String attaches) {
    this.attaches = attaches;
  }

  public AccessParams comment(String comment) {
    this.comment = comment;
    return this;
  }

   /**
   * Comments
   * @return comment
  **/
  @ApiModelProperty(value = "Comments")
  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public AccessParams expires(Long expires) {
    this.expires = expires;
    return this;
  }

   /**
   * Access expiration date (Unix timestamp).
   * @return expires
  **/
  @ApiModelProperty(required = true, value = "Access expiration date (Unix timestamp).")
  public Long getExpires() {
    return expires;
  }

  public void setExpires(Long expires) {
    this.expires = expires;
  }

  public AccessParams rules(AccessRules rules) {
    this.rules = rules;
    return this;
  }

   /**
   * Get rules
   * @return rules
  **/
  @ApiModelProperty(value = "")
  public AccessRules getRules() {
    return rules;
  }

  public void setRules(AccessRules rules) {
    this.rules = rules;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccessParams accessParams = (AccessParams) o;
    return Objects.equals(this.accessRulesType, accessParams.accessRulesType) &&
        Objects.equals(this.accountId, accessParams.accountId) &&
        Objects.equals(this.attaches, accessParams.attaches) &&
        Objects.equals(this.comment, accessParams.comment) &&
        Objects.equals(this.expires, accessParams.expires) &&
        Objects.equals(this.rules, accessParams.rules);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessRulesType, accountId, attaches, comment, expires, rules);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccessParams {\n");
    
    sb.append("    accessRulesType: ").append(toIndentedString(accessRulesType)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    attaches: ").append(toIndentedString(attaches)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    expires: ").append(toIndentedString(expires)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

