/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.akeyless.uam.swagger.model.AzureADAccessRole;
import com.akeyless.uam.swagger.model.OAuth2AccessRole;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * AccessRules
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class AccessRules {
  @SerializedName("alg")
  private String alg = null;

  @SerializedName("azure_ad_access_role")
  private AzureADAccessRole azureAdAccessRole = null;

  @SerializedName("cidr_whitelist")
  private String cidrWhitelist = null;

  @SerializedName("key")
  private String key = null;

  @SerializedName("oauth2_access_role")
  private OAuth2AccessRole oauth2AccessRole = null;

  public AccessRules alg(String alg) {
    this.alg = alg;
    return this;
  }

   /**
   * Get alg
   * @return alg
  **/
  @ApiModelProperty(value = "")
  public String getAlg() {
    return alg;
  }

  public void setAlg(String alg) {
    this.alg = alg;
  }

  public AccessRules azureAdAccessRole(AzureADAccessRole azureAdAccessRole) {
    this.azureAdAccessRole = azureAdAccessRole;
    return this;
  }

   /**
   * Get azureAdAccessRole
   * @return azureAdAccessRole
  **/
  @ApiModelProperty(value = "")
  public AzureADAccessRole getAzureAdAccessRole() {
    return azureAdAccessRole;
  }

  public void setAzureAdAccessRole(AzureADAccessRole azureAdAccessRole) {
    this.azureAdAccessRole = azureAdAccessRole;
  }

  public AccessRules cidrWhitelist(String cidrWhitelist) {
    this.cidrWhitelist = cidrWhitelist;
    return this;
  }

   /**
   * CIDR Whitelisting. Only requests from the ip addresses that match the CIDR list will be able to obtain temporary access credentials. The format of the CIDR list is a comma-separated list of valid CIDRs.The list length is limited to 10 CIDRs. In the case of an empty string there will be no restriction of IP addresses.
   * @return cidrWhitelist
  **/
  @ApiModelProperty(value = "CIDR Whitelisting. Only requests from the ip addresses that match the CIDR list will be able to obtain temporary access credentials. The format of the CIDR list is a comma-separated list of valid CIDRs.The list length is limited to 10 CIDRs. In the case of an empty string there will be no restriction of IP addresses.")
  public String getCidrWhitelist() {
    return cidrWhitelist;
  }

  public void setCidrWhitelist(String cidrWhitelist) {
    this.cidrWhitelist = cidrWhitelist;
  }

  public AccessRules key(String key) {
    this.key = key;
    return this;
  }

   /**
   * The public key value of the API-key. This is a mandatory parameter for API key access authentication.
   * @return key
  **/
  @ApiModelProperty(value = "The public key value of the API-key. This is a mandatory parameter for API key access authentication.")
  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public AccessRules oauth2AccessRole(OAuth2AccessRole oauth2AccessRole) {
    this.oauth2AccessRole = oauth2AccessRole;
    return this;
  }

   /**
   * Get oauth2AccessRole
   * @return oauth2AccessRole
  **/
  @ApiModelProperty(value = "")
  public OAuth2AccessRole getOauth2AccessRole() {
    return oauth2AccessRole;
  }

  public void setOauth2AccessRole(OAuth2AccessRole oauth2AccessRole) {
    this.oauth2AccessRole = oauth2AccessRole;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccessRules accessRules = (AccessRules) o;
    return Objects.equals(this.alg, accessRules.alg) &&
        Objects.equals(this.azureAdAccessRole, accessRules.azureAdAccessRole) &&
        Objects.equals(this.cidrWhitelist, accessRules.cidrWhitelist) &&
        Objects.equals(this.key, accessRules.key) &&
        Objects.equals(this.oauth2AccessRole, accessRules.oauth2AccessRole);
  }

  @Override
  public int hashCode() {
    return Objects.hash(alg, azureAdAccessRole, cidrWhitelist, key, oauth2AccessRole);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccessRules {\n");
    
    sb.append("    alg: ").append(toIndentedString(alg)).append("\n");
    sb.append("    azureAdAccessRole: ").append(toIndentedString(azureAdAccessRole)).append("\n");
    sb.append("    cidrWhitelist: ").append(toIndentedString(cidrWhitelist)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    oauth2AccessRole: ").append(toIndentedString(oauth2AccessRole)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

