/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * AzureADAccessRole
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class AzureADAccessRole {
  @SerializedName("ad_endpoint")
  private String adEndpoint = null;

  @SerializedName("bound_group_ids")
  private List<String> boundGroupIds = null;

  @SerializedName("bound_resource_groups")
  private List<String> boundResourceGroups = null;

  @SerializedName("bound_resource_ids")
  private List<String> boundResourceIds = null;

  @SerializedName("bound_resource_names")
  private List<String> boundResourceNames = null;

  @SerializedName("bound_resource_providers")
  private List<String> boundResourceProviders = null;

  @SerializedName("bound_resource_types")
  private List<String> boundResourceTypes = null;

  @SerializedName("bound_service_principal_ids")
  private List<String> boundServicePrincipalIds = null;

  @SerializedName("bound_subscription_ids")
  private List<String> boundSubscriptionIds = null;

  @SerializedName("bound_tenant_id")
  private String boundTenantId = null;

  @SerializedName("issuer")
  private String issuer = null;

  @SerializedName("jwks_uri")
  private String jwksUri = null;

  public AzureADAccessRole adEndpoint(String adEndpoint) {
    this.adEndpoint = adEndpoint;
    return this;
  }

   /**
   * The audience in the JWT.
   * @return adEndpoint
  **/
  @ApiModelProperty(value = "The audience in the JWT.")
  public String getAdEndpoint() {
    return adEndpoint;
  }

  public void setAdEndpoint(String adEndpoint) {
    this.adEndpoint = adEndpoint;
  }

  public AzureADAccessRole boundGroupIds(List<String> boundGroupIds) {
    this.boundGroupIds = boundGroupIds;
    return this;
  }

  public AzureADAccessRole addBoundGroupIdsItem(String boundGroupIdsItem) {
    if (this.boundGroupIds == null) {
      this.boundGroupIds = new ArrayList<String>();
    }
    this.boundGroupIds.add(boundGroupIdsItem);
    return this;
  }

   /**
   * The list of group ids that login is restricted to.
   * @return boundGroupIds
  **/
  @ApiModelProperty(value = "The list of group ids that login is restricted to.")
  public List<String> getBoundGroupIds() {
    return boundGroupIds;
  }

  public void setBoundGroupIds(List<String> boundGroupIds) {
    this.boundGroupIds = boundGroupIds;
  }

  public AzureADAccessRole boundResourceGroups(List<String> boundResourceGroups) {
    this.boundResourceGroups = boundResourceGroups;
    return this;
  }

  public AzureADAccessRole addBoundResourceGroupsItem(String boundResourceGroupsItem) {
    if (this.boundResourceGroups == null) {
      this.boundResourceGroups = new ArrayList<String>();
    }
    this.boundResourceGroups.add(boundResourceGroupsItem);
    return this;
  }

   /**
   * The list of resource groups that login is restricted to.
   * @return boundResourceGroups
  **/
  @ApiModelProperty(value = "The list of resource groups that login is restricted to.")
  public List<String> getBoundResourceGroups() {
    return boundResourceGroups;
  }

  public void setBoundResourceGroups(List<String> boundResourceGroups) {
    this.boundResourceGroups = boundResourceGroups;
  }

  public AzureADAccessRole boundResourceIds(List<String> boundResourceIds) {
    this.boundResourceIds = boundResourceIds;
    return this;
  }

  public AzureADAccessRole addBoundResourceIdsItem(String boundResourceIdsItem) {
    if (this.boundResourceIds == null) {
      this.boundResourceIds = new ArrayList<String>();
    }
    this.boundResourceIds.add(boundResourceIdsItem);
    return this;
  }

   /**
   * The list of full resource ids that the login is restricted to.
   * @return boundResourceIds
  **/
  @ApiModelProperty(value = "The list of full resource ids that the login is restricted to.")
  public List<String> getBoundResourceIds() {
    return boundResourceIds;
  }

  public void setBoundResourceIds(List<String> boundResourceIds) {
    this.boundResourceIds = boundResourceIds;
  }

  public AzureADAccessRole boundResourceNames(List<String> boundResourceNames) {
    this.boundResourceNames = boundResourceNames;
    return this;
  }

  public AzureADAccessRole addBoundResourceNamesItem(String boundResourceNamesItem) {
    if (this.boundResourceNames == null) {
      this.boundResourceNames = new ArrayList<String>();
    }
    this.boundResourceNames.add(boundResourceNamesItem);
    return this;
  }

   /**
   * The list of resource names that the login is restricted to (e.g, a virtual machine name, scale set name, etc).
   * @return boundResourceNames
  **/
  @ApiModelProperty(value = "The list of resource names that the login is restricted to (e.g, a virtual machine name, scale set name, etc).")
  public List<String> getBoundResourceNames() {
    return boundResourceNames;
  }

  public void setBoundResourceNames(List<String> boundResourceNames) {
    this.boundResourceNames = boundResourceNames;
  }

  public AzureADAccessRole boundResourceProviders(List<String> boundResourceProviders) {
    this.boundResourceProviders = boundResourceProviders;
    return this;
  }

  public AzureADAccessRole addBoundResourceProvidersItem(String boundResourceProvidersItem) {
    if (this.boundResourceProviders == null) {
      this.boundResourceProviders = new ArrayList<String>();
    }
    this.boundResourceProviders.add(boundResourceProvidersItem);
    return this;
  }

   /**
   * The list of resource providers that login is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc).
   * @return boundResourceProviders
  **/
  @ApiModelProperty(value = "The list of resource providers that login is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc).")
  public List<String> getBoundResourceProviders() {
    return boundResourceProviders;
  }

  public void setBoundResourceProviders(List<String> boundResourceProviders) {
    this.boundResourceProviders = boundResourceProviders;
  }

  public AzureADAccessRole boundResourceTypes(List<String> boundResourceTypes) {
    this.boundResourceTypes = boundResourceTypes;
    return this;
  }

  public AzureADAccessRole addBoundResourceTypesItem(String boundResourceTypesItem) {
    if (this.boundResourceTypes == null) {
      this.boundResourceTypes = new ArrayList<String>();
    }
    this.boundResourceTypes.add(boundResourceTypesItem);
    return this;
  }

   /**
   * The list of resource types that login is restricted to  (e.g, virtualMachines, userAssignedIdentities, etc).
   * @return boundResourceTypes
  **/
  @ApiModelProperty(value = "The list of resource types that login is restricted to  (e.g, virtualMachines, userAssignedIdentities, etc).")
  public List<String> getBoundResourceTypes() {
    return boundResourceTypes;
  }

  public void setBoundResourceTypes(List<String> boundResourceTypes) {
    this.boundResourceTypes = boundResourceTypes;
  }

  public AzureADAccessRole boundServicePrincipalIds(List<String> boundServicePrincipalIds) {
    this.boundServicePrincipalIds = boundServicePrincipalIds;
    return this;
  }

  public AzureADAccessRole addBoundServicePrincipalIdsItem(String boundServicePrincipalIdsItem) {
    if (this.boundServicePrincipalIds == null) {
      this.boundServicePrincipalIds = new ArrayList<String>();
    }
    this.boundServicePrincipalIds.add(boundServicePrincipalIdsItem);
    return this;
  }

   /**
   * The list of service principal IDs that login is restricted to.
   * @return boundServicePrincipalIds
  **/
  @ApiModelProperty(value = "The list of service principal IDs that login is restricted to.")
  public List<String> getBoundServicePrincipalIds() {
    return boundServicePrincipalIds;
  }

  public void setBoundServicePrincipalIds(List<String> boundServicePrincipalIds) {
    this.boundServicePrincipalIds = boundServicePrincipalIds;
  }

  public AzureADAccessRole boundSubscriptionIds(List<String> boundSubscriptionIds) {
    this.boundSubscriptionIds = boundSubscriptionIds;
    return this;
  }

  public AzureADAccessRole addBoundSubscriptionIdsItem(String boundSubscriptionIdsItem) {
    if (this.boundSubscriptionIds == null) {
      this.boundSubscriptionIds = new ArrayList<String>();
    }
    this.boundSubscriptionIds.add(boundSubscriptionIdsItem);
    return this;
  }

   /**
   * The list of subscription IDs that login is restricted to.
   * @return boundSubscriptionIds
  **/
  @ApiModelProperty(value = "The list of subscription IDs that login is restricted to.")
  public List<String> getBoundSubscriptionIds() {
    return boundSubscriptionIds;
  }

  public void setBoundSubscriptionIds(List<String> boundSubscriptionIds) {
    this.boundSubscriptionIds = boundSubscriptionIds;
  }

  public AzureADAccessRole boundTenantId(String boundTenantId) {
    this.boundTenantId = boundTenantId;
    return this;
  }

   /**
   * The tenants id for the Azure Active Directory organization.
   * @return boundTenantId
  **/
  @ApiModelProperty(value = "The tenants id for the Azure Active Directory organization.")
  public String getBoundTenantId() {
    return boundTenantId;
  }

  public void setBoundTenantId(String boundTenantId) {
    this.boundTenantId = boundTenantId;
  }

  public AzureADAccessRole issuer(String issuer) {
    this.issuer = issuer;
    return this;
  }

   /**
   * Issuer URL
   * @return issuer
  **/
  @ApiModelProperty(value = "Issuer URL")
  public String getIssuer() {
    return issuer;
  }

  public void setIssuer(String issuer) {
    this.issuer = issuer;
  }

  public AzureADAccessRole jwksUri(String jwksUri) {
    this.jwksUri = jwksUri;
    return this;
  }

   /**
   * The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.
   * @return jwksUri
  **/
  @ApiModelProperty(value = "The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.")
  public String getJwksUri() {
    return jwksUri;
  }

  public void setJwksUri(String jwksUri) {
    this.jwksUri = jwksUri;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AzureADAccessRole azureADAccessRole = (AzureADAccessRole) o;
    return Objects.equals(this.adEndpoint, azureADAccessRole.adEndpoint) &&
        Objects.equals(this.boundGroupIds, azureADAccessRole.boundGroupIds) &&
        Objects.equals(this.boundResourceGroups, azureADAccessRole.boundResourceGroups) &&
        Objects.equals(this.boundResourceIds, azureADAccessRole.boundResourceIds) &&
        Objects.equals(this.boundResourceNames, azureADAccessRole.boundResourceNames) &&
        Objects.equals(this.boundResourceProviders, azureADAccessRole.boundResourceProviders) &&
        Objects.equals(this.boundResourceTypes, azureADAccessRole.boundResourceTypes) &&
        Objects.equals(this.boundServicePrincipalIds, azureADAccessRole.boundServicePrincipalIds) &&
        Objects.equals(this.boundSubscriptionIds, azureADAccessRole.boundSubscriptionIds) &&
        Objects.equals(this.boundTenantId, azureADAccessRole.boundTenantId) &&
        Objects.equals(this.issuer, azureADAccessRole.issuer) &&
        Objects.equals(this.jwksUri, azureADAccessRole.jwksUri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(adEndpoint, boundGroupIds, boundResourceGroups, boundResourceIds, boundResourceNames, boundResourceProviders, boundResourceTypes, boundServicePrincipalIds, boundSubscriptionIds, boundTenantId, issuer, jwksUri);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AzureADAccessRole {\n");
    
    sb.append("    adEndpoint: ").append(toIndentedString(adEndpoint)).append("\n");
    sb.append("    boundGroupIds: ").append(toIndentedString(boundGroupIds)).append("\n");
    sb.append("    boundResourceGroups: ").append(toIndentedString(boundResourceGroups)).append("\n");
    sb.append("    boundResourceIds: ").append(toIndentedString(boundResourceIds)).append("\n");
    sb.append("    boundResourceNames: ").append(toIndentedString(boundResourceNames)).append("\n");
    sb.append("    boundResourceProviders: ").append(toIndentedString(boundResourceProviders)).append("\n");
    sb.append("    boundResourceTypes: ").append(toIndentedString(boundResourceTypes)).append("\n");
    sb.append("    boundServicePrincipalIds: ").append(toIndentedString(boundServicePrincipalIds)).append("\n");
    sb.append("    boundSubscriptionIds: ").append(toIndentedString(boundSubscriptionIds)).append("\n");
    sb.append("    boundTenantId: ").append(toIndentedString(boundTenantId)).append("\n");
    sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
    sb.append("    jwksUri: ").append(toIndentedString(jwksUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

