/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.akeyless.uam.swagger.model.AccessRules;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * CreateAccountCredsParams
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class CreateAccountCredsParams {
  @SerializedName("access_rules_type")
  private String accessRulesType = null;

  @SerializedName("account_admin_user_email")
  private String accountAdminUserEmail = null;

  @SerializedName("account_admin_user_phone")
  private String accountAdminUserPhone = null;

  @SerializedName("expires")
  private Long expires = null;

  @SerializedName("rules")
  private AccessRules rules = null;

  public CreateAccountCredsParams accessRulesType(String accessRulesType) {
    this.accessRulesType = accessRulesType;
    return this;
  }

   /**
   * Get accessRulesType
   * @return accessRulesType
  **/
  @ApiModelProperty(value = "")
  public String getAccessRulesType() {
    return accessRulesType;
  }

  public void setAccessRulesType(String accessRulesType) {
    this.accessRulesType = accessRulesType;
  }

  public CreateAccountCredsParams accountAdminUserEmail(String accountAdminUserEmail) {
    this.accountAdminUserEmail = accountAdminUserEmail;
    return this;
  }

   /**
   * Account admin user email
   * @return accountAdminUserEmail
  **/
  @ApiModelProperty(value = "Account admin user email")
  public String getAccountAdminUserEmail() {
    return accountAdminUserEmail;
  }

  public void setAccountAdminUserEmail(String accountAdminUserEmail) {
    this.accountAdminUserEmail = accountAdminUserEmail;
  }

  public CreateAccountCredsParams accountAdminUserPhone(String accountAdminUserPhone) {
    this.accountAdminUserPhone = accountAdminUserPhone;
    return this;
  }

   /**
   * Account admin user phone
   * @return accountAdminUserPhone
  **/
  @ApiModelProperty(value = "Account admin user phone")
  public String getAccountAdminUserPhone() {
    return accountAdminUserPhone;
  }

  public void setAccountAdminUserPhone(String accountAdminUserPhone) {
    this.accountAdminUserPhone = accountAdminUserPhone;
  }

  public CreateAccountCredsParams expires(Long expires) {
    this.expires = expires;
    return this;
  }

   /**
   * Access expiration date (Unix timestamp).
   * @return expires
  **/
  @ApiModelProperty(value = "Access expiration date (Unix timestamp).")
  public Long getExpires() {
    return expires;
  }

  public void setExpires(Long expires) {
    this.expires = expires;
  }

  public CreateAccountCredsParams rules(AccessRules rules) {
    this.rules = rules;
    return this;
  }

   /**
   * Get rules
   * @return rules
  **/
  @ApiModelProperty(value = "")
  public AccessRules getRules() {
    return rules;
  }

  public void setRules(AccessRules rules) {
    this.rules = rules;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateAccountCredsParams createAccountCredsParams = (CreateAccountCredsParams) o;
    return Objects.equals(this.accessRulesType, createAccountCredsParams.accessRulesType) &&
        Objects.equals(this.accountAdminUserEmail, createAccountCredsParams.accountAdminUserEmail) &&
        Objects.equals(this.accountAdminUserPhone, createAccountCredsParams.accountAdminUserPhone) &&
        Objects.equals(this.expires, createAccountCredsParams.expires) &&
        Objects.equals(this.rules, createAccountCredsParams.rules);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessRulesType, accountAdminUserEmail, accountAdminUserPhone, expires, rules);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateAccountCredsParams {\n");
    
    sb.append("    accessRulesType: ").append(toIndentedString(accessRulesType)).append("\n");
    sb.append("    accountAdminUserEmail: ").append(toIndentedString(accountAdminUserEmail)).append("\n");
    sb.append("    accountAdminUserPhone: ").append(toIndentedString(accountAdminUserPhone)).append("\n");
    sb.append("    expires: ").append(toIndentedString(expires)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

