/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Temporary access credentials to get fragments derivations from KFM instances together with the KFMs host names.
 */
@ApiModel(description = "Temporary access credentials to get fragments derivations from KFM instances together with the KFMs host names.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class DerivationCredsReplyObj {
  @SerializedName("KFMsHostsDNSMap")
  private Map<String, String> kfMsHostsDNSMap = null;

  @SerializedName("credential")
  private String credential = null;

  @SerializedName("customer_fragment_id")
  private String customerFragmentId = null;

  @SerializedName("expiry")
  private Long expiry = null;

  @SerializedName("item_id")
  private Long itemId = null;

  @SerializedName("item_name")
  private String itemName = null;

  @SerializedName("item_size")
  private Long itemSize = null;

  @SerializedName("item_type")
  private String itemType = null;

  @SerializedName("item_version")
  private Integer itemVersion = null;

  @SerializedName("restricted_dd")
  private String restrictedDd = null;

  public DerivationCredsReplyObj kfMsHostsDNSMap(Map<String, String> kfMsHostsDNSMap) {
    this.kfMsHostsDNSMap = kfMsHostsDNSMap;
    return this;
  }

  public DerivationCredsReplyObj putKfMsHostsDNSMapItem(String key, String kfMsHostsDNSMapItem) {
    if (this.kfMsHostsDNSMap == null) {
      this.kfMsHostsDNSMap = new HashMap<String, String>();
    }
    this.kfMsHostsDNSMap.put(key, kfMsHostsDNSMapItem);
    return this;
  }

   /**
   * Mapping between the serial number of the key fragments and the KFMs hosts DNS in which they are stored.
   * @return kfMsHostsDNSMap
  **/
  @ApiModelProperty(value = "Mapping between the serial number of the key fragments and the KFMs hosts DNS in which they are stored.")
  public Map<String, String> getKfMsHostsDNSMap() {
    return kfMsHostsDNSMap;
  }

  public void setKfMsHostsDNSMap(Map<String, String> kfMsHostsDNSMap) {
    this.kfMsHostsDNSMap = kfMsHostsDNSMap;
  }

  public DerivationCredsReplyObj credential(String credential) {
    this.credential = credential;
    return this;
  }

   /**
   * Temporary credentials string (JWT format)
   * @return credential
  **/
  @ApiModelProperty(value = "Temporary credentials string (JWT format)")
  public String getCredential() {
    return credential;
  }

  public void setCredential(String credential) {
    this.credential = credential;
  }

  public DerivationCredsReplyObj customerFragmentId(String customerFragmentId) {
    this.customerFragmentId = customerFragmentId;
    return this;
  }

   /**
   * The customer fragment ID associated with this key (if any).
   * @return customerFragmentId
  **/
  @ApiModelProperty(value = "The customer fragment ID associated with this key (if any).")
  public String getCustomerFragmentId() {
    return customerFragmentId;
  }

  public void setCustomerFragmentId(String customerFragmentId) {
    this.customerFragmentId = customerFragmentId;
  }

  public DerivationCredsReplyObj expiry(Long expiry) {
    this.expiry = expiry;
    return this;
  }

   /**
   * Credentials expiration date
   * @return expiry
  **/
  @ApiModelProperty(value = "Credentials expiration date")
  public Long getExpiry() {
    return expiry;
  }

  public void setExpiry(Long expiry) {
    this.expiry = expiry;
  }

  public DerivationCredsReplyObj itemId(Long itemId) {
    this.itemId = itemId;
    return this;
  }

   /**
   * Get itemId
   * @return itemId
  **/
  @ApiModelProperty(value = "")
  public Long getItemId() {
    return itemId;
  }

  public void setItemId(Long itemId) {
    this.itemId = itemId;
  }

  public DerivationCredsReplyObj itemName(String itemName) {
    this.itemName = itemName;
    return this;
  }

   /**
   * The name and id of the item that the fragments belong to
   * @return itemName
  **/
  @ApiModelProperty(value = "The name and id of the item that the fragments belong to")
  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  public DerivationCredsReplyObj itemSize(Long itemSize) {
    this.itemSize = itemSize;
    return this;
  }

   /**
   * Get itemSize
   * @return itemSize
  **/
  @ApiModelProperty(value = "")
  public Long getItemSize() {
    return itemSize;
  }

  public void setItemSize(Long itemSize) {
    this.itemSize = itemSize;
  }

  public DerivationCredsReplyObj itemType(String itemType) {
    this.itemType = itemType;
    return this;
  }

   /**
   * Get itemType
   * @return itemType
  **/
  @ApiModelProperty(value = "")
  public String getItemType() {
    return itemType;
  }

  public void setItemType(String itemType) {
    this.itemType = itemType;
  }

  public DerivationCredsReplyObj itemVersion(Integer itemVersion) {
    this.itemVersion = itemVersion;
    return this;
  }

   /**
   * The version, type and size of the key that the fragments belong to
   * @return itemVersion
  **/
  @ApiModelProperty(value = "The version, type and size of the key that the fragments belong to")
  public Integer getItemVersion() {
    return itemVersion;
  }

  public void setItemVersion(Integer itemVersion) {
    this.itemVersion = itemVersion;
  }

  public DerivationCredsReplyObj restrictedDd(String restrictedDd) {
    this.restrictedDd = restrictedDd;
    return this;
  }

   /**
   * In case not empty, the derivation operation will be restricted to this derivation data
   * @return restrictedDd
  **/
  @ApiModelProperty(value = "In case not empty, the derivation operation will be restricted to this derivation data")
  public String getRestrictedDd() {
    return restrictedDd;
  }

  public void setRestrictedDd(String restrictedDd) {
    this.restrictedDd = restrictedDd;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DerivationCredsReplyObj derivationCredsReplyObj = (DerivationCredsReplyObj) o;
    return Objects.equals(this.kfMsHostsDNSMap, derivationCredsReplyObj.kfMsHostsDNSMap) &&
        Objects.equals(this.credential, derivationCredsReplyObj.credential) &&
        Objects.equals(this.customerFragmentId, derivationCredsReplyObj.customerFragmentId) &&
        Objects.equals(this.expiry, derivationCredsReplyObj.expiry) &&
        Objects.equals(this.itemId, derivationCredsReplyObj.itemId) &&
        Objects.equals(this.itemName, derivationCredsReplyObj.itemName) &&
        Objects.equals(this.itemSize, derivationCredsReplyObj.itemSize) &&
        Objects.equals(this.itemType, derivationCredsReplyObj.itemType) &&
        Objects.equals(this.itemVersion, derivationCredsReplyObj.itemVersion) &&
        Objects.equals(this.restrictedDd, derivationCredsReplyObj.restrictedDd);
  }

  @Override
  public int hashCode() {
    return Objects.hash(kfMsHostsDNSMap, credential, customerFragmentId, expiry, itemId, itemName, itemSize, itemType, itemVersion, restrictedDd);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DerivationCredsReplyObj {\n");
    
    sb.append("    kfMsHostsDNSMap: ").append(toIndentedString(kfMsHostsDNSMap)).append("\n");
    sb.append("    credential: ").append(toIndentedString(credential)).append("\n");
    sb.append("    customerFragmentId: ").append(toIndentedString(customerFragmentId)).append("\n");
    sb.append("    expiry: ").append(toIndentedString(expiry)).append("\n");
    sb.append("    itemId: ").append(toIndentedString(itemId)).append("\n");
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    itemSize: ").append(toIndentedString(itemSize)).append("\n");
    sb.append("    itemType: ").append(toIndentedString(itemType)).append("\n");
    sb.append("    itemVersion: ").append(toIndentedString(itemVersion)).append("\n");
    sb.append("    restrictedDd: ").append(toIndentedString(restrictedDd)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

