/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * DerivedFragmentReplyObj
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class DerivedFragmentReplyObj {
  @SerializedName("derivation_data")
  private String derivationData = null;

  @SerializedName("derived_fragment")
  private String derivedFragment = null;

  public DerivedFragmentReplyObj derivationData(String derivationData) {
    this.derivationData = derivationData;
    return this;
  }

   /**
   * The derivation data that was used for the fragment derivation operation. Relevant for double derivation where the returned derivation data are different from the derivation seed that was received by the client
   * @return derivationData
  **/
  @ApiModelProperty(value = "The derivation data that was used for the fragment derivation operation. Relevant for double derivation where the returned derivation data are different from the derivation seed that was received by the client")
  public String getDerivationData() {
    return derivationData;
  }

  public void setDerivationData(String derivationData) {
    this.derivationData = derivationData;
  }

  public DerivedFragmentReplyObj derivedFragment(String derivedFragment) {
    this.derivedFragment = derivedFragment;
    return this;
  }

   /**
   * The derived fragment value
   * @return derivedFragment
  **/
  @ApiModelProperty(value = "The derived fragment value")
  public String getDerivedFragment() {
    return derivedFragment;
  }

  public void setDerivedFragment(String derivedFragment) {
    this.derivedFragment = derivedFragment;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DerivedFragmentReplyObj derivedFragmentReplyObj = (DerivedFragmentReplyObj) o;
    return Objects.equals(this.derivationData, derivedFragmentReplyObj.derivationData) &&
        Objects.equals(this.derivedFragment, derivedFragmentReplyObj.derivedFragment);
  }

  @Override
  public int hashCode() {
    return Objects.hash(derivationData, derivedFragment);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DerivedFragmentReplyObj {\n");
    
    sb.append("    derivationData: ").append(toIndentedString(derivationData)).append("\n");
    sb.append("    derivedFragment: ").append(toIndentedString(derivedFragment)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

