/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.akeyless.uam.swagger.model.DynamicSecretMessageQueueInfo;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * The message queue URL and a signed request to receive messages from a Message Queue of a Dynamic Secret
 */
@ApiModel(description = "The message queue URL and a signed request to receive messages from a Message Queue of a Dynamic Secret")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class DynamicSecretMQAccessReplyObj {
  @SerializedName("mq_info")
  private DynamicSecretMessageQueueInfo mqInfo = null;

  @SerializedName("receive_messages_signed_request")
  private String receiveMessagesSignedRequest = null;

  public DynamicSecretMQAccessReplyObj mqInfo(DynamicSecretMessageQueueInfo mqInfo) {
    this.mqInfo = mqInfo;
    return this;
  }

   /**
   * Get mqInfo
   * @return mqInfo
  **/
  @ApiModelProperty(value = "")
  public DynamicSecretMessageQueueInfo getMqInfo() {
    return mqInfo;
  }

  public void setMqInfo(DynamicSecretMessageQueueInfo mqInfo) {
    this.mqInfo = mqInfo;
  }

  public DynamicSecretMQAccessReplyObj receiveMessagesSignedRequest(String receiveMessagesSignedRequest) {
    this.receiveMessagesSignedRequest = receiveMessagesSignedRequest;
    return this;
  }

   /**
   * A signed request to receive messages from the Message Queue
   * @return receiveMessagesSignedRequest
  **/
  @ApiModelProperty(value = "A signed request to receive messages from the Message Queue")
  public String getReceiveMessagesSignedRequest() {
    return receiveMessagesSignedRequest;
  }

  public void setReceiveMessagesSignedRequest(String receiveMessagesSignedRequest) {
    this.receiveMessagesSignedRequest = receiveMessagesSignedRequest;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DynamicSecretMQAccessReplyObj dynamicSecretMQAccessReplyObj = (DynamicSecretMQAccessReplyObj) o;
    return Objects.equals(this.mqInfo, dynamicSecretMQAccessReplyObj.mqInfo) &&
        Objects.equals(this.receiveMessagesSignedRequest, dynamicSecretMQAccessReplyObj.receiveMessagesSignedRequest);
  }

  @Override
  public int hashCode() {
    return Objects.hash(mqInfo, receiveMessagesSignedRequest);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DynamicSecretMQAccessReplyObj {\n");
    
    sb.append("    mqInfo: ").append(toIndentedString(mqInfo)).append("\n");
    sb.append("    receiveMessagesSignedRequest: ").append(toIndentedString(receiveMessagesSignedRequest)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

