/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * The derivation credentials for the dynamic secret producer to encrypt the new dynamic secret value
 */
@ApiModel(description = "The derivation credentials for the dynamic secret producer to encrypt the new dynamic secret value")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class DynamicSecretProducerCredsReplyObj {
  @SerializedName("expiry")
  private Long expiry = null;

  @SerializedName("producer_protection_key_derivation_creds")
  private String producerProtectionKeyDerivationCreds = null;

  public DynamicSecretProducerCredsReplyObj expiry(Long expiry) {
    this.expiry = expiry;
    return this;
  }

   /**
   * Credentials expiration date
   * @return expiry
  **/
  @ApiModelProperty(value = "Credentials expiration date")
  public Long getExpiry() {
    return expiry;
  }

  public void setExpiry(Long expiry) {
    this.expiry = expiry;
  }

  public DynamicSecretProducerCredsReplyObj producerProtectionKeyDerivationCreds(String producerProtectionKeyDerivationCreds) {
    this.producerProtectionKeyDerivationCreds = producerProtectionKeyDerivationCreds;
    return this;
  }

   /**
   * Temporary access credentials (JWT format) for the dynamic secret producer to get an access to the key fragments that protects the dynamic secret value from KFM instances together with the KFMs host names.
   * @return producerProtectionKeyDerivationCreds
  **/
  @ApiModelProperty(value = "Temporary access credentials (JWT format) for the dynamic secret producer to get an access to the key fragments that protects the dynamic secret value from KFM instances together with the KFMs host names.")
  public String getProducerProtectionKeyDerivationCreds() {
    return producerProtectionKeyDerivationCreds;
  }

  public void setProducerProtectionKeyDerivationCreds(String producerProtectionKeyDerivationCreds) {
    this.producerProtectionKeyDerivationCreds = producerProtectionKeyDerivationCreds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DynamicSecretProducerCredsReplyObj dynamicSecretProducerCredsReplyObj = (DynamicSecretProducerCredsReplyObj) o;
    return Objects.equals(this.expiry, dynamicSecretProducerCredsReplyObj.expiry) &&
        Objects.equals(this.producerProtectionKeyDerivationCreds, dynamicSecretProducerCredsReplyObj.producerProtectionKeyDerivationCreds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expiry, producerProtectionKeyDerivationCreds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DynamicSecretProducerCredsReplyObj {\n");
    
    sb.append("    expiry: ").append(toIndentedString(expiry)).append("\n");
    sb.append("    producerProtectionKeyDerivationCreds: ").append(toIndentedString(producerProtectionKeyDerivationCreds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

