/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.akeyless.uam.swagger.model.AccessRules;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * GetAccessReplyObj
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class GetAccessReplyObj {
  @SerializedName("access_id")
  private String accessId = null;

  @SerializedName("access_rules_type")
  private String accessRulesType = null;

  @SerializedName("access_type")
  private String accessType = null;

  @SerializedName("account_id")
  private String accountId = null;

  @SerializedName("attaches")
  private String attaches = null;

  @SerializedName("comment")
  private String comment = null;

  @SerializedName("expires")
  private Long expires = null;

  @SerializedName("rules")
  private AccessRules rules = null;

  public GetAccessReplyObj accessId(String accessId) {
    this.accessId = accessId;
    return this;
  }

   /**
   * Access id.
   * @return accessId
  **/
  @ApiModelProperty(value = "Access id.")
  public String getAccessId() {
    return accessId;
  }

  public void setAccessId(String accessId) {
    this.accessId = accessId;
  }

  public GetAccessReplyObj accessRulesType(String accessRulesType) {
    this.accessRulesType = accessRulesType;
    return this;
  }

   /**
   * Get accessRulesType
   * @return accessRulesType
  **/
  @ApiModelProperty(value = "")
  public String getAccessRulesType() {
    return accessRulesType;
  }

  public void setAccessRulesType(String accessRulesType) {
    this.accessRulesType = accessRulesType;
  }

  public GetAccessReplyObj accessType(String accessType) {
    this.accessType = accessType;
    return this;
  }

   /**
   * Get accessType
   * @return accessType
  **/
  @ApiModelProperty(value = "")
  public String getAccessType() {
    return accessType;
  }

  public void setAccessType(String accessType) {
    this.accessType = accessType;
  }

  public GetAccessReplyObj accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Account id.
   * @return accountId
  **/
  @ApiModelProperty(value = "Account id.")
  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  public GetAccessReplyObj attaches(String attaches) {
    this.attaches = attaches;
    return this;
  }

   /**
   * Access attaches
   * @return attaches
  **/
  @ApiModelProperty(value = "Access attaches")
  public String getAttaches() {
    return attaches;
  }

  public void setAttaches(String attaches) {
    this.attaches = attaches;
  }

  public GetAccessReplyObj comment(String comment) {
    this.comment = comment;
    return this;
  }

   /**
   * Comments
   * @return comment
  **/
  @ApiModelProperty(value = "Comments")
  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public GetAccessReplyObj expires(Long expires) {
    this.expires = expires;
    return this;
  }

   /**
   * Access expiration date.
   * @return expires
  **/
  @ApiModelProperty(value = "Access expiration date.")
  public Long getExpires() {
    return expires;
  }

  public void setExpires(Long expires) {
    this.expires = expires;
  }

  public GetAccessReplyObj rules(AccessRules rules) {
    this.rules = rules;
    return this;
  }

   /**
   * Get rules
   * @return rules
  **/
  @ApiModelProperty(value = "")
  public AccessRules getRules() {
    return rules;
  }

  public void setRules(AccessRules rules) {
    this.rules = rules;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetAccessReplyObj getAccessReplyObj = (GetAccessReplyObj) o;
    return Objects.equals(this.accessId, getAccessReplyObj.accessId) &&
        Objects.equals(this.accessRulesType, getAccessReplyObj.accessRulesType) &&
        Objects.equals(this.accessType, getAccessReplyObj.accessType) &&
        Objects.equals(this.accountId, getAccessReplyObj.accountId) &&
        Objects.equals(this.attaches, getAccessReplyObj.attaches) &&
        Objects.equals(this.comment, getAccessReplyObj.comment) &&
        Objects.equals(this.expires, getAccessReplyObj.expires) &&
        Objects.equals(this.rules, getAccessReplyObj.rules);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessId, accessRulesType, accessType, accountId, attaches, comment, expires, rules);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetAccessReplyObj {\n");
    
    sb.append("    accessId: ").append(toIndentedString(accessId)).append("\n");
    sb.append("    accessRulesType: ").append(toIndentedString(accessRulesType)).append("\n");
    sb.append("    accessType: ").append(toIndentedString(accessType)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    attaches: ").append(toIndentedString(attaches)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    expires: ").append(toIndentedString(expires)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

