/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * GetItemReplyObj
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class GetItemReplyObj {
  @SerializedName("certificates")
  private String certificates = null;

  @SerializedName("item_name")
  private String itemName = null;

  @SerializedName("item_roles")
  private List<String> itemRoles = null;

  @SerializedName("item_size")
  private Long itemSize = null;

  @SerializedName("item_type")
  private String itemType = null;

  @SerializedName("last_version")
  private Integer lastVersion = null;

  @SerializedName("public_value")
  private String publicValue = null;

  @SerializedName("user_metadata")
  private String userMetadata = null;

  @SerializedName("with_customer_fragment")
  private Boolean withCustomerFragment = null;

  public GetItemReplyObj certificates(String certificates) {
    this.certificates = certificates;
    return this;
  }

   /**
   * Get certificates
   * @return certificates
  **/
  @ApiModelProperty(value = "")
  public String getCertificates() {
    return certificates;
  }

  public void setCertificates(String certificates) {
    this.certificates = certificates;
  }

  public GetItemReplyObj itemName(String itemName) {
    this.itemName = itemName;
    return this;
  }

   /**
   * Get itemName
   * @return itemName
  **/
  @ApiModelProperty(value = "")
  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  public GetItemReplyObj itemRoles(List<String> itemRoles) {
    this.itemRoles = itemRoles;
    return this;
  }

  public GetItemReplyObj addItemRolesItem(String itemRolesItem) {
    if (this.itemRoles == null) {
      this.itemRoles = new ArrayList<String>();
    }
    this.itemRoles.add(itemRolesItem);
    return this;
  }

   /**
   * Get itemRoles
   * @return itemRoles
  **/
  @ApiModelProperty(value = "")
  public List<String> getItemRoles() {
    return itemRoles;
  }

  public void setItemRoles(List<String> itemRoles) {
    this.itemRoles = itemRoles;
  }

  public GetItemReplyObj itemSize(Long itemSize) {
    this.itemSize = itemSize;
    return this;
  }

   /**
   * Get itemSize
   * @return itemSize
  **/
  @ApiModelProperty(value = "")
  public Long getItemSize() {
    return itemSize;
  }

  public void setItemSize(Long itemSize) {
    this.itemSize = itemSize;
  }

  public GetItemReplyObj itemType(String itemType) {
    this.itemType = itemType;
    return this;
  }

   /**
   * Get itemType
   * @return itemType
  **/
  @ApiModelProperty(value = "")
  public String getItemType() {
    return itemType;
  }

  public void setItemType(String itemType) {
    this.itemType = itemType;
  }

  public GetItemReplyObj lastVersion(Integer lastVersion) {
    this.lastVersion = lastVersion;
    return this;
  }

   /**
   * Get lastVersion
   * @return lastVersion
  **/
  @ApiModelProperty(value = "")
  public Integer getLastVersion() {
    return lastVersion;
  }

  public void setLastVersion(Integer lastVersion) {
    this.lastVersion = lastVersion;
  }

  public GetItemReplyObj publicValue(String publicValue) {
    this.publicValue = publicValue;
    return this;
  }

   /**
   * Get publicValue
   * @return publicValue
  **/
  @ApiModelProperty(value = "")
  public String getPublicValue() {
    return publicValue;
  }

  public void setPublicValue(String publicValue) {
    this.publicValue = publicValue;
  }

  public GetItemReplyObj userMetadata(String userMetadata) {
    this.userMetadata = userMetadata;
    return this;
  }

   /**
   * Get userMetadata
   * @return userMetadata
  **/
  @ApiModelProperty(value = "")
  public String getUserMetadata() {
    return userMetadata;
  }

  public void setUserMetadata(String userMetadata) {
    this.userMetadata = userMetadata;
  }

  public GetItemReplyObj withCustomerFragment(Boolean withCustomerFragment) {
    this.withCustomerFragment = withCustomerFragment;
    return this;
  }

   /**
   * Get withCustomerFragment
   * @return withCustomerFragment
  **/
  @ApiModelProperty(value = "")
  public Boolean isWithCustomerFragment() {
    return withCustomerFragment;
  }

  public void setWithCustomerFragment(Boolean withCustomerFragment) {
    this.withCustomerFragment = withCustomerFragment;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetItemReplyObj getItemReplyObj = (GetItemReplyObj) o;
    return Objects.equals(this.certificates, getItemReplyObj.certificates) &&
        Objects.equals(this.itemName, getItemReplyObj.itemName) &&
        Objects.equals(this.itemRoles, getItemReplyObj.itemRoles) &&
        Objects.equals(this.itemSize, getItemReplyObj.itemSize) &&
        Objects.equals(this.itemType, getItemReplyObj.itemType) &&
        Objects.equals(this.lastVersion, getItemReplyObj.lastVersion) &&
        Objects.equals(this.publicValue, getItemReplyObj.publicValue) &&
        Objects.equals(this.userMetadata, getItemReplyObj.userMetadata) &&
        Objects.equals(this.withCustomerFragment, getItemReplyObj.withCustomerFragment);
  }

  @Override
  public int hashCode() {
    return Objects.hash(certificates, itemName, itemRoles, itemSize, itemType, lastVersion, publicValue, userMetadata, withCustomerFragment);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetItemReplyObj {\n");
    
    sb.append("    certificates: ").append(toIndentedString(certificates)).append("\n");
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    itemRoles: ").append(toIndentedString(itemRoles)).append("\n");
    sb.append("    itemSize: ").append(toIndentedString(itemSize)).append("\n");
    sb.append("    itemType: ").append(toIndentedString(itemType)).append("\n");
    sb.append("    lastVersion: ").append(toIndentedString(lastVersion)).append("\n");
    sb.append("    publicValue: ").append(toIndentedString(publicValue)).append("\n");
    sb.append("    userMetadata: ").append(toIndentedString(userMetadata)).append("\n");
    sb.append("    withCustomerFragment: ").append(toIndentedString(withCustomerFragment)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

