/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * GetRoleReplyObj
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class GetRoleReplyObj {
  @SerializedName("comment")
  private String comment = null;

  @SerializedName("role_action")
  private String roleAction = null;

  @SerializedName("role_items")
  private List<String> roleItems = null;

  @SerializedName("role_name")
  private String roleName = null;

  @SerializedName("role_users")
  private List<String> roleUsers = null;

  public GetRoleReplyObj comment(String comment) {
    this.comment = comment;
    return this;
  }

   /**
   * Get comment
   * @return comment
  **/
  @ApiModelProperty(value = "")
  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public GetRoleReplyObj roleAction(String roleAction) {
    this.roleAction = roleAction;
    return this;
  }

   /**
   * Get roleAction
   * @return roleAction
  **/
  @ApiModelProperty(value = "")
  public String getRoleAction() {
    return roleAction;
  }

  public void setRoleAction(String roleAction) {
    this.roleAction = roleAction;
  }

  public GetRoleReplyObj roleItems(List<String> roleItems) {
    this.roleItems = roleItems;
    return this;
  }

  public GetRoleReplyObj addRoleItemsItem(String roleItemsItem) {
    if (this.roleItems == null) {
      this.roleItems = new ArrayList<String>();
    }
    this.roleItems.add(roleItemsItem);
    return this;
  }

   /**
   * Get roleItems
   * @return roleItems
  **/
  @ApiModelProperty(value = "")
  public List<String> getRoleItems() {
    return roleItems;
  }

  public void setRoleItems(List<String> roleItems) {
    this.roleItems = roleItems;
  }

  public GetRoleReplyObj roleName(String roleName) {
    this.roleName = roleName;
    return this;
  }

   /**
   * Get roleName
   * @return roleName
  **/
  @ApiModelProperty(value = "")
  public String getRoleName() {
    return roleName;
  }

  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }

  public GetRoleReplyObj roleUsers(List<String> roleUsers) {
    this.roleUsers = roleUsers;
    return this;
  }

  public GetRoleReplyObj addRoleUsersItem(String roleUsersItem) {
    if (this.roleUsers == null) {
      this.roleUsers = new ArrayList<String>();
    }
    this.roleUsers.add(roleUsersItem);
    return this;
  }

   /**
   * Get roleUsers
   * @return roleUsers
  **/
  @ApiModelProperty(value = "")
  public List<String> getRoleUsers() {
    return roleUsers;
  }

  public void setRoleUsers(List<String> roleUsers) {
    this.roleUsers = roleUsers;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetRoleReplyObj getRoleReplyObj = (GetRoleReplyObj) o;
    return Objects.equals(this.comment, getRoleReplyObj.comment) &&
        Objects.equals(this.roleAction, getRoleReplyObj.roleAction) &&
        Objects.equals(this.roleItems, getRoleReplyObj.roleItems) &&
        Objects.equals(this.roleName, getRoleReplyObj.roleName) &&
        Objects.equals(this.roleUsers, getRoleReplyObj.roleUsers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(comment, roleAction, roleItems, roleName, roleUsers);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetRoleReplyObj {\n");
    
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    roleAction: ").append(toIndentedString(roleAction)).append("\n");
    sb.append("    roleItems: ").append(toIndentedString(roleItems)).append("\n");
    sb.append("    roleName: ").append(toIndentedString(roleName)).append("\n");
    sb.append("    roleUsers: ").append(toIndentedString(roleUsers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

