/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.akeyless.uam.swagger.model.UserAccessInfo;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * GetUserReplyObj
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class GetUserReplyObj {
  @SerializedName("access_info")
  private UserAccessInfo accessInfo = null;

  @SerializedName("account_id")
  private String accountId = null;

  @SerializedName("user_access_id")
  private String userAccessId = null;

  @SerializedName("user_name")
  private String userName = null;

  @SerializedName("user_roles")
  private List<String> userRoles = null;

  public GetUserReplyObj accessInfo(UserAccessInfo accessInfo) {
    this.accessInfo = accessInfo;
    return this;
  }

   /**
   * Get accessInfo
   * @return accessInfo
  **/
  @ApiModelProperty(value = "")
  public UserAccessInfo getAccessInfo() {
    return accessInfo;
  }

  public void setAccessInfo(UserAccessInfo accessInfo) {
    this.accessInfo = accessInfo;
  }

  public GetUserReplyObj accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Get accountId
   * @return accountId
  **/
  @ApiModelProperty(value = "")
  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  public GetUserReplyObj userAccessId(String userAccessId) {
    this.userAccessId = userAccessId;
    return this;
  }

   /**
   * Get userAccessId
   * @return userAccessId
  **/
  @ApiModelProperty(value = "")
  public String getUserAccessId() {
    return userAccessId;
  }

  public void setUserAccessId(String userAccessId) {
    this.userAccessId = userAccessId;
  }

  public GetUserReplyObj userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * Get userName
   * @return userName
  **/
  @ApiModelProperty(value = "")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public GetUserReplyObj userRoles(List<String> userRoles) {
    this.userRoles = userRoles;
    return this;
  }

  public GetUserReplyObj addUserRolesItem(String userRolesItem) {
    if (this.userRoles == null) {
      this.userRoles = new ArrayList<String>();
    }
    this.userRoles.add(userRolesItem);
    return this;
  }

   /**
   * Get userRoles
   * @return userRoles
  **/
  @ApiModelProperty(value = "")
  public List<String> getUserRoles() {
    return userRoles;
  }

  public void setUserRoles(List<String> userRoles) {
    this.userRoles = userRoles;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetUserReplyObj getUserReplyObj = (GetUserReplyObj) o;
    return Objects.equals(this.accessInfo, getUserReplyObj.accessInfo) &&
        Objects.equals(this.accountId, getUserReplyObj.accountId) &&
        Objects.equals(this.userAccessId, getUserReplyObj.userAccessId) &&
        Objects.equals(this.userName, getUserReplyObj.userName) &&
        Objects.equals(this.userRoles, getUserReplyObj.userRoles);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessInfo, accountId, userAccessId, userName, userRoles);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetUserReplyObj {\n");
    
    sb.append("    accessInfo: ").append(toIndentedString(accessInfo)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    userAccessId: ").append(toIndentedString(userAccessId)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    userRoles: ").append(toIndentedString(userRoles)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

