/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * KFM status result
 */
@ApiModel(description = "KFM status result")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class KFMStatusReplyObj {
  @SerializedName("instance-id")
  private String instanceId = null;

  @SerializedName("version")
  private String version = null;

  public KFMStatusReplyObj instanceId(String instanceId) {
    this.instanceId = instanceId;
    return this;
  }

   /**
   * The Id of the KFM instance
   * @return instanceId
  **/
  @ApiModelProperty(value = "The Id of the KFM instance")
  public String getInstanceId() {
    return instanceId;
  }

  public void setInstanceId(String instanceId) {
    this.instanceId = instanceId;
  }

  public KFMStatusReplyObj version(String version) {
    this.version = version;
    return this;
  }

   /**
   * Current KFM version
   * @return version
  **/
  @ApiModelProperty(value = "Current KFM version")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    KFMStatusReplyObj kfMStatusReplyObj = (KFMStatusReplyObj) o;
    return Objects.equals(this.instanceId, kfMStatusReplyObj.instanceId) &&
        Objects.equals(this.version, kfMStatusReplyObj.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(instanceId, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class KFMStatusReplyObj {\n");
    
    sb.append("    instanceId: ").append(toIndentedString(instanceId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

