/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.akeyless.uam.swagger.model.OAuth2CustomClaim;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * OAuth2AccessRole
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class OAuth2AccessRole {
  @SerializedName("audience")
  private String audience = null;

  @SerializedName("bound_claims")
  private List<OAuth2CustomClaim> boundClaims = null;

  @SerializedName("bound_clients_id")
  private List<String> boundClientsId = null;

  @SerializedName("issuer")
  private String issuer = null;

  @SerializedName("jwks_uri")
  private String jwksUri = null;

  public OAuth2AccessRole audience(String audience) {
    this.audience = audience;
    return this;
  }

   /**
   * The audience in the JWT.
   * @return audience
  **/
  @ApiModelProperty(value = "The audience in the JWT.")
  public String getAudience() {
    return audience;
  }

  public void setAudience(String audience) {
    this.audience = audience;
  }

  public OAuth2AccessRole boundClaims(List<OAuth2CustomClaim> boundClaims) {
    this.boundClaims = boundClaims;
    return this;
  }

  public OAuth2AccessRole addBoundClaimsItem(OAuth2CustomClaim boundClaimsItem) {
    if (this.boundClaims == null) {
      this.boundClaims = new ArrayList<OAuth2CustomClaim>();
    }
    this.boundClaims.add(boundClaimsItem);
    return this;
  }

   /**
   * The claims that login is restricted to.
   * @return boundClaims
  **/
  @ApiModelProperty(value = "The claims that login is restricted to.")
  public List<OAuth2CustomClaim> getBoundClaims() {
    return boundClaims;
  }

  public void setBoundClaims(List<OAuth2CustomClaim> boundClaims) {
    this.boundClaims = boundClaims;
  }

  public OAuth2AccessRole boundClientsId(List<String> boundClientsId) {
    this.boundClientsId = boundClientsId;
    return this;
  }

  public OAuth2AccessRole addBoundClientsIdItem(String boundClientsIdItem) {
    if (this.boundClientsId == null) {
      this.boundClientsId = new ArrayList<String>();
    }
    this.boundClientsId.add(boundClientsIdItem);
    return this;
  }

   /**
   * The clients ids that login is restricted to.
   * @return boundClientsId
  **/
  @ApiModelProperty(value = "The clients ids that login is restricted to.")
  public List<String> getBoundClientsId() {
    return boundClientsId;
  }

  public void setBoundClientsId(List<String> boundClientsId) {
    this.boundClientsId = boundClientsId;
  }

  public OAuth2AccessRole issuer(String issuer) {
    this.issuer = issuer;
    return this;
  }

   /**
   * Issuer URL
   * @return issuer
  **/
  @ApiModelProperty(value = "Issuer URL")
  public String getIssuer() {
    return issuer;
  }

  public void setIssuer(String issuer) {
    this.issuer = issuer;
  }

  public OAuth2AccessRole jwksUri(String jwksUri) {
    this.jwksUri = jwksUri;
    return this;
  }

   /**
   * The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.
   * @return jwksUri
  **/
  @ApiModelProperty(value = "The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.")
  public String getJwksUri() {
    return jwksUri;
  }

  public void setJwksUri(String jwksUri) {
    this.jwksUri = jwksUri;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OAuth2AccessRole oauth2AccessRole = (OAuth2AccessRole) o;
    return Objects.equals(this.audience, oauth2AccessRole.audience) &&
        Objects.equals(this.boundClaims, oauth2AccessRole.boundClaims) &&
        Objects.equals(this.boundClientsId, oauth2AccessRole.boundClientsId) &&
        Objects.equals(this.issuer, oauth2AccessRole.issuer) &&
        Objects.equals(this.jwksUri, oauth2AccessRole.jwksUri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(audience, boundClaims, boundClientsId, issuer, jwksUri);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OAuth2AccessRole {\n");
    
    sb.append("    audience: ").append(toIndentedString(audience)).append("\n");
    sb.append("    boundClaims: ").append(toIndentedString(boundClaims)).append("\n");
    sb.append("    boundClientsId: ").append(toIndentedString(boundClientsId)).append("\n");
    sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
    sb.append("    jwksUri: ").append(toIndentedString(jwksUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

