/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.akeyless.uam.swagger.model.DynamicSecretMessageQueueInfo;
import com.akeyless.uam.swagger.model.FragmentsDerivationsCreds;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * The new dynamic secret ID to be pull and derivation credentials to decrypt the value
 */
@ApiModel(description = "The new dynamic secret ID to be pull and derivation credentials to decrypt the value")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class PrepareDynamicSecretValueReplyObj {
  @SerializedName("consumer_protection_key_derivation_creds")
  private FragmentsDerivationsCreds consumerProtectionKeyDerivationCreds = null;

  @SerializedName("dynamic_secret_val_preparation_data")
  private String dynamicSecretValPreparationData = null;

  @SerializedName("dynamic_secret_value_id")
  private String dynamicSecretValueId = null;

  @SerializedName("mq_info")
  private DynamicSecretMessageQueueInfo mqInfo = null;

  public PrepareDynamicSecretValueReplyObj consumerProtectionKeyDerivationCreds(FragmentsDerivationsCreds consumerProtectionKeyDerivationCreds) {
    this.consumerProtectionKeyDerivationCreds = consumerProtectionKeyDerivationCreds;
    return this;
  }

   /**
   * Get consumerProtectionKeyDerivationCreds
   * @return consumerProtectionKeyDerivationCreds
  **/
  @ApiModelProperty(value = "")
  public FragmentsDerivationsCreds getConsumerProtectionKeyDerivationCreds() {
    return consumerProtectionKeyDerivationCreds;
  }

  public void setConsumerProtectionKeyDerivationCreds(FragmentsDerivationsCreds consumerProtectionKeyDerivationCreds) {
    this.consumerProtectionKeyDerivationCreds = consumerProtectionKeyDerivationCreds;
  }

  public PrepareDynamicSecretValueReplyObj dynamicSecretValPreparationData(String dynamicSecretValPreparationData) {
    this.dynamicSecretValPreparationData = dynamicSecretValPreparationData;
    return this;
  }

   /**
   * An attached data by the client about the dynamic secret value preparation request
   * @return dynamicSecretValPreparationData
  **/
  @ApiModelProperty(value = "An attached data by the client about the dynamic secret value preparation request")
  public String getDynamicSecretValPreparationData() {
    return dynamicSecretValPreparationData;
  }

  public void setDynamicSecretValPreparationData(String dynamicSecretValPreparationData) {
    this.dynamicSecretValPreparationData = dynamicSecretValPreparationData;
  }

  public PrepareDynamicSecretValueReplyObj dynamicSecretValueId(String dynamicSecretValueId) {
    this.dynamicSecretValueId = dynamicSecretValueId;
    return this;
  }

   /**
   * The ID of the new dynamic secret value to be pull
   * @return dynamicSecretValueId
  **/
  @ApiModelProperty(value = "The ID of the new dynamic secret value to be pull")
  public String getDynamicSecretValueId() {
    return dynamicSecretValueId;
  }

  public void setDynamicSecretValueId(String dynamicSecretValueId) {
    this.dynamicSecretValueId = dynamicSecretValueId;
  }

  public PrepareDynamicSecretValueReplyObj mqInfo(DynamicSecretMessageQueueInfo mqInfo) {
    this.mqInfo = mqInfo;
    return this;
  }

   /**
   * Get mqInfo
   * @return mqInfo
  **/
  @ApiModelProperty(value = "")
  public DynamicSecretMessageQueueInfo getMqInfo() {
    return mqInfo;
  }

  public void setMqInfo(DynamicSecretMessageQueueInfo mqInfo) {
    this.mqInfo = mqInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrepareDynamicSecretValueReplyObj prepareDynamicSecretValueReplyObj = (PrepareDynamicSecretValueReplyObj) o;
    return Objects.equals(this.consumerProtectionKeyDerivationCreds, prepareDynamicSecretValueReplyObj.consumerProtectionKeyDerivationCreds) &&
        Objects.equals(this.dynamicSecretValPreparationData, prepareDynamicSecretValueReplyObj.dynamicSecretValPreparationData) &&
        Objects.equals(this.dynamicSecretValueId, prepareDynamicSecretValueReplyObj.dynamicSecretValueId) &&
        Objects.equals(this.mqInfo, prepareDynamicSecretValueReplyObj.mqInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(consumerProtectionKeyDerivationCreds, dynamicSecretValPreparationData, dynamicSecretValueId, mqInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrepareDynamicSecretValueReplyObj {\n");
    
    sb.append("    consumerProtectionKeyDerivationCreds: ").append(toIndentedString(consumerProtectionKeyDerivationCreds)).append("\n");
    sb.append("    dynamicSecretValPreparationData: ").append(toIndentedString(dynamicSecretValPreparationData)).append("\n");
    sb.append("    dynamicSecretValueId: ").append(toIndentedString(dynamicSecretValueId)).append("\n");
    sb.append("    mqInfo: ").append(toIndentedString(mqInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

