/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Temporary access credentials to perform decrypt operation on a fragments from KFM instances together with the KFMs host names.
 */
@ApiModel(description = "Temporary access credentials to perform decrypt operation on a fragments from KFM instances together with the KFMs host names.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class RSADecryptCredsReplyObj {
  @SerializedName("KFMsHostsDNSMap")
  private Map<String, String> kfMsHostsDNSMap = null;

  @SerializedName("certificates")
  private String certificates = null;

  @SerializedName("credential")
  private String credential = null;

  @SerializedName("customer_fragment_id")
  private String customerFragmentId = null;

  @SerializedName("expiry")
  private Long expiry = null;

  @SerializedName("item_id")
  private Long itemId = null;

  @SerializedName("item_name")
  private String itemName = null;

  @SerializedName("item_size")
  private Long itemSize = null;

  @SerializedName("item_type")
  private String itemType = null;

  @SerializedName("item_version")
  private Integer itemVersion = null;

  @SerializedName("public_value")
  private String publicValue = null;

  public RSADecryptCredsReplyObj kfMsHostsDNSMap(Map<String, String> kfMsHostsDNSMap) {
    this.kfMsHostsDNSMap = kfMsHostsDNSMap;
    return this;
  }

  public RSADecryptCredsReplyObj putKfMsHostsDNSMapItem(String key, String kfMsHostsDNSMapItem) {
    if (this.kfMsHostsDNSMap == null) {
      this.kfMsHostsDNSMap = new HashMap<String, String>();
    }
    this.kfMsHostsDNSMap.put(key, kfMsHostsDNSMapItem);
    return this;
  }

   /**
   * Mapping between the serial number of the item fragments and the KFMs hosts DNS in which they are stored.
   * @return kfMsHostsDNSMap
  **/
  @ApiModelProperty(value = "Mapping between the serial number of the item fragments and the KFMs hosts DNS in which they are stored.")
  public Map<String, String> getKfMsHostsDNSMap() {
    return kfMsHostsDNSMap;
  }

  public void setKfMsHostsDNSMap(Map<String, String> kfMsHostsDNSMap) {
    this.kfMsHostsDNSMap = kfMsHostsDNSMap;
  }

  public RSADecryptCredsReplyObj certificates(String certificates) {
    this.certificates = certificates;
    return this;
  }

   /**
   * Get certificates
   * @return certificates
  **/
  @ApiModelProperty(value = "")
  public String getCertificates() {
    return certificates;
  }

  public void setCertificates(String certificates) {
    this.certificates = certificates;
  }

  public RSADecryptCredsReplyObj credential(String credential) {
    this.credential = credential;
    return this;
  }

   /**
   * Temporary credentials string (JWT format)
   * @return credential
  **/
  @ApiModelProperty(value = "Temporary credentials string (JWT format)")
  public String getCredential() {
    return credential;
  }

  public void setCredential(String credential) {
    this.credential = credential;
  }

  public RSADecryptCredsReplyObj customerFragmentId(String customerFragmentId) {
    this.customerFragmentId = customerFragmentId;
    return this;
  }

   /**
   * The customer fragment ID associated with this item (if any).
   * @return customerFragmentId
  **/
  @ApiModelProperty(value = "The customer fragment ID associated with this item (if any).")
  public String getCustomerFragmentId() {
    return customerFragmentId;
  }

  public void setCustomerFragmentId(String customerFragmentId) {
    this.customerFragmentId = customerFragmentId;
  }

  public RSADecryptCredsReplyObj expiry(Long expiry) {
    this.expiry = expiry;
    return this;
  }

   /**
   * Credentials expiration date
   * @return expiry
  **/
  @ApiModelProperty(value = "Credentials expiration date")
  public Long getExpiry() {
    return expiry;
  }

  public void setExpiry(Long expiry) {
    this.expiry = expiry;
  }

  public RSADecryptCredsReplyObj itemId(Long itemId) {
    this.itemId = itemId;
    return this;
  }

   /**
   * Get itemId
   * @return itemId
  **/
  @ApiModelProperty(value = "")
  public Long getItemId() {
    return itemId;
  }

  public void setItemId(Long itemId) {
    this.itemId = itemId;
  }

  public RSADecryptCredsReplyObj itemName(String itemName) {
    this.itemName = itemName;
    return this;
  }

   /**
   * The name, id, version, type, size and public key value of the item that the fragments belong to
   * @return itemName
  **/
  @ApiModelProperty(value = "The name, id, version, type, size and public key value of the item that the fragments belong to")
  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  public RSADecryptCredsReplyObj itemSize(Long itemSize) {
    this.itemSize = itemSize;
    return this;
  }

   /**
   * Get itemSize
   * @return itemSize
  **/
  @ApiModelProperty(value = "")
  public Long getItemSize() {
    return itemSize;
  }

  public void setItemSize(Long itemSize) {
    this.itemSize = itemSize;
  }

  public RSADecryptCredsReplyObj itemType(String itemType) {
    this.itemType = itemType;
    return this;
  }

   /**
   * Get itemType
   * @return itemType
  **/
  @ApiModelProperty(value = "")
  public String getItemType() {
    return itemType;
  }

  public void setItemType(String itemType) {
    this.itemType = itemType;
  }

  public RSADecryptCredsReplyObj itemVersion(Integer itemVersion) {
    this.itemVersion = itemVersion;
    return this;
  }

   /**
   * Get itemVersion
   * @return itemVersion
  **/
  @ApiModelProperty(value = "")
  public Integer getItemVersion() {
    return itemVersion;
  }

  public void setItemVersion(Integer itemVersion) {
    this.itemVersion = itemVersion;
  }

  public RSADecryptCredsReplyObj publicValue(String publicValue) {
    this.publicValue = publicValue;
    return this;
  }

   /**
   * Get publicValue
   * @return publicValue
  **/
  @ApiModelProperty(value = "")
  public String getPublicValue() {
    return publicValue;
  }

  public void setPublicValue(String publicValue) {
    this.publicValue = publicValue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RSADecryptCredsReplyObj rsADecryptCredsReplyObj = (RSADecryptCredsReplyObj) o;
    return Objects.equals(this.kfMsHostsDNSMap, rsADecryptCredsReplyObj.kfMsHostsDNSMap) &&
        Objects.equals(this.certificates, rsADecryptCredsReplyObj.certificates) &&
        Objects.equals(this.credential, rsADecryptCredsReplyObj.credential) &&
        Objects.equals(this.customerFragmentId, rsADecryptCredsReplyObj.customerFragmentId) &&
        Objects.equals(this.expiry, rsADecryptCredsReplyObj.expiry) &&
        Objects.equals(this.itemId, rsADecryptCredsReplyObj.itemId) &&
        Objects.equals(this.itemName, rsADecryptCredsReplyObj.itemName) &&
        Objects.equals(this.itemSize, rsADecryptCredsReplyObj.itemSize) &&
        Objects.equals(this.itemType, rsADecryptCredsReplyObj.itemType) &&
        Objects.equals(this.itemVersion, rsADecryptCredsReplyObj.itemVersion) &&
        Objects.equals(this.publicValue, rsADecryptCredsReplyObj.publicValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(kfMsHostsDNSMap, certificates, credential, customerFragmentId, expiry, itemId, itemName, itemSize, itemType, itemVersion, publicValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RSADecryptCredsReplyObj {\n");
    
    sb.append("    kfMsHostsDNSMap: ").append(toIndentedString(kfMsHostsDNSMap)).append("\n");
    sb.append("    certificates: ").append(toIndentedString(certificates)).append("\n");
    sb.append("    credential: ").append(toIndentedString(credential)).append("\n");
    sb.append("    customerFragmentId: ").append(toIndentedString(customerFragmentId)).append("\n");
    sb.append("    expiry: ").append(toIndentedString(expiry)).append("\n");
    sb.append("    itemId: ").append(toIndentedString(itemId)).append("\n");
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    itemSize: ").append(toIndentedString(itemSize)).append("\n");
    sb.append("    itemType: ").append(toIndentedString(itemType)).append("\n");
    sb.append("    itemVersion: ").append(toIndentedString(itemVersion)).append("\n");
    sb.append("    publicValue: ").append(toIndentedString(publicValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

