/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.akeyless.uam.swagger.model.FragmentsDerivationsCreds;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Temporary access credentials to get an access to the secret key protection fragments from KFM instances together with the KFMs host names and the encrypted secret value.
 */
@ApiModel(description = "Temporary access credentials to get an access to the secret key protection fragments from KFM instances together with the KFMs host names and the encrypted secret value.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class SecretAccessCredsReplyObj {
  @SerializedName("protection_key_derivation_creds")
  private FragmentsDerivationsCreds protectionKeyDerivationCreds = null;

  @SerializedName("secret_enc_val")
  private String secretEncVal = null;

  @SerializedName("secret_id")
  private Long secretId = null;

  @SerializedName("secret_name")
  private String secretName = null;

  @SerializedName("secret_type")
  private String secretType = null;

  @SerializedName("secret_version")
  private Integer secretVersion = null;

  public SecretAccessCredsReplyObj protectionKeyDerivationCreds(FragmentsDerivationsCreds protectionKeyDerivationCreds) {
    this.protectionKeyDerivationCreds = protectionKeyDerivationCreds;
    return this;
  }

   /**
   * Get protectionKeyDerivationCreds
   * @return protectionKeyDerivationCreds
  **/
  @ApiModelProperty(value = "")
  public FragmentsDerivationsCreds getProtectionKeyDerivationCreds() {
    return protectionKeyDerivationCreds;
  }

  public void setProtectionKeyDerivationCreds(FragmentsDerivationsCreds protectionKeyDerivationCreds) {
    this.protectionKeyDerivationCreds = protectionKeyDerivationCreds;
  }

  public SecretAccessCredsReplyObj secretEncVal(String secretEncVal) {
    this.secretEncVal = secretEncVal;
    return this;
  }

   /**
   * The encrypted secret value.
   * @return secretEncVal
  **/
  @ApiModelProperty(value = "The encrypted secret value.")
  public String getSecretEncVal() {
    return secretEncVal;
  }

  public void setSecretEncVal(String secretEncVal) {
    this.secretEncVal = secretEncVal;
  }

  public SecretAccessCredsReplyObj secretId(Long secretId) {
    this.secretId = secretId;
    return this;
  }

   /**
   * Get secretId
   * @return secretId
  **/
  @ApiModelProperty(value = "")
  public Long getSecretId() {
    return secretId;
  }

  public void setSecretId(Long secretId) {
    this.secretId = secretId;
  }

  public SecretAccessCredsReplyObj secretName(String secretName) {
    this.secretName = secretName;
    return this;
  }

   /**
   * The name, id, version and type of the secret item
   * @return secretName
  **/
  @ApiModelProperty(value = "The name, id, version and type of the secret item")
  public String getSecretName() {
    return secretName;
  }

  public void setSecretName(String secretName) {
    this.secretName = secretName;
  }

  public SecretAccessCredsReplyObj secretType(String secretType) {
    this.secretType = secretType;
    return this;
  }

   /**
   * Get secretType
   * @return secretType
  **/
  @ApiModelProperty(value = "")
  public String getSecretType() {
    return secretType;
  }

  public void setSecretType(String secretType) {
    this.secretType = secretType;
  }

  public SecretAccessCredsReplyObj secretVersion(Integer secretVersion) {
    this.secretVersion = secretVersion;
    return this;
  }

   /**
   * Get secretVersion
   * @return secretVersion
  **/
  @ApiModelProperty(value = "")
  public Integer getSecretVersion() {
    return secretVersion;
  }

  public void setSecretVersion(Integer secretVersion) {
    this.secretVersion = secretVersion;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SecretAccessCredsReplyObj secretAccessCredsReplyObj = (SecretAccessCredsReplyObj) o;
    return Objects.equals(this.protectionKeyDerivationCreds, secretAccessCredsReplyObj.protectionKeyDerivationCreds) &&
        Objects.equals(this.secretEncVal, secretAccessCredsReplyObj.secretEncVal) &&
        Objects.equals(this.secretId, secretAccessCredsReplyObj.secretId) &&
        Objects.equals(this.secretName, secretAccessCredsReplyObj.secretName) &&
        Objects.equals(this.secretType, secretAccessCredsReplyObj.secretType) &&
        Objects.equals(this.secretVersion, secretAccessCredsReplyObj.secretVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(protectionKeyDerivationCreds, secretEncVal, secretId, secretName, secretType, secretVersion);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SecretAccessCredsReplyObj {\n");
    
    sb.append("    protectionKeyDerivationCreds: ").append(toIndentedString(protectionKeyDerivationCreds)).append("\n");
    sb.append("    secretEncVal: ").append(toIndentedString(secretEncVal)).append("\n");
    sb.append("    secretId: ").append(toIndentedString(secretId)).append("\n");
    sb.append("    secretName: ").append(toIndentedString(secretName)).append("\n");
    sb.append("    secretType: ").append(toIndentedString(secretType)).append("\n");
    sb.append("    secretVersion: ").append(toIndentedString(secretVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

