/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.akeyless.uam.swagger.model.AccessRules;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * SetUAMAccessCredsParams
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class SetUAMAccessCredsParams {
  @SerializedName("access_rules_type")
  private String accessRulesType = null;

  @SerializedName("expires")
  private Long expires = null;

  @SerializedName("rules")
  private AccessRules rules = null;

  @SerializedName("update_modes")
  private List<String> updateModes = null;

  public SetUAMAccessCredsParams accessRulesType(String accessRulesType) {
    this.accessRulesType = accessRulesType;
    return this;
  }

   /**
   * Get accessRulesType
   * @return accessRulesType
  **/
  @ApiModelProperty(value = "")
  public String getAccessRulesType() {
    return accessRulesType;
  }

  public void setAccessRulesType(String accessRulesType) {
    this.accessRulesType = accessRulesType;
  }

  public SetUAMAccessCredsParams expires(Long expires) {
    this.expires = expires;
    return this;
  }

   /**
   * Access expiration date (Unix timestamp).
   * @return expires
  **/
  @ApiModelProperty(value = "Access expiration date (Unix timestamp).")
  public Long getExpires() {
    return expires;
  }

  public void setExpires(Long expires) {
    this.expires = expires;
  }

  public SetUAMAccessCredsParams rules(AccessRules rules) {
    this.rules = rules;
    return this;
  }

   /**
   * Get rules
   * @return rules
  **/
  @ApiModelProperty(value = "")
  public AccessRules getRules() {
    return rules;
  }

  public void setRules(AccessRules rules) {
    this.rules = rules;
  }

  public SetUAMAccessCredsParams updateModes(List<String> updateModes) {
    this.updateModes = updateModes;
    return this;
  }

  public SetUAMAccessCredsParams addUpdateModesItem(String updateModesItem) {
    if (this.updateModes == null) {
      this.updateModes = new ArrayList<String>();
    }
    this.updateModes.add(updateModesItem);
    return this;
  }

   /**
   * Array of access parameters names to be updated (update_key, update_exp, update_cidr). All the parameters will be updated in case of empty array
   * @return updateModes
  **/
  @ApiModelProperty(value = "Array of access parameters names to be updated (update_key, update_exp, update_cidr). All the parameters will be updated in case of empty array")
  public List<String> getUpdateModes() {
    return updateModes;
  }

  public void setUpdateModes(List<String> updateModes) {
    this.updateModes = updateModes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SetUAMAccessCredsParams setUAMAccessCredsParams = (SetUAMAccessCredsParams) o;
    return Objects.equals(this.accessRulesType, setUAMAccessCredsParams.accessRulesType) &&
        Objects.equals(this.expires, setUAMAccessCredsParams.expires) &&
        Objects.equals(this.rules, setUAMAccessCredsParams.rules) &&
        Objects.equals(this.updateModes, setUAMAccessCredsParams.updateModes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessRulesType, expires, rules, updateModes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SetUAMAccessCredsParams {\n");
    
    sb.append("    accessRulesType: ").append(toIndentedString(accessRulesType)).append("\n");
    sb.append("    expires: ").append(toIndentedString(expires)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("    updateModes: ").append(toIndentedString(updateModes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

