/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * SystemUserCredentialsReplyObj
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class SystemUserCredentialsReplyObj {
  @SerializedName("auth_creds")
  private String authCreds = null;

  @SerializedName("expiry")
  private Long expiry = null;

  @SerializedName("kfm_creds")
  private String kfmCreds = null;

  @SerializedName("uam_creds")
  private String uamCreds = null;

  public SystemUserCredentialsReplyObj authCreds(String authCreds) {
    this.authCreds = authCreds;
    return this;
  }

   /**
   * Temporary credentials for accessing Auth
   * @return authCreds
  **/
  @ApiModelProperty(value = "Temporary credentials for accessing Auth")
  public String getAuthCreds() {
    return authCreds;
  }

  public void setAuthCreds(String authCreds) {
    this.authCreds = authCreds;
  }

  public SystemUserCredentialsReplyObj expiry(Long expiry) {
    this.expiry = expiry;
    return this;
  }

   /**
   * Credentials expiration date
   * @return expiry
  **/
  @ApiModelProperty(value = "Credentials expiration date")
  public Long getExpiry() {
    return expiry;
  }

  public void setExpiry(Long expiry) {
    this.expiry = expiry;
  }

  public SystemUserCredentialsReplyObj kfmCreds(String kfmCreds) {
    this.kfmCreds = kfmCreds;
    return this;
  }

   /**
   * Temporary credentials for accessing the KFMs instances
   * @return kfmCreds
  **/
  @ApiModelProperty(value = "Temporary credentials for accessing the KFMs instances")
  public String getKfmCreds() {
    return kfmCreds;
  }

  public void setKfmCreds(String kfmCreds) {
    this.kfmCreds = kfmCreds;
  }

  public SystemUserCredentialsReplyObj uamCreds(String uamCreds) {
    this.uamCreds = uamCreds;
    return this;
  }

   /**
   * Temporary credentials for accessing the UAM service
   * @return uamCreds
  **/
  @ApiModelProperty(value = "Temporary credentials for accessing the UAM service")
  public String getUamCreds() {
    return uamCreds;
  }

  public void setUamCreds(String uamCreds) {
    this.uamCreds = uamCreds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SystemUserCredentialsReplyObj systemUserCredentialsReplyObj = (SystemUserCredentialsReplyObj) o;
    return Objects.equals(this.authCreds, systemUserCredentialsReplyObj.authCreds) &&
        Objects.equals(this.expiry, systemUserCredentialsReplyObj.expiry) &&
        Objects.equals(this.kfmCreds, systemUserCredentialsReplyObj.kfmCreds) &&
        Objects.equals(this.uamCreds, systemUserCredentialsReplyObj.uamCreds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authCreds, expiry, kfmCreds, uamCreds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SystemUserCredentialsReplyObj {\n");
    
    sb.append("    authCreds: ").append(toIndentedString(authCreds)).append("\n");
    sb.append("    expiry: ").append(toIndentedString(expiry)).append("\n");
    sb.append("    kfmCreds: ").append(toIndentedString(kfmCreds)).append("\n");
    sb.append("    uamCreds: ").append(toIndentedString(uamCreds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

