/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * UAM status result
 */
@ApiModel(description = "UAM status result")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class UAMStatusReplyObj {
  @SerializedName("auth_dns")
  private String authDns = null;

  @SerializedName("kfm_instances")
  private String kfmInstances = null;

  @SerializedName("version")
  private String version = null;

  public UAMStatusReplyObj authDns(String authDns) {
    this.authDns = authDns;
    return this;
  }

   /**
   * The DNS of the Auth server
   * @return authDns
  **/
  @ApiModelProperty(value = "The DNS of the Auth server")
  public String getAuthDns() {
    return authDns;
  }

  public void setAuthDns(String authDns) {
    this.authDns = authDns;
  }

  public UAMStatusReplyObj kfmInstances(String kfmInstances) {
    this.kfmInstances = kfmInstances;
    return this;
  }

   /**
   * The IDs of the KFM instances the UAM server works with
   * @return kfmInstances
  **/
  @ApiModelProperty(value = "The IDs of the KFM instances the UAM server works with")
  public String getKfmInstances() {
    return kfmInstances;
  }

  public void setKfmInstances(String kfmInstances) {
    this.kfmInstances = kfmInstances;
  }

  public UAMStatusReplyObj version(String version) {
    this.version = version;
    return this;
  }

   /**
   * Current UAM version
   * @return version
  **/
  @ApiModelProperty(value = "Current UAM version")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UAMStatusReplyObj uaMStatusReplyObj = (UAMStatusReplyObj) o;
    return Objects.equals(this.authDns, uaMStatusReplyObj.authDns) &&
        Objects.equals(this.kfmInstances, uaMStatusReplyObj.kfmInstances) &&
        Objects.equals(this.version, uaMStatusReplyObj.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authDns, kfmInstances, version);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UAMStatusReplyObj {\n");
    
    sb.append("    authDns: ").append(toIndentedString(authDns)).append("\n");
    sb.append("    kfmInstances: ").append(toIndentedString(kfmInstances)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

