/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Temporary access credentials to upload RSA private key fragments into KFMs instances
 */
@ApiModel(description = "Temporary access credentials to upload RSA private key fragments into KFMs instances")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class UploadRSAKeyCredsReplyObj {
  @SerializedName("KFMsHostsDNSMap")
  private Map<String, String> kfMsHostsDNSMap = null;

  @SerializedName("credential")
  private String credential = null;

  @SerializedName("expiry")
  private Long expiry = null;

  public UploadRSAKeyCredsReplyObj kfMsHostsDNSMap(Map<String, String> kfMsHostsDNSMap) {
    this.kfMsHostsDNSMap = kfMsHostsDNSMap;
    return this;
  }

  public UploadRSAKeyCredsReplyObj putKfMsHostsDNSMapItem(String key, String kfMsHostsDNSMapItem) {
    if (this.kfMsHostsDNSMap == null) {
      this.kfMsHostsDNSMap = new HashMap<String, String>();
    }
    this.kfMsHostsDNSMap.put(key, kfMsHostsDNSMapItem);
    return this;
  }

   /**
   * Mapping between the serial number of the RSA key fragments and the KFMs hosts DNS to which the fragments should be uploaded.
   * @return kfMsHostsDNSMap
  **/
  @ApiModelProperty(value = "Mapping between the serial number of the RSA key fragments and the KFMs hosts DNS to which the fragments should be uploaded.")
  public Map<String, String> getKfMsHostsDNSMap() {
    return kfMsHostsDNSMap;
  }

  public void setKfMsHostsDNSMap(Map<String, String> kfMsHostsDNSMap) {
    this.kfMsHostsDNSMap = kfMsHostsDNSMap;
  }

  public UploadRSAKeyCredsReplyObj credential(String credential) {
    this.credential = credential;
    return this;
  }

   /**
   * Temporary credentials string (JWT format)
   * @return credential
  **/
  @ApiModelProperty(value = "Temporary credentials string (JWT format)")
  public String getCredential() {
    return credential;
  }

  public void setCredential(String credential) {
    this.credential = credential;
  }

  public UploadRSAKeyCredsReplyObj expiry(Long expiry) {
    this.expiry = expiry;
    return this;
  }

   /**
   * Credentials expiration date
   * @return expiry
  **/
  @ApiModelProperty(value = "Credentials expiration date")
  public Long getExpiry() {
    return expiry;
  }

  public void setExpiry(Long expiry) {
    this.expiry = expiry;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UploadRSAKeyCredsReplyObj uploadRSAKeyCredsReplyObj = (UploadRSAKeyCredsReplyObj) o;
    return Objects.equals(this.kfMsHostsDNSMap, uploadRSAKeyCredsReplyObj.kfMsHostsDNSMap) &&
        Objects.equals(this.credential, uploadRSAKeyCredsReplyObj.credential) &&
        Objects.equals(this.expiry, uploadRSAKeyCredsReplyObj.expiry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(kfMsHostsDNSMap, credential, expiry);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UploadRSAKeyCredsReplyObj {\n");
    
    sb.append("    kfMsHostsDNSMap: ").append(toIndentedString(kfMsHostsDNSMap)).append("\n");
    sb.append("    credential: ").append(toIndentedString(credential)).append("\n");
    sb.append("    expiry: ").append(toIndentedString(expiry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

