/*
 * UAM - Application API
 * UAM manages client accounts and allows each client to define users, roles and master keys. The core operations of UAM are as follows: Creating new accounts. For each account: Creating new master keys. Adding new users Adding new roles Attaching roles to users. Attaching roles to keys. Returning the key's metadata together with temporary access credentials in order to access the key fragments.
 *
 * OpenAPI spec version: 1.0.7
 * Contact: refael@akeyless-security.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.akeyless.uam.swagger.model;

import java.util.Objects;
import com.akeyless.uam.swagger.model.AzureADAccessRole;
import com.akeyless.uam.swagger.model.OAuth2AccessRole;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * UserAccessInfo
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-07-17T16:07:54.829+03:00")
public class UserAccessInfo {
  @SerializedName("access_expires")
  private Long accessExpires = null;

  @SerializedName("api_key_alg")
  private String apiKeyAlg = null;

  @SerializedName("azure_ad_access_role")
  private AzureADAccessRole azureAdAccessRole = null;

  @SerializedName("cidr_whitelist")
  private String cidrWhitelist = null;

  @SerializedName("oauth2_access_role")
  private OAuth2AccessRole oauth2AccessRole = null;

  @SerializedName("rules_type")
  private String rulesType = null;

  public UserAccessInfo accessExpires(Long accessExpires) {
    this.accessExpires = accessExpires;
    return this;
  }

   /**
   * Get accessExpires
   * @return accessExpires
  **/
  @ApiModelProperty(value = "")
  public Long getAccessExpires() {
    return accessExpires;
  }

  public void setAccessExpires(Long accessExpires) {
    this.accessExpires = accessExpires;
  }

  public UserAccessInfo apiKeyAlg(String apiKeyAlg) {
    this.apiKeyAlg = apiKeyAlg;
    return this;
  }

   /**
   * Get apiKeyAlg
   * @return apiKeyAlg
  **/
  @ApiModelProperty(value = "")
  public String getApiKeyAlg() {
    return apiKeyAlg;
  }

  public void setApiKeyAlg(String apiKeyAlg) {
    this.apiKeyAlg = apiKeyAlg;
  }

  public UserAccessInfo azureAdAccessRole(AzureADAccessRole azureAdAccessRole) {
    this.azureAdAccessRole = azureAdAccessRole;
    return this;
  }

   /**
   * Get azureAdAccessRole
   * @return azureAdAccessRole
  **/
  @ApiModelProperty(value = "")
  public AzureADAccessRole getAzureAdAccessRole() {
    return azureAdAccessRole;
  }

  public void setAzureAdAccessRole(AzureADAccessRole azureAdAccessRole) {
    this.azureAdAccessRole = azureAdAccessRole;
  }

  public UserAccessInfo cidrWhitelist(String cidrWhitelist) {
    this.cidrWhitelist = cidrWhitelist;
    return this;
  }

   /**
   * Get cidrWhitelist
   * @return cidrWhitelist
  **/
  @ApiModelProperty(value = "")
  public String getCidrWhitelist() {
    return cidrWhitelist;
  }

  public void setCidrWhitelist(String cidrWhitelist) {
    this.cidrWhitelist = cidrWhitelist;
  }

  public UserAccessInfo oauth2AccessRole(OAuth2AccessRole oauth2AccessRole) {
    this.oauth2AccessRole = oauth2AccessRole;
    return this;
  }

   /**
   * Get oauth2AccessRole
   * @return oauth2AccessRole
  **/
  @ApiModelProperty(value = "")
  public OAuth2AccessRole getOauth2AccessRole() {
    return oauth2AccessRole;
  }

  public void setOauth2AccessRole(OAuth2AccessRole oauth2AccessRole) {
    this.oauth2AccessRole = oauth2AccessRole;
  }

  public UserAccessInfo rulesType(String rulesType) {
    this.rulesType = rulesType;
    return this;
  }

   /**
   * Get rulesType
   * @return rulesType
  **/
  @ApiModelProperty(value = "")
  public String getRulesType() {
    return rulesType;
  }

  public void setRulesType(String rulesType) {
    this.rulesType = rulesType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserAccessInfo userAccessInfo = (UserAccessInfo) o;
    return Objects.equals(this.accessExpires, userAccessInfo.accessExpires) &&
        Objects.equals(this.apiKeyAlg, userAccessInfo.apiKeyAlg) &&
        Objects.equals(this.azureAdAccessRole, userAccessInfo.azureAdAccessRole) &&
        Objects.equals(this.cidrWhitelist, userAccessInfo.cidrWhitelist) &&
        Objects.equals(this.oauth2AccessRole, userAccessInfo.oauth2AccessRole) &&
        Objects.equals(this.rulesType, userAccessInfo.rulesType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessExpires, apiKeyAlg, azureAdAccessRole, cidrWhitelist, oauth2AccessRole, rulesType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserAccessInfo {\n");
    
    sb.append("    accessExpires: ").append(toIndentedString(accessExpires)).append("\n");
    sb.append("    apiKeyAlg: ").append(toIndentedString(apiKeyAlg)).append("\n");
    sb.append("    azureAdAccessRole: ").append(toIndentedString(azureAdAccessRole)).append("\n");
    sb.append("    cidrWhitelist: ").append(toIndentedString(cidrWhitelist)).append("\n");
    sb.append("    oauth2AccessRole: ").append(toIndentedString(oauth2AccessRole)).append("\n");
    sb.append("    rulesType: ").append(toIndentedString(rulesType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

