/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.util.ArgParser;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class JournalManagerBench {
    private final byte[] NULLS = new byte[65536];
    private final String[] ARG_TEMPLATE = new String[]{"duration|int:10:10:86400|Duration of test in seconds", "policy|String:HARD|Commit policy: SOFT, HARD or GROUP", "datapath|String:/tmp/persistit_test_data|Datapath property", "buffersize|int:64:1:1024|Emulated journal buffer size in MBytes", "extension|int:0:0:1024|MBytes by which to extend file when full", "prealloc|int:0:0:1024|Preallocated file size in MBytes", "align|int:1:1:65536|Blocking factor for I/O size", "recsize|int:123:64:65536|Emulated transaction record size"};
    final ByteBuffer buffer;
    final ArgParser ap;
    private File file;
    private FileChannel fc;
    private long writeAddress = 0L;
    private long currentAddress = 0L;
    long count = 0L;
    long minTime = Long.MAX_VALUE;
    long maxTime = Long.MIN_VALUE;
    final byte[] bytes = new byte[65536];

    public static void main(String[] args) throws Exception {
        JournalManagerBench jmb = new JournalManagerBench(args);
        jmb.runTest();
    }

    private JournalManagerBench(String[] args) throws Exception {
        this.ap = new ArgParser("JournalManagerBench", args, this.ARG_TEMPLATE).strict();
        this.buffer = ByteBuffer.allocate(this.ap.getIntValue("buffersize") * 1024 * 1024);
    }

    private void runTest() throws Exception {
        this.file = new File(this.ap.getStringValue("datapath"), "JManBench_TestFile");
        this.fc = new RandomAccessFile(this.file, "rw").getChannel();
        this.preallocateFile(this.ap.getIntValue("prealloc") * 1024 * 1024);
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = 45;
        }
        int align = this.ap.getIntValue("align");
        long extension = this.ap.getIntValue("extension") * 1024 * 1024;
        long start = System.nanoTime();
        long expires = start + (long)this.ap.getIntValue("duration") * 1000000000L;
        long now = System.nanoTime();
        while (now < expires) {
            this.doOneCycle(now - start, align, extension, 100);
            long then = System.nanoTime();
            ++this.count;
            this.minTime = Math.min(this.minTime, then - now);
            this.maxTime = Math.max(this.maxTime, then - now);
            now = then;
        }
        long elapsed = now - start;
        System.out.printf("%,d commits took %,dms at a rate of %,d/second minimum time=%,dns maximumTime=%,dns\n", this.count, elapsed, this.count * 1000000000L / elapsed, this.minTime, this.maxTime);
    }

    private void preallocateFile(long size) throws Exception {
        if (size > 0L && this.fc.size() > size) {
            System.out.printf("Truncating file %s from %,d to %,d\n", this.file, this.fc.size(), size);
            this.fc.truncate(size);
        } else if (this.fc.size() < size) {
            long remaining;
            System.out.printf("Preallocating file %s to size %,d ", this.file, size);
            while ((remaining = size - this.fc.size()) > 0L) {
                if (remaining > (long)this.buffer.capacity()) {
                    remaining = this.buffer.capacity();
                    long unaligned = this.fc.size() % 16384L;
                    if (unaligned > 0L) {
                        remaining -= 16384L - unaligned;
                    }
                }
                this.buffer.position(0).limit((int)remaining);
                this.fc.write(this.buffer, this.fc.size());
                System.out.print(".");
            }
            this.fc.force(true);
            System.out.println("done");
        }
    }

    private void doOneCycle(long time, int align, long extension, int size) throws Exception {
        String header = String.format("\nsize=%06d count=%06d time=%012d\n", size, this.count, time);
        byte[] b = header.getBytes();
        System.arraycopy(b, 0, this.bytes, 0, b.length);
        int toRewrite = (int)(this.currentAddress - this.writeAddress);
        this.buffer.position(toRewrite);
        this.buffer.put(this.bytes, 0, size);
        boolean extended = false;
        int position = this.buffer.position();
        if (extension > 0L) {
            long currentSize = this.fc.size();
            if (this.writeAddress + (long)this.buffer.position() > currentSize) {
                long newSize = currentSize + extension;
                if (newSize - this.writeAddress > (long)this.buffer.capacity()) {
                    newSize = this.writeAddress + (long)this.buffer.capacity();
                    assert (newSize > currentSize);
                }
                for (int add = (int)(newSize - this.writeAddress - (long)this.buffer.position()); add > 0; add -= this.NULLS.length) {
                    this.buffer.put(this.NULLS, 0, Math.min(this.NULLS.length, add));
                }
                extended = true;
            }
        }
        this.buffer.flip();
        this.fc.write(this.buffer, this.writeAddress);
        this.fc.force(extended);
        this.currentAddress = this.writeAddress + (long)position;
        this.buffer.limit(position);
        position = position / align * align;
        this.buffer.position(position);
        this.buffer.compact();
        this.writeAddress += (long)position;
    }
}

