/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.encoding;

import com.persistit.Key;
import com.persistit.KeyState;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class ObjectCache {
    public static final Object NULL = new Object();
    public static final int DEFAULT_INITIAL_SIZE = 16;
    private Entry[] _entries = new Entry[16];
    private int _size;
    private int _deadCount;
    private final int _deadCountThreshold = 25;
    private final ReferenceQueue<SoftReference<?>> _queue = new ReferenceQueue();

    public synchronized void clear() {
        this._entries = new Entry[16];
        this._size = 0;
        this._deadCount = 0;
    }

    public synchronized void clean() {
        this.processQueue(0);
        this.resize();
    }

    public synchronized Object put(Key key, Object value) {
        if (value == null) {
            value = NULL;
        }
        Object previousValue = null;
        boolean found = false;
        int offset = this.offset(key, this._entries.length);
        Entry entry = this._entries[offset];
        while (entry != null && !found) {
            if (entry._key.equals(key)) {
                found = true;
                previousValue = entry._reference.get();
                if (previousValue != NULL) continue;
                previousValue = null;
                continue;
            }
            entry = entry._next;
        }
        if (!found) {
            entry = new Entry();
            entry._key = new KeyState(key);
            entry._next = this._entries[offset];
            this._entries[offset] = entry;
            ++this._size;
        }
        entry._reference = new SoftReference((SoftReference<?>)value, this._queue);
        this.processQueue(25);
        if ((double)this._size > (double)this._entries.length * 0.75) {
            this.resize();
        }
        return previousValue;
    }

    public synchronized Object get(Key key) {
        int offset = this.offset(key, this._entries.length);
        Entry entry = this._entries[offset];
        while (entry != null) {
            if (entry._key.equals(key)) {
                Object value = entry._reference.get();
                if (value == NULL) {
                    return null;
                }
                return value;
            }
            entry = entry._next;
        }
        return null;
    }

    public synchronized Object getWithNull(Key key) {
        int offset = this.offset(key, this._entries.length);
        Entry entry = this._entries[offset];
        while (entry != null) {
            if (entry._key.equals(key)) {
                Object value = entry._reference.get();
                return value;
            }
            entry = entry._next;
        }
        return null;
    }

    public synchronized boolean isCached(Key key) {
        int offset = this.offset(key, this._entries.length);
        Entry entry = this._entries[offset];
        while (entry != null) {
            if (entry._key.equals(key)) {
                return true;
            }
            entry = entry._next;
        }
        return false;
    }

    public synchronized Object remove(Key key) {
        Object value = null;
        int offset = this.offset(key, this._entries.length);
        Entry entry = this._entries[offset];
        if (entry == null) {
            return null;
        }
        if (entry._key.equals(key)) {
            this._entries[offset] = entry._next;
            --this._size;
            value = entry._reference.get();
        } else {
            Entry next = entry._next;
            while (next != null) {
                if (next._key.equals(key)) {
                    entry._next = next._next;
                    --this._size;
                    value = next._reference.get();
                    break;
                }
                entry = next;
                next = entry._next;
            }
        }
        this.processQueue(25);
        if ((double)this._size < (double)this._entries.length * 0.25) {
            this.resize();
        }
        return value;
    }

    private void resize() {
        int newSize = this._size * 2;
        if (newSize < 16) {
            newSize = 16;
        }
        if (this._entries.length > newSize && this._entries.length < newSize + 16) {
            return;
        }
        Entry[] newEntries = new Entry[newSize];
        for (int offset = 0; offset < this._entries.length; ++offset) {
            Entry entry = this._entries[offset];
            while (entry != null) {
                int newOffset = this.offset(entry._key, newSize);
                Entry next = entry._next;
                entry._next = newEntries[newOffset];
                newEntries[newOffset] = entry;
                entry = next;
            }
        }
        this._entries = newEntries;
    }

    private void processQueue(int deadCountThreshold) {
        while (this._queue.poll() != null) {
            ++this._deadCount;
        }
        if (this._deadCount > deadCountThreshold) {
            for (int index = 0; index < this._entries.length; ++index) {
                Entry next;
                Entry entry = this._entries[index];
                while (entry != null && entry._reference.get() == null) {
                    entry = this._entries[index] = entry._next;
                    --this._size;
                }
                if (entry == null) continue;
                while ((next = entry._next) != null) {
                    if (next._reference.get() == null) {
                        entry._next = next._next;
                        --this._size;
                        continue;
                    }
                    entry = entry._next;
                }
            }
            this._deadCount = 0;
        }
    }

    private int offset(Object key, int length) {
        return (key.hashCode() & Integer.MAX_VALUE) % length;
    }

    private static class Entry {
        Object _key;
        SoftReference<?> _reference;
        Entry _next;

        private Entry() {
        }
    }
}

