/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.common;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.plugin.common.ReferencePluginConfig;
import io.cdap.plugin.hubspot.common.ObjectType;
import javax.annotation.Nullable;

public class BaseHubspotConfig
extends ReferencePluginConfig {
    public static final String API_SERVER_URL = "apiServerUrl";
    public static final String OBJECT_TYPE = "objectType";
    public static final String AUTHORIZATION_TOKEN = "authToken";
    public static final String DEFAULT_API_SERVER_URL = "https://api.hubapi.com";
    @Name(value="apiServerUrl")
    @Description(value="Api Server Url. Not visible, by default null, can be redefined")
    @Macro
    @Nullable
    public String apiServerUrl;
    @Name(value="objectType")
    @Description(value="Name of object to pull from Hubspot.")
    @Macro
    public String objectType;
    @Name(value="authToken")
    @Description(value="Private App Access token")
    @Macro
    public String authToken;

    public BaseHubspotConfig(String referenceName) {
        super(referenceName);
    }

    public BaseHubspotConfig(String referenceName, String apiServerUrl, String objectType, String authToken) {
        super(referenceName);
        this.apiServerUrl = apiServerUrl;
        this.objectType = objectType;
        this.authToken = authToken;
    }

    public ObjectType getObjectType() {
        return ObjectType.fromString(this.objectType);
    }

    public String getApiServerUrl() {
        String apiServerUrl = DEFAULT_API_SERVER_URL;
        if (this.apiServerUrl != null && !this.apiServerUrl.isEmpty()) {
            apiServerUrl = this.apiServerUrl;
        }
        return apiServerUrl;
    }
}

