/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.common;

import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.hubspot.common.HubspotHelper;
import io.cdap.plugin.hubspot.common.ObjectType;
import io.cdap.plugin.hubspot.common.ReportEndpoint;
import io.cdap.plugin.hubspot.common.SourceHubspotConfig;
import io.cdap.plugin.hubspot.common.TimePeriod;
import io.cdap.plugin.hubspot.sink.batch.SinkHubspotConfig;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ConfigValidator {
    public static void validateTimePeriod(SourceHubspotConfig sourceHubspotConfig, FailureCollector failureCollector) {
        if (sourceHubspotConfig.containsMacro("timePeriod")) {
            return;
        }
        try {
            TimePeriod period = sourceHubspotConfig.getTimePeriod();
            if (!sourceHubspotConfig.containsMacro("reportType") && sourceHubspotConfig.getReportEndpoint().equals((Object)ReportEndpoint.TOTALS)) {
                switch (period) {
                    case MONTHLY: 
                    case WEEKLY: 
                    case DAILY: {
                        failureCollector.addFailure(String.format("Time period '%s' is not valid for '%s'.", sourceHubspotConfig.timePeriod, sourceHubspotConfig.reportType), "Use summarized Time Periods for totals.").withConfigProperty("timePeriod");
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            failureCollector.addFailure(String.format("Time period '%s' is not valid.", sourceHubspotConfig.timePeriod), "Select one of: total, daily, weekly, monthly, summarize/daily, summarize/weekly, summarize/monthly").withConfigProperty("timePeriod");
        }
    }

    static void validateFilters(SourceHubspotConfig sourceHubspotConfig, FailureCollector failureCollector) {
        if (sourceHubspotConfig.containsMacro("filters") || sourceHubspotConfig.containsMacro("timePeriod")) {
            return;
        }
        List<String> filters = sourceHubspotConfig.getFilters();
        switch (sourceHubspotConfig.getTimePeriod()) {
            case MONTHLY: 
            case WEEKLY: 
            case DAILY: {
                if (filters == null || filters.isEmpty()) {
                    failureCollector.addFailure("NO filters defined.", "When using daily, weekly, or monthly for the time_period, you must include at least one filter.").withConfigProperty("filters");
                }
                for (String filter : filters) {
                    if (filters == null || filters.isEmpty()) {
                        failureCollector.addFailure("Filter must not be empty.", null).withConfigProperty("filters");
                        continue;
                    }
                    if (filter.matches("\\w+")) continue;
                    failureCollector.addFailure(String.format("Filter '%s' is not a valid filter", filter), "Filter must one word without special symbols").withConfigProperty("filters");
                }
                break;
            }
        }
    }

    static void validateReportType(SourceHubspotConfig sourceHubspotConfig, FailureCollector failureCollector) {
        if (sourceHubspotConfig.containsMacro("reportType")) {
            return;
        }
        try {
            switch (sourceHubspotConfig.getReportType()) {
                case REPORT_CATEGORY: {
                    if (sourceHubspotConfig.containsMacro("reportCategory")) {
                        return;
                    }
                    try {
                        sourceHubspotConfig.getReportEndpoint(sourceHubspotConfig.reportCategory);
                    }
                    catch (IllegalArgumentException e) {
                        failureCollector.addFailure(String.format("Report Category '%s' is not valid.", sourceHubspotConfig.reportCategory), null).withConfigProperty("reportCategory");
                    }
                    break;
                }
                case REPORT_OBJECT: {
                    if (sourceHubspotConfig.containsMacro("reportObject")) {
                        return;
                    }
                    try {
                        sourceHubspotConfig.getReportEndpoint(sourceHubspotConfig.reportObject);
                    }
                    catch (IllegalArgumentException e) {
                        failureCollector.addFailure(String.format("Report Object '%s' is not valid.", sourceHubspotConfig.reportObject), null).withConfigProperty("reportObject");
                    }
                    break;
                }
                case REPORT_CONTENT: {
                    if (sourceHubspotConfig.containsMacro("reportContent")) {
                        return;
                    }
                    try {
                        sourceHubspotConfig.getReportEndpoint(sourceHubspotConfig.reportContent);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        failureCollector.addFailure(String.format("Report Content '%s' is not valid.", sourceHubspotConfig.reportContent), null).withConfigProperty("reportContent");
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            failureCollector.addFailure(String.format("Report Type '%s' is not valid.", sourceHubspotConfig.reportType), null).withConfigProperty("reportType");
        }
    }

    protected static void validateObjectType(SourceHubspotConfig sourceHubspotConfig, FailureCollector failureCollector) {
        if (sourceHubspotConfig.containsMacro("objectType")) {
            return;
        }
        try {
            sourceHubspotConfig.getObjectType();
        }
        catch (IllegalArgumentException e) {
            failureCollector.addFailure(String.format("Object Type '%s' is not valid.", sourceHubspotConfig.objectType), null).withConfigProperty("objectType");
        }
    }

    protected static void validateAuthorization(SourceHubspotConfig sourceHubspotConfig, FailureCollector failureCollector) {
        if (sourceHubspotConfig.containsMacro("timePeriod") || sourceHubspotConfig.containsMacro("filters") || sourceHubspotConfig.containsMacro("reportType") || sourceHubspotConfig.containsMacro("objectType") || sourceHubspotConfig.containsMacro("authToken") || sourceHubspotConfig.containsMacro("startDate") || sourceHubspotConfig.containsMacro("endDate")) {
            return;
        }
        try {
            new HubspotHelper().getHubspotPage(sourceHubspotConfig, null);
        }
        catch (IOException e) {
            if (e.getMessage().toLowerCase().contains("forbidden")) {
                failureCollector.addFailure("Api endpoint not accessible with provided Api Key.", null).withConfigProperty("authToken");
            }
            failureCollector.addFailure("Api endpoint not accessible with provided configuration.", null);
        }
    }

    protected static void validateDateRange(SourceHubspotConfig sourceHubspotConfig, FailureCollector failureCollector) {
        if (sourceHubspotConfig.containsMacro("startDate") || sourceHubspotConfig.containsMacro("endDate")) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyDDmm");
        Date startDate = null;
        Date endDate = null;
        if (sourceHubspotConfig.startDate == null || sourceHubspotConfig.startDate.isEmpty()) {
            failureCollector.addFailure("Start Date not defined for ANALYTICS object selected.", "Use YYYYMMDD date format.").withConfigProperty("startDate");
        }
        if (sourceHubspotConfig.endDate == null || sourceHubspotConfig.endDate.isEmpty()) {
            failureCollector.addFailure("End Date not defined for ANALYTICS object selected.", "Use YYYYMMDD date format.").withConfigProperty("endDate");
        }
        if (sourceHubspotConfig.startDate != null && sourceHubspotConfig.endDate != null) {
            try {
                startDate = simpleDateFormat.parse(sourceHubspotConfig.startDate);
            }
            catch (ParseException e) {
                failureCollector.addFailure("Invalid startDate format.", "Use YYYYMMDD date format.").withConfigProperty("startDate");
            }
            try {
                endDate = simpleDateFormat.parse(sourceHubspotConfig.endDate);
            }
            catch (ParseException e) {
                failureCollector.addFailure("Invalid endDate format.", "Use YYYYMMDD date format.").withConfigProperty("endDate");
            }
            if (startDate != null && endDate != null && startDate.after(endDate)) {
                failureCollector.addFailure("startDate must be earlier than endDate.", "Enter valid date.");
            }
        }
    }

    public static void validateSinkObjectType(SinkHubspotConfig sinkHubspotConfig, FailureCollector failureCollector) {
        if (sinkHubspotConfig.containsMacro("objectType")) {
            return;
        }
        try {
            ObjectType type = sinkHubspotConfig.getObjectType();
            switch (type) {
                case CONTACT_LISTS: 
                case CONTACTS: 
                case COMPANIES: 
                case DEALS: 
                case DEAL_PIPELINES: 
                case MARKETING_EMAIL: 
                case PRODUCTS: 
                case TICKETS: {
                    return;
                }
            }
            failureCollector.addFailure(String.format("Object Type '%s' is not supported.", sinkHubspotConfig.objectType), null).withConfigProperty("objectType");
        }
        catch (IllegalArgumentException e) {
            failureCollector.addFailure(String.format("Object Type '%s' is not valid.", sinkHubspotConfig.objectType), null).withConfigProperty("objectType");
        }
    }
}

