/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.hubspot.common.HubspotPage;
import io.cdap.plugin.hubspot.common.SourceHubspotConfig;
import io.cdap.plugin.hubspot.common.TimePeriod;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class HubspotHelper {
    private static final int MAX_TRIES = 3;
    public static final String PAGE_SIZE = "100";

    public HubspotPage getHubspotPage(SourceHubspotConfig sourceHubspotConfig, String offset) throws IOException {
        HttpGet request = this.getRequest(sourceHubspotConfig, offset);
        CloseableHttpResponse response = this.downloadPage(sourceHubspotConfig, request);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String result = EntityUtils.toString((HttpEntity)entity);
            return this.parseJson(sourceHubspotConfig, result);
        }
        return null;
    }

    private CloseableHttpResponse downloadPage(SourceHubspotConfig sourceHubspotConfig, HttpGet request) throws IOException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient client = httpClientBuilder.build();
        int count = 0;
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() >= 300) {
            if (500 > statusLine.getStatusCode() && statusLine.getStatusCode() >= 400) {
                throw new IOException(statusLine.getReasonPhrase());
            }
            if (++count == 3) {
                throw new IOException(statusLine.getReasonPhrase());
            }
        }
        return response;
    }

    private HttpGet getRequest(SourceHubspotConfig sourceHubspotConfig, String offset) {
        URI uri = null;
        try {
            URIBuilder b = new URIBuilder(this.getEndpoint(sourceHubspotConfig));
            if (sourceHubspotConfig.startDate != null) {
                b.addParameter("start", sourceHubspotConfig.startDate);
            }
            if (sourceHubspotConfig.endDate != null) {
                b.addParameter("end", sourceHubspotConfig.endDate);
            }
            for (String filter : sourceHubspotConfig.getFilters()) {
                b.addParameter("f", filter);
            }
            if (this.getLimitPropertyName(sourceHubspotConfig) != null) {
                b.addParameter(this.getLimitPropertyName(sourceHubspotConfig), PAGE_SIZE);
            }
            if (offset != null && this.getOffsetPropertyName(sourceHubspotConfig) != null) {
                b.addParameter(this.getOffsetPropertyName(sourceHubspotConfig), offset);
            }
            uri = b.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Can't build valid uri", e);
        }
        HttpGet request = new HttpGet(uri);
        if (sourceHubspotConfig.authToken != null) {
            request.addHeader("Authorization", String.format("Bearer %s", sourceHubspotConfig.authToken));
        }
        return request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HubspotPage parseJson(SourceHubspotConfig sourceHubspotConfig, String json) throws IOException {
        JsonElement root = new JsonParser().parse(json);
        JsonObject jsonObject = root.getAsJsonObject();
        ArrayList<JsonElement> hubspotObjects = new ArrayList<JsonElement>();
        String objectApiName = this.getObjectApiName(sourceHubspotConfig);
        if (objectApiName != null) {
            JsonElement jsonObjects = jsonObject.get(objectApiName);
            if (jsonObjects == null || !jsonObjects.isJsonArray()) throw new IOException(String.format("Not expected JSON response format, '%s' element not found or wrong type", objectApiName));
            JsonArray jsonObjectsArray = jsonObjects.getAsJsonArray();
            for (JsonElement jsonElement : jsonObjectsArray) {
                hubspotObjects.add(jsonElement);
            }
        } else {
            hubspotObjects.add(root);
        }
        Boolean hasNext = null;
        String moreApiName = this.getMoreApiName(sourceHubspotConfig);
        if (moreApiName != null) {
            JsonElement hasNextElement = jsonObject.get(moreApiName);
            if (hasNextElement == null) throw new IOException(String.format("Not expected JSON response format, '%s' element not found or wrong type", moreApiName));
            hasNext = hasNextElement.getAsBoolean();
        }
        String offset = null;
        String offsetApiName = this.getOffsetApiName(sourceHubspotConfig);
        if (offsetApiName == null) return new HubspotPage(hubspotObjects, sourceHubspotConfig, offset, hasNext);
        JsonElement offsetElement = jsonObject.get(offsetApiName);
        if (offsetElement == null) throw new IOException(String.format("Not expected JSON response format, '%s' element not found or wrong type", offsetApiName));
        offset = offsetElement.getAsString();
        JsonElement totalElement = jsonObject.get("total");
        if (hasNext != null || totalElement == null) return new HubspotPage(hubspotObjects, sourceHubspotConfig, offset, hasNext);
        hasNext = !offset.equals(totalElement.getAsString()) && !offset.equals("0");
        return new HubspotPage(hubspotObjects, sourceHubspotConfig, offset, hasNext);
    }

    @Nullable
    private String getLimitPropertyName(SourceHubspotConfig sourceHubspotConfig) {
        switch (sourceHubspotConfig.getObjectType()) {
            case CONTACT_LISTS: 
            case RECENT_COMPANIES: 
            case COMPANIES: 
            case CONTACTS: {
                return "count";
            }
            case EMAIL_EVENTS: 
            case EMAIL_SUBSCRIPTION: 
            case DEALS: 
            case MARKETING_EMAIL: 
            case ANALYTICS: {
                return "limit";
            }
        }
        return null;
    }

    @Nullable
    private String getOffsetPropertyName(SourceHubspotConfig sourceHubspotConfig) {
        switch (sourceHubspotConfig.getObjectType()) {
            case CONTACT_LISTS: 
            case RECENT_COMPANIES: 
            case COMPANIES: 
            case EMAIL_EVENTS: 
            case EMAIL_SUBSCRIPTION: 
            case DEALS: 
            case MARKETING_EMAIL: 
            case ANALYTICS: 
            case PRODUCTS: 
            case TICKETS: {
                return "offset";
            }
            case CONTACTS: {
                return "vidOffset";
            }
        }
        return null;
    }

    @Nullable
    private String getOffsetApiName(SourceHubspotConfig sourceHubspotConfig) {
        switch (sourceHubspotConfig.getObjectType()) {
            case CONTACT_LISTS: 
            case RECENT_COMPANIES: 
            case COMPANIES: 
            case EMAIL_EVENTS: 
            case EMAIL_SUBSCRIPTION: 
            case DEALS: 
            case MARKETING_EMAIL: 
            case PRODUCTS: 
            case TICKETS: {
                return "offset";
            }
            case ANALYTICS: {
                if (sourceHubspotConfig.getTimePeriod() != null && sourceHubspotConfig.getTimePeriod().equals((Object)TimePeriod.TOTAL)) {
                    return "offset";
                }
                return null;
            }
            case CONTACTS: {
                return "vid-offset";
            }
        }
        return null;
    }

    @Nullable
    private String getMoreApiName(SourceHubspotConfig sourceHubspotConfig) {
        switch (sourceHubspotConfig.getObjectType()) {
            case CONTACT_LISTS: 
            case COMPANIES: 
            case CONTACTS: {
                return "has-more";
            }
            case RECENT_COMPANIES: 
            case EMAIL_EVENTS: 
            case EMAIL_SUBSCRIPTION: 
            case DEALS: 
            case PRODUCTS: 
            case TICKETS: {
                return "hasMore";
            }
        }
        return null;
    }

    @Nullable
    private String getObjectApiName(SourceHubspotConfig sourceHubspotConfig) {
        switch (sourceHubspotConfig.getObjectType()) {
            case CONTACT_LISTS: {
                return "lists";
            }
            case CONTACTS: {
                return "contacts";
            }
            case EMAIL_EVENTS: {
                return "events";
            }
            case EMAIL_SUBSCRIPTION: {
                return "timeline";
            }
            case RECENT_COMPANIES: 
            case DEAL_PIPELINES: {
                return "results";
            }
            case COMPANIES: {
                return "companies";
            }
            case DEALS: {
                return "deals";
            }
            case MARKETING_EMAIL: 
            case PRODUCTS: 
            case TICKETS: {
                return "objects";
            }
            case ANALYTICS: {
                if (sourceHubspotConfig.getTimePeriod() != null && sourceHubspotConfig.getTimePeriod().equals((Object)TimePeriod.TOTAL)) {
                    return "breakdowns";
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    public String getEndpoint(SourceHubspotConfig sourceHubspotConfig) {
        String apiServerUrl = sourceHubspotConfig.getApiServerUrl();
        switch (sourceHubspotConfig.getObjectType()) {
            case CONTACT_LISTS: {
                return String.format("%s/contacts/v1/lists", apiServerUrl);
            }
            case CONTACTS: {
                return String.format("%s/contacts/v1/lists/all/contacts/all", apiServerUrl);
            }
            case EMAIL_EVENTS: {
                return String.format("%s/email/public/v1/events", apiServerUrl);
            }
            case EMAIL_SUBSCRIPTION: {
                return String.format("%s/email/public/v1/subscriptions/timeline", apiServerUrl);
            }
            case RECENT_COMPANIES: {
                return String.format("%s/companies/v2/companies/recent/modified", apiServerUrl);
            }
            case COMPANIES: {
                return String.format("%s/companies/v2/companies/paged", apiServerUrl);
            }
            case DEALS: {
                return String.format("%s/deals/v1/deal/paged", apiServerUrl);
            }
            case DEAL_PIPELINES: {
                return String.format("%s/crm-pipelines/v1/pipelines/deals", apiServerUrl);
            }
            case MARKETING_EMAIL: {
                return String.format("%s/marketing-emails/v1/emails", apiServerUrl);
            }
            case PRODUCTS: {
                return String.format("%s/crm-objects/v1/objects/products/paged", apiServerUrl);
            }
            case TICKETS: {
                return String.format("%s/crm-objects/v1/objects/tickets/paged", apiServerUrl);
            }
            case ANALYTICS: {
                return String.format("%s/analytics/v2/reports/%s/%s", apiServerUrl, sourceHubspotConfig.getReportEndpoint().getStringValue(), sourceHubspotConfig.getTimePeriod().getStringValue());
            }
        }
        return null;
    }

    public static StructuredRecord transform(String value, SourceHubspotConfig config) {
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)config.getSchema());
        builder.set("objectType", (Object)config.objectType);
        builder.set("object", (Object)value);
        return builder.build();
    }
}

