/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.common;

import com.google.gson.JsonElement;
import io.cdap.plugin.hubspot.common.HubspotHelper;
import io.cdap.plugin.hubspot.common.HubspotPage;
import io.cdap.plugin.hubspot.common.SourceHubspotConfig;
import java.io.IOException;
import java.util.Iterator;

public class HubspotPagesIterator
implements Iterator<JsonElement> {
    private HubspotPage currentPage;
    private Iterator<JsonElement> currentPageIterator;
    private int iteratorPosition = 0;
    private String currentPageOffset;

    public HubspotPagesIterator(SourceHubspotConfig config, HubspotPage currentPage, String currentPageOffset) {
        this.currentPage = currentPage;
        this.currentPageIterator = currentPage.getIterator();
        this.currentPageOffset = currentPageOffset;
    }

    public HubspotPagesIterator(SourceHubspotConfig config, String offset) throws IOException {
        this(config, new HubspotHelper().getHubspotPage(config, offset), offset);
    }

    public HubspotPagesIterator(SourceHubspotConfig config) throws IOException {
        this(config, null);
    }

    public void switchPageIfNeeded() throws IOException {
        if (!this.currentPageIterator.hasNext()) {
            HubspotPage nextPage = this.currentPage.nextPage();
            if (nextPage != null) {
                this.iteratorPosition = 0;
                this.currentPageOffset = this.currentPage.getOffset();
                this.currentPage = nextPage;
                this.currentPageIterator = this.currentPage.getIterator();
            } else {
                this.currentPageIterator = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        try {
            this.switchPageIfNeeded();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to switch to next page", e);
        }
        return this.currentPageIterator != null;
    }

    @Override
    public JsonElement next() {
        ++this.iteratorPosition;
        return this.currentPageIterator.next();
    }

    public String getCurrentPageOffset() {
        return this.currentPageOffset;
    }

    public int getIteratorPosition() {
        return this.iteratorPosition;
    }

    public HubspotPage getCurrentPage() {
        return this.currentPage;
    }

    public void setIteratorPosition(int iteratorPosition) {
        this.currentPageIterator = this.currentPage.getIterator();
        for (int i = 0; i < iteratorPosition && this.currentPageIterator.hasNext(); ++i) {
            this.next();
        }
    }
}

